/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.service;

import kd.bos.context.OperationContextCreator;
import kd.bos.mservice.keepalive.LivingKeeperUtils;
import kd.bos.redis.JedisClient;
import org.apache.log4j.Logger;

public class LivingKeeper
implements Runnable {
    private String instanceKey;
    private String host;
    private int intervalSecond;
    private static Logger logger = Logger.getLogger(LivingKeeper.class);

    public LivingKeeper(String instanceId, String ip, String port, int intervalSecond) {
        this.instanceKey = LivingKeeperUtils.PRE + instanceId;
        this.host = ip + ":" + port;
        this.intervalSecond = intervalSecond;
    }

    @Override
    public void run() {
        try (JedisClient jedis = LivingKeeperUtils.createLivingMonitorJedisClient();){
            jedis.setex(this.instanceKey, this.intervalSecond * Integer.getInteger("bos.livingkeeper.period", 20) + 1, this.host);
        }
        catch (Exception e) {
            OperationContextCreator.getOrCreateForBos();
            logger.error((Object)"LivingKeeper keep node alive error!", (Throwable)e);
        }
    }
}

