/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.service;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.monitor.httpserver.InnerHandler;
import kd.bos.monitor.service.simulation.Simulate;
import kd.bos.monitor.service.simulation.SimulationFactory;
import kd.bos.monitor.util.UriQuery;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.indicator.IndicatorValInfo;
import kd.bos.mservice.monitor.healthmanage.inspect.IndicatorsInspect;
import kd.bos.mservice.monitor.healthmanage.node.NodeHealth;
import kd.bos.util.resource.Resources;

public class NodeHealthHandler
extends InnerHandler {
    private static final Log logger = LogFactory.getLog(NodeHealthHandler.class);

    public NodeHealthHandler(String context) {
        super(context);
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        try {
            String simulationtype;
            Map<String, String> params = UriQuery.toMap(exchange.getRequestURI().getRawQuery());
            if (Boolean.getBoolean("node.malfunction.simulation.enable") && (simulationtype = params.get("simulationtype")) != null) {
                boolean isRecovery = "true".equals(params.get("recover"));
                this.praseSimultation(simulationtype, exchange, isRecovery);
                return;
            }
            List indicatorsLs = IndicatorsInspect.getAllHelathIndicators();
            boolean isShowCansresponse = "true".equals(params.get("showcanresponse"));
            StringBuilder sb = new StringBuilder();
            NodeInfo ninfo = MonitorConfig.getNodeInfo();
            String ip = ninfo.getIp() + ":" + ninfo.getWebPort();
            String title = Resources.getString((String)"", (String)"NodeHealthHandler_1", (String)"bos-monitor", (Object[])new Object[0]) + "" + ip + "/" + Instance.getInstanceId();
            sb.append("<h1 id='").append(ip).append("'>").append(title).append("</h1>");
            if ("true".equals(System.getProperty("node.malfunction.showhealth", "true"))) {
                sb.append("<tr>");
                sb.append("</tr><br><br>");
                sb.append(" node health  is : ");
                sb.append(NodeHealth.getNodeHealth()).append("<br/>indicator detail:<br/>");
                sb.append("<table border=\"1\" cellpadding=\"5\"> <tr><th>name</th><th>value</th><th>detail</th></tr>");
                for (IndicatorValInfo indicator : indicatorsLs) {
                    sb.append("<tr>");
                    sb.append("<td> ").append(indicator.getName()).append(" </td><td> ").append(HealthLevel.from((int)indicator.getLevel())).append(" </td><td> ").append(indicator.getHealthDetail()).append("</td>");
                    sb.append("</tr>");
                }
                sb.append("</table>");
            }
            if (isShowCansresponse) {
                sb.append("<br/> canResponse:").append(NodeHealth.canResponse());
            }
            this.writeHtml(sb.toString(), exchange);
        }
        catch (Exception e) {
            this.writeHtml("featch exception ! " + e, exchange);
            logger.error("featch exception exception", (Throwable)e);
        }
    }

    private void praseSimultation(String simulationtype, HttpExchange exchange, boolean isRecovery) throws IOException {
        Simulate simulate = SimulationFactory.getSimulate(simulationtype);
        if (simulate != null) {
            if (isRecovery) {
                simulate.stop();
                this.writeHtml(Resources.getString((String)"\u6062\u590d\u6545\u969c\u6a21\u62df:  ", (String)"NodeHealthHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + simulationtype, exchange);
            } else if (!simulate.isStart()) {
                this.writeHtml(Resources.getString((String)"\u5f00\u59cb\u6545\u969c\u6a21\u62df:  ", (String)"NodeHealthHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + simulationtype, exchange);
                simulate.start();
            } else {
                this.writeHtml(Resources.getString((String)"\u5f00\u59cb\u6545\u969c\u6a21\u62df:  ", (String)"NodeHealthHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + simulationtype + "<br>   " + simulationtype + Resources.getString((String)"\u6545\u969c\u6a21\u62df\u8fdb\u884c\u4e2d,\u5f53\u524d\u72b6\u6001 :<br>", (String)"NodeHealthHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + simulate.getStatus(), exchange);
            }
        }
    }

    private void outPrintTitle(PrintWriter out, Map<String, String> params, String proxyurl, String uri, boolean isWebNode) {
        String ip = MonitorConfig.getNodeInfo().getIp();
        String title = Resources.getString((String)"\u7ebf\u7a0b\u5806\u6808", (String)"NodeHealthHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + ":" + ip + "/" + Instance.getInstanceId();
        out.println("<center><h1 id='" + ip + "'>" + title + "</h1></center>");
        out.println("<tr>");
        out.println("</tr><br><br>");
    }
}

