/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.service.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.JSONUtils;

public class ChartsJsonGenertor {
    private List<OneChart> chartsLs = new ArrayList<OneChart>(2);

    public OneChart createChart() {
        OneChart s = new OneChart();
        this.chartsLs.add(s);
        return s;
    }

    private Object toJsonObj() {
        ArrayList charts = new ArrayList(2);
        this.chartsLs.forEach(chart -> charts.add(((OneChart)chart).toJsonObj()));
        return charts;
    }

    public String toChartsJsonStr() {
        try {
            return JSONUtils.toString((Object)this.toJsonObj());
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.jSONParsing, new Object[]{e});
        }
    }

    public static class Series {
        private String label;
        private String beanName;
        private String beanAttribute = "Value";
        private String beanPath;

        public Series withLable(String label) {
            this.label = label;
            return this;
        }

        public Series withBeanName(String beanName) {
            this.beanName = beanName;
            return this;
        }

        public Series withBeanAttribute(String beanAttribute) {
            this.beanAttribute = beanAttribute;
            return this;
        }

        public Series withBeanPath(String beanPath) {
            this.beanPath = beanPath;
            return this;
        }

        private Map<String, Object> toJsonObj() {
            HashMap<String, Object> m = new HashMap<String, Object>(2);
            m.put("label", this.label);
            HashMap<String, String> mbeanMap = new HashMap<String, String>(4);
            m.put("mbean", mbeanMap);
            mbeanMap.put("name", this.beanName);
            mbeanMap.put("attribute", this.beanAttribute);
            if (this.beanPath != null) {
                mbeanMap.put("path", this.beanPath);
            }
            return m;
        }
    }

    public static class OneChart {
        private String title;
        private String showLegend = "false";
        List<Series> seriesLs = new ArrayList<Series>(2);

        public OneChart withTitle(String title) {
            this.title = title;
            return this;
        }

        public OneChart withShowLegend(String showLegend) {
            this.showLegend = showLegend;
            return this;
        }

        public Series createSeries() {
            Series s = new Series();
            this.seriesLs.add(s);
            return s;
        }

        private Map<String, Object> toJsonObj() {
            HashMap<String, Object> m = new HashMap<String, Object>(2);
            m.put("title", this.title);
            m.put("showLegend", this.showLegend);
            ArrayList series = new ArrayList(2);
            m.put("series", series);
            this.seriesLs.forEach(serie -> series.add(((Series)serie).toJsonObj()));
            return m;
        }
    }
}

