/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.service.jmx;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Set;
import kd.bos.bundle.BosRes;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.service.jmx.ChartsJsonGenertor;
import kd.bos.mservice.monitor.healthmanage.inspect.TpsMetric;

public class NodeHealthJsonHandler
extends AbstractHttpHandler {
    @Override
    public void handle0(HttpExchange pExchange) throws IOException {
        byte[] response = this.getJson();
        pExchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        pExchange.sendResponseHeaders(202, response.length);
        pExchange.getResponseBody().write(response);
        pExchange.close();
    }

    private byte[] getJson() throws IOException {
        ChartsJsonGenertor genertor = new ChartsJsonGenertor();
        ChartsJsonGenertor.OneChart ochart = genertor.createChart();
        ochart.withTitle(BosRes.get((String)"bos-monitor", (String)"NodeHealthJsonHandler_5", (String)"RPC\u8f6c\u53d1TPS", (Object[])new Object[0])).withShowLegend("true");
        String metricType = "rpc";
        Set metricKeys = TpsMetric.getInstance().getAllMetricKeys(metricType);
        metricKeys.forEach(key -> {
            String keyTitle = key.substring(("kd.metrics.mservice.nodetps." + metricType + "--").length());
            ChartsJsonGenertor.Series series = ochart.createSeries();
            series.withLable("tps-" + keyTitle);
            series.withBeanName("kd.metrics:type=gauges,name=" + key);
            ChartsJsonGenertor.OneChart instanceChart = genertor.createChart();
            instanceChart.withTitle(BosRes.get((String)"bos-monitor", (String)"NodeHealthJsonHandler_3", (String)"\u8282\u70b9TPS(", (Object[])new Object[0]) + metricType + ") " + keyTitle);
            instanceChart.createSeries().withLable("tps").withBeanName("kd.metrics:type=gauges,name=" + key);
            instanceChart.createSeries().withLable(BosRes.get((String)"bos-monitor", (String)"NodeHealthJsonHandler_4", (String)"\u5065\u5eb7\u7b49\u7ea7", (Object[])new Object[0])).withBeanName("kd.metrics:type=gauges,name=" + key.replaceAll("nodetps", "nodeChealth"));
        });
        return genertor.toChartsJsonStr().getBytes("UTF-8");
    }
}

