/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.servletadapter;

import com.google.common.io.ByteStreams;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.monitor.httpserver.Redirectable;
import kd.bos.util.StringUtils;

public class ServletExchangeImpl
extends HttpExchange
implements Redirectable {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private final Headers requestHeaders;
    private final Headers responseHeaders;
    private final ByteArrayOutputStream out;
    private final OutputStream outputStream;
    private static final String NOT_GOOD = "ServletExchangeImpl not good.";

    public ServletExchangeImpl(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.requestHeaders = new Headers();
        Enumeration enu = request.getHeaderNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String header = request.getHeader(name);
            if (!StringUtils.isNotEmpty((String)header)) continue;
            this.requestHeaders.add(name, header);
        }
        this.responseHeaders = new Headers();
        for (String name : response.getHeaderNames()) {
            String header = request.getHeader(name);
            if (!StringUtils.isNotEmpty((String)header)) continue;
            this.responseHeaders.add(name, header);
        }
        this.out = new ByteArrayOutputStream();
        this.outputStream = this.createOutputStream();
    }

    private OutputStream createOutputStream() {
        return new FilterOutputStream(this.out){

            @Override
            public void close() {
                ServletExchangeImpl.this.close();
            }
        };
    }

    @Override
    public Headers getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public Headers getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public URI getRequestURI() {
        try {
            if (this.request.getQueryString() != null) {
                return new URI(this.request.getRequestURI() + "?" + this.request.getQueryString());
            }
            return new URI(this.request.getRequestURI());
        }
        catch (URISyntaxException e) {
            try {
                return new URI(this.request.getRequestURI());
            }
            catch (URISyntaxException ignored) {
                return null;
            }
        }
    }

    @Override
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public HttpContext getHttpContext() {
        throw new RuntimeException(NOT_GOOD);
    }

    @Override
    public void close() {
        for (String key : this.responseHeaders.keySet()) {
            this.response.setHeader(key, this.responseHeaders.getFirst(key));
        }
        try (ServletOutputStream outputStream = this.response.getOutputStream();){
            this.outputStream.flush();
            byte[] bytes = this.out.toByteArray();
            try (ByteArrayInputStream byteArrayOutputStream = new ByteArrayInputStream(bytes);){
                ByteStreams.copy((InputStream)byteArrayOutputStream, (OutputStream)outputStream);
            }
            this.response.setContentLengthLong((long)bytes.length);
        }
        catch (IOException e) {
            return;
        }
    }

    private void closeStream(ServletOutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                return;
            }
        }
    }

    @Override
    public InputStream getRequestBody() {
        try {
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(NOT_GOOD);
        }
    }

    @Override
    public OutputStream getResponseBody() {
        return this.outputStream;
    }

    @Override
    public void sendResponseHeaders(int resCode, long length) throws IOException {
        if (resCode == 200) {
            this.response.setContentLengthLong(length);
        }
        this.response.setStatus(resCode);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.request.getRemoteHost(), this.request.getRemotePort());
    }

    @Override
    public int getResponseCode() {
        return this.response.getStatus();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        throw new RuntimeException(NOT_GOOD);
    }

    @Override
    public String getProtocol() {
        return this.request.getProtocol();
    }

    @Override
    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public void setStreams(InputStream p0, OutputStream p1) {
        throw new RuntimeException(NOT_GOOD);
    }

    @Override
    public HttpPrincipal getPrincipal() {
        throw new RuntimeException(NOT_GOOD);
    }

    @Override
    public void sendRedirect(String url) throws IOException {
        for (String key : this.responseHeaders.keySet()) {
            this.response.setHeader(key, this.responseHeaders.getFirst(key));
        }
        this.response.sendRedirect(ServletExchangeImpl.xssClean(url));
    }

    private static String xssClean(String value) {
        if (value != null) {
            return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&ocirc;");
        }
        return value;
    }
}

