/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.tempfile;

import com.google.common.io.ByteStreams;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.monitor.httpserver.AbstractHttpHandler;

public class DownloadHandler
extends AbstractHttpHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        Map<String, String> params = this.getParams(exchange, false);
        try {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            if (!(cache instanceof TempFileCacheDownloadable)) {
                throw new RuntimeException(cache.getClass().getName() + " must implements " + TempFileCacheDownloadable.class.getName());
            }
            TempFileCacheDownloadable downloader = (TempFileCacheDownloadable)cache;
            TempFileCacheDownloadable.Content content = downloader.download(params);
            if (content == null) {
                String result = "{'success':'false';'errorCode':'NotFound'}";
                this.writeHtml(result, exchange);
                return;
            }
            exchange.getResponseHeaders().set("Content-Type", "application/octet-stream");
            String fileName = content.getFilename();
            String agent = exchange.getRequestHeaders().getFirst("USER-AGENT");
            boolean isFireFox = agent != null && agent.toLowerCase().indexOf("firefox") > 0;
            String rFileName = isFireFox ? "=?UTF-8?B?" + new String(Base64.getEncoder().encode(fileName.getBytes("UTF-8"))) + "?=" : URLEncoder.encode(fileName, "UTF-8");
            exchange.getResponseHeaders().add("Content-Disposition", "attachment;filename=" + rFileName);
            exchange.sendResponseHeaders(202, content.getLength());
            InputStream inputStream = null;
            OutputStream out = exchange.getResponseBody();
            BufferedOutputStream bos = new BufferedOutputStream(exchange.getResponseBody());
            try {
                inputStream = content.getInputStream();
                ByteStreams.copy((InputStream)inputStream, (OutputStream)bos);
                ((OutputStream)bos).flush();
                out.flush();
            }
            catch (IOException e) {
                String message;
                String result = message = e.getMessage();
                this.writeHtml(result, exchange);
                return;
            }
            finally {
                this.closeStream(inputStream);
                ((OutputStream)bos).close();
                out.close();
            }
        }
        catch (Exception e) {
            throw this.handlerException(e);
        }
    }

    private void closeStream(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            inputStream.close();
        }
    }

    private IOException handlerException(Exception e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }
}

