/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.thread;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.monitor.httpserver.InnerHandler;
import kd.bos.monitor.proxy.ProxyHandler;
import kd.bos.monitor.thread.entity.AllThreadDumpInfo;
import kd.bos.monitor.thread.entity.KeyValueEntity;
import kd.bos.monitor.thread.entity.ThreadDumpInfo;
import kd.bos.monitor.thread.entity.ThreadInfo;
import kd.bos.monitor.util.HttpClients;
import kd.bos.monitor.util.UriQuery;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class NewRemoteThreadHandler
extends InnerHandler {
    private static final Log logger = LogFactory.getLog(NewRemoteThreadHandler.class);
    private static final int readtimeout = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));
    private static final String PROXY_HEADER_KEY = ProxyHandler.PROXY_HEADER_KEY;
    private static final String PROXY_HEADER_VALUE = ProxyHandler.PROXY_HEADER_VALUE;

    public NewRemoteThreadHandler(String context) {
        super(context);
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        Map<String, String> params = UriQuery.toMap(exchange.getRequestURI().getQuery());
        String traceId = params.get("traceId");
        String ipAndPort = params.get("ipAndPort");
        String ip = null;
        if (ipAndPort != null) {
            ip = ipAndPort.split(":")[0];
        }
        List<ThreadDumpInfo> threadDumpInfoList = this.getAllRemoteThreadDumpInfo(ip, traceId, ipAndPort);
        String remoteData = "";
        if (threadDumpInfoList != null && !threadDumpInfoList.isEmpty()) {
            remoteData = this.createRemoteThreadDumpHtml(threadDumpInfoList);
        }
        try {
            this.sendResponse(exchange, remoteData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendResponse(HttpExchange exchange, String data) throws IOException {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private String createRemoteThreadDumpHtml(List<ThreadDumpInfo> threadDumpInfoList) {
        StringBuilder content = new StringBuilder();
        String spanContent = "<div style=\"display: inline-block; margin-right: 10px; margin-left: 10px; margin-top: 300px;\">==></div>";
        for (ThreadDumpInfo threadDumpInfo : threadDumpInfoList) {
            content.append(spanContent).append("<div style=\"display: inline-block; width: 900px; word-wrap: break-word\">").append("<b style=\"color: blue\">").append(threadDumpInfo.getShowThreadName()).append("</b>").append("<br>").append(this.getFormatThreadStatisticInfo(threadDumpInfo)).append(this.getFormatMemSpanInfo(threadDumpInfo)).append(this.getFormatStackTrace(threadDumpInfo)).append("</div>");
        }
        return content.toString();
    }

    private String getFormatThreadStatisticInfo(ThreadDumpInfo threadDumpInfo) {
        String info = "<b>[" + Resources.getString((String)"\u7ebf\u7a0b\u4fe1\u606f", (String)"NewThreadDumpHandler_10", (String)"bos-monitor", (Object[])new Object[0]) + "]&nbsp;&nbsp;";
        String content = Resources.getString((String)"\u5b9e\u4f8bIP", (String)"NewThreadDumpHandler_9", (String)"bos-monitor", (Object[])new Object[0]) + ": " + threadDumpInfo.getIp() + "&nbsp;" + Resources.getString((String)"\u5fae\u670d\u52a1", (String)"NewThreadDumpHandler_8", (String)"bos-monitor", (Object[])new Object[0]) + ": " + threadDumpInfo.getAppName() + "</b><br>";
        if (StringUtils.isNotEmpty((String)threadDumpInfo.getStartTime())) {
            content = content + "&nbsp;&nbsp;" + Resources.getString((String)"\u542f\u52a8\u65f6\u95f4", (String)"ThreadDumpHandler_1", (String)"bos-monitor", (Object[])new Object[0]) + ": " + threadDumpInfo.getStartTime() + ", " + Resources.getString((String)"\u5df2\u8fd0\u884c", (String)"ThreadDumpHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + ": " + threadDumpInfo.getDuration() + Resources.getString((String)"\u6beb\u79d2", (String)"ThreadDumpHandler_3", (String)"bos-monitor", (Object[])new Object[0]) + (StringUtils.isEmpty((String)threadDumpInfo.getClientUrl()) ? "" : "<br>&nbsp;&nbsp;URL: " + threadDumpInfo.getClientUrl()) + (StringUtils.isEmpty((String)threadDumpInfo.getUserName()) ? "" : "<br>&nbsp;&nbsp;UserName: " + threadDumpInfo.getUserName()) + (StringUtils.isEmpty((String)threadDumpInfo.getTenantId()) ? "" : "<br>&nbsp;&nbsp;TenantId: " + threadDumpInfo.getTenantId()) + (StringUtils.isEmpty((String)threadDumpInfo.getFormId()) ? "" : "<br>&nbsp;&nbsp;FormId: " + threadDumpInfo.getFormId()) + (StringUtils.isEmpty((String)threadDumpInfo.getAction()) ? "" : "<br>&nbsp;&nbsp;Action: " + threadDumpInfo.getAction()) + (threadDumpInfo.getThreadTraceStatList() == null || threadDumpInfo.getThreadTraceStatList().size() == 0 ? "" : "<br><b>[" + Resources.getString((String)"\u7ebf\u7a0b\u7edf\u8ba1", (String)"ThreadDumpHandler_5", (String)"bos-monitor", (Object[])new Object[0]) + "]</b><br>" + this.getFormatThreadTraceStat(threadDumpInfo.getThreadTraceStatList())) + "<br>";
        }
        return info + content;
    }

    private String getFormatThreadTraceStat(List<TraceStatistics.ThreadTraceStat> threadTraceStatList) {
        StringBuilder content = new StringBuilder();
        for (TraceStatistics.ThreadTraceStat threadTraceStat : threadTraceStatList) {
            content.append("&nbsp;&nbsp;").append(threadTraceStat.getType()).append(": ").append(Resources.getString((String)"\u6267\u884c\u6b21\u6570", (String)"NewThreadDumpHandler_1", (String)"bos-monitor", (Object[])new Object[0])).append(": ").append(threadTraceStat.getExecCount()).append(", ").append(Resources.getString((String)"\u603b\u65f6\u95f4", (String)"NewThreadDumpHandler_2", (String)"bos-monitor", (Object[])new Object[0])).append(": ").append(threadTraceStat.getTotalDuration()).append(Resources.getString((String)"\u6beb\u79d2", (String)"ThreadDumpHandler_3", (String)"bos-monitor", (Object[])new Object[0])).append(", ").append(Resources.getString((String)"\u5e73\u5747\u65f6\u95f4", (String)"NewThreadDumpHandler_3", (String)"bos-monitor", (Object[])new Object[0])).append(": ").append(threadTraceStat.getAvgDuration()).append(Resources.getString((String)"\u6beb\u79d2", (String)"ThreadDumpHandler_3", (String)"bos-monitor", (Object[])new Object[0])).append("<br>");
        }
        return content.toString();
    }

    private String getFormatMemSpanInfo(ThreadDumpInfo threadDumpInfo) {
        List<ThreadInfo.MemSpanInfo> memSpanInfoList = threadDumpInfo.getMemSpanInfoList();
        if (memSpanInfoList.isEmpty()) {
            return "";
        }
        StringBuilder content = new StringBuilder();
        for (ThreadInfo.MemSpanInfo memSpanInfo : memSpanInfoList) {
            String btnId = UUID.randomUUID().toString().split("-")[0];
            content.append("<b>[").append(Resources.getString((String)"\u5f53\u524d\u65b9\u6cd5", (String)"ThreadDumpHandler_7", (String)"bos-monitor", (Object[])new Object[0])).append("]</b> ").append(" ").append(Resources.getString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"ThreadDumpHandler_8", (String)"bos-monitor", (Object[])new Object[0])).append(": ").append(memSpanInfo.getMethodStartTime()).append(", ").append(Resources.getString((String)"\u5df2\u6267\u884c", (String)"ThreadDumpHandler_9", (String)"bos-monitor", (Object[])new Object[0])).append(": ").append(memSpanInfo.getMethodDuration()).append(Resources.getString((String)"\u6beb\u79d2", (String)"ThreadDumpHandler_10", (String)"bos-monitor", (Object[])new Object[0])).append(", ").append(Resources.getString((String)"\u6267\u884c\u65b9\u6cd5", (String)"ThreadDumpHandler_11", (String)"bos-monitor", (Object[])new Object[0])).append(": ");
            if (memSpanInfo.getExecuteMethod().contains("[")) {
                content.append(memSpanInfo.getExecuteMethod(), 0, memSpanInfo.getExecuteMethod().indexOf("[")).append("<a id=").append(btnId).append(" href=\"javascript:void(0);\" onclick=\"openModal(this.id)\">\u67e5\u770b</a>").append("<div id=").append(btnId).append("-modal class=\"modal\"><div class=\"modal-content\"><span id=").append(btnId).append("-span class=\"close\">&times;</span><h3>").append(Resources.getString((String)"\u6267\u884c\u65b9\u6cd5", (String)"ThreadDumpHandler_11", (String)"bos-monitor", (Object[])new Object[0])).append("</h3><p>").append(memSpanInfo.getExecuteMethod()).append("</p></div></div>");
            } else {
                content.append(memSpanInfo.getExecuteMethod());
            }
            List<KeyValueEntity> details = memSpanInfo.getDetails();
            if (details.size() != 0) {
                for (KeyValueEntity detail : details) {
                    if ("service".equals(detail.getKey())) continue;
                    content.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append("[ ").append(detail.getKey()).append(" ]: ").append(detail.getValue());
                }
            }
            content.append("<br>");
        }
        return content.toString();
    }

    private String getFormatStackTrace(ThreadDumpInfo threadDumpInfo) {
        List<String> stackTraceList = threadDumpInfo.getStackTraceInfoList();
        if (stackTraceList.isEmpty()) {
            return "";
        }
        StringBuilder formatStackTrace = new StringBuilder();
        formatStackTrace.append("<b>[").append(Resources.getString((String)"\u7ebf\u7a0b\u5806\u6808", (String)"ThreadDumpHandler_12", (String)"bos-monitor", (Object[])new Object[0])).append("]</b><br>");
        int line = 15;
        String divId = UUID.randomUUID().toString().split("-")[0];
        for (String stackTrace : stackTraceList) {
            formatStackTrace.append("&nbsp;&nbsp;at ").append(stackTrace).append("<br>");
            if (--line != 0) continue;
            formatStackTrace.append("<div id=hide-").append(divId).append(" name='hide' style=\"display: none\">");
        }
        if (line <= 0) {
            formatStackTrace.append("</div><a href=\"javascript:void(0);\" onclick=\"showMore(this.id)\" id=more-").append(divId).append(" name='more'>\u5c55\u5f00</a>");
        }
        return formatStackTrace.toString();
    }

    private List<ThreadDumpInfo> getAllRemoteThreadDumpInfo(String ip, String traceId, String ipAndPort) {
        ThreadDumpInfo headRemoteThread = this.getRemoteThreadDumpInfo(ip, traceId, ipAndPort);
        if (headRemoteThread == null) {
            return null;
        }
        ArrayList<ThreadDumpInfo> threadDumpInfoList = new ArrayList<ThreadDumpInfo>(3);
        threadDumpInfoList.add(headRemoteThread);
        ThreadDumpInfo tempRemoteThread = headRemoteThread;
        while (tempRemoteThread != null && tempRemoteThread.getRemoteIPAndPort() != null) {
            String tempIpAndPort = tempRemoteThread.getRemoteIPAndPort();
            String tempIp = tempIpAndPort.split(":")[0];
            ThreadDumpInfo nextRemoteThread = this.getRemoteThreadDumpInfo(tempIp, traceId, tempIpAndPort);
            if (nextRemoteThread != null) {
                threadDumpInfoList.add(nextRemoteThread);
            }
            tempRemoteThread = nextRemoteThread;
        }
        return threadDumpInfoList;
    }

    private List<String> getRemoteThreadInfoUrl(String ip, String traceId, String ipAndPort) {
        String remoteThreadInfoUrl = null;
        List<NodeInfo> nodeInfoList = NewRemoteThreadHandler.getRemoteNodeInfo(ip);
        if (nodeInfoList.isEmpty()) {
            return null;
        }
        ArrayList<String> remoteThreadInfoUrlList = new ArrayList<String>(3);
        for (NodeInfo nodeInfo : nodeInfoList) {
            remoteThreadInfoUrl = nodeInfo.getMonitorUrl(false) + "/monitor/newthreaddumpproxy?proxyurl=/monitor/proxy&ip=" + ip + "&appname=" + nodeInfo.getAppName() + "&threadname=" + "RpcRequest" + "&traceId=" + traceId + "&key=" + ipAndPort;
            remoteThreadInfoUrlList.add(remoteThreadInfoUrl);
        }
        return remoteThreadInfoUrlList;
    }

    private static List<NodeInfo> getRemoteNodeInfo(String ip) {
        ArrayList<NodeInfo> nodeInfoList = new ArrayList<NodeInfo>(3);
        try {
            Map nodesMap = ClusterInstances.getAllOriginNodesString();
            for (Map.Entry entry : nodesMap.entrySet()) {
                String value = (String)entry.getValue();
                NodeInfo nodeInfo = (NodeInfo)JSONUtils.cast((String)value, NodeInfo.class, (boolean)true);
                if (nodeInfo == null || !ip.contains(nodeInfo.getIp())) continue;
                nodeInfoList.add(nodeInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nodeInfoList;
    }

    private ThreadDumpInfo getRemoteThreadDumpInfo(String ip, String traceId, String ipAndPort) {
        List<String> remoteThreadInfoUrlList = this.getRemoteThreadInfoUrl(ip, traceId, ipAndPort);
        if (remoteThreadInfoUrlList == null || remoteThreadInfoUrlList.isEmpty()) {
            return null;
        }
        AllThreadDumpInfo allThreadDumpInfo = null;
        try {
            String remoteThreadInfoUrl;
            String remoteThreadInfoJson;
            Iterator<String> iterator = remoteThreadInfoUrlList.iterator();
            while (iterator.hasNext() && ((allThreadDumpInfo = this.castThreadDumpInfoJsonToThreadDumpInfo(remoteThreadInfoJson = this.getThreadDumpInfoJsonFromUrl(remoteThreadInfoUrl = iterator.next()))) == null || allThreadDumpInfo.getThreadDumpInfoList().isEmpty())) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allThreadDumpInfo == null || allThreadDumpInfo.getThreadDumpInfoList().isEmpty() ? null : allThreadDumpInfo.getThreadDumpInfoList().get(0);
    }

    private String getThreadDumpInfoJsonFromUrl(String accessUrlOfNodeInfo) throws Exception {
        HashMap<String, String> proxyHeader = new HashMap<String, String>();
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        try {
            return HttpClients.get(accessUrlOfNodeInfo, proxyHeader, 5000, readtimeout * 1000);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private AllThreadDumpInfo castThreadDumpInfoJsonToThreadDumpInfo(String allThreadDumpInfoJSON) throws Exception {
        AllThreadDumpInfo allThreadDumpInfo = null;
        if (allThreadDumpInfoJSON != null) {
            try {
                allThreadDumpInfo = (AllThreadDumpInfo)JSONUtils.cast((String)allThreadDumpInfoJSON, AllThreadDumpInfo.class);
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
        return allThreadDumpInfo;
    }
}

