/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.thread;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.OperationContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.monitor.httpserver.InnerHandler;
import kd.bos.monitor.proxy.ProxyHandler;
import kd.bos.monitor.thread.ThreadDumpUtil;
import kd.bos.monitor.util.ClassicTo404;
import kd.bos.monitor.util.HttpClients;
import kd.bos.monitor.util.UriQuery;
import kd.bos.monitor.util.UrlUtils;
import kd.bos.util.resource.Resources;

public class ThreadDumpAllHandler
extends InnerHandler {
    public static final String PROXY_HEADER_KEY = ProxyHandler.PROXY_HEADER_KEY;
    private static final Log logger = LogFactory.getLog(ThreadDumpAllHandler.class);
    public static final String PROXY_HEADER_VALUE = ProxyHandler.PROXY_HEADER_VALUE;
    private static int readtimeout = 60;
    private static final String MAGIC = "<td valign=top><a href=";
    private static final String MAGIC2 = "</a></td>&nbsp;";

    public ThreadDumpAllHandler(String context) {
        super(context);
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        PrintWriter out;
        StringWriter sw;
        block10: {
            boolean disable = ClassicTo404.redirectTo404(exchange);
            if (disable) {
                return;
            }
            sw = new StringWriter();
            out = new PrintWriter(sw);
            OperationContextCreator.getOrCreateForBos();
            HashMap<String, String> proxyHeader = new HashMap<String, String>();
            proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
            Map<String, String> params = UriQuery.toMap(exchange.getRequestURI().getQuery());
            String handlerUrl = super.getInnerHandlerUrl();
            String homeUrl = UrlUtils.getHomeUrl(exchange, handlerUrl);
            boolean allThread = params.get("allThread") == null ? false : params.get("allThread").equals("true");
            boolean live = params.get("live") == null ? false : params.get("live").equals("true");
            String threadName = params.get("threadname");
            handlerUrl = homeUrl + "threaddumpall";
            ArrayList<NodeInfo> serverNodes = new ArrayList();
            try {
                serverNodes = ThreadDumpUtil.getSortedNodeInfos();
                this.outPrintTitle(out, serverNodes, params, null, handlerUrl);
                String str = sw.toString();
                byte[] bytes = str.getBytes("UTF-8");
                exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
                exchange.sendResponseHeaders(202, bytes.length);
                exchange.getResponseBody().write(bytes);
                if (allThread) {
                    List ips = serverNodes.stream().map(node -> node.getMonitorUrl(false) + "/monitor0/threaddumpproxy?proxyurl=/monitor/proxy" + (live ? "&live=true" : "&live=false") + (threadName != null ? "&threadname=" + threadName : "")).collect(Collectors.toList());
                    for (String ip : ips) {
                        StringWriter nodeSw = new StringWriter();
                        PrintWriter nodePw = new PrintWriter(nodeSw);
                        String response = "";
                        try {
                            response = HttpClients.get(ip, proxyHeader, 5000, readtimeout * 1000);
                            nodePw.println(response);
                        }
                        catch (Exception e) {
                            response = this.outPrintlnException(ip);
                            nodePw.println(response);
                        }
                        String nodeStr = nodeSw.toString();
                        byte[] nodeBytes = nodeStr.getBytes("UTF-8");
                        exchange.getResponseBody().write(nodeBytes);
                        exchange.getResponseBody().flush();
                        nodePw.close();
                        nodeSw.close();
                    }
                    break block10;
                }
                List ips = serverNodes.stream().map(node -> node.getMonitorUrl(false) + "/monitor0/threaddumpproxy?proxyurl=/monitor/proxy").collect(Collectors.toList());
                for (String ip : ips) {
                    StringWriter nodeSw = new StringWriter();
                    PrintWriter nodePw = new PrintWriter(nodeSw);
                    String response = "";
                    try {
                        response = HttpClients.get(ip, proxyHeader, 5000, readtimeout * 1000);
                        nodePw.println(response);
                    }
                    catch (Exception e) {
                        response = this.outPrintlnException(ip);
                        nodePw.println(response);
                    }
                    String nodeStr = nodeSw.toString();
                    byte[] nodeBytes = nodeStr.getBytes("UTF-8");
                    exchange.getResponseBody().write(nodeBytes);
                    exchange.getResponseBody().flush();
                    nodePw.close();
                    nodeSw.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        out.close();
        sw.close();
        exchange.close();
    }

    private String outPrintlnException(String ip) {
        String title = Resources.getString((String)"\u8282\u70b9\u5806\u6808\u8bf7\u6c42\u5f02\u5e38", (String)"ThreadDumpAllHandler_3", (String)"bos-monitor", (Object[])new Object[0]) + ":" + ip;
        String ret = "<center><h1>" + title + "</h1></center>&nbsp;";
        return ret;
    }

    private void outPrintTitle(PrintWriter out, List<NodeInfo> serverNodes, Map<String, String> params, String proxyurl, String uri) {
        String title = Resources.getString((String)"\u96c6\u7fa4\u7ebf\u7a0b\u5806\u6808", (String)"ThreadDumpAllHandler_1", (String)"bos-monitor", (Object[])new Object[0]);
        out.println("<title>" + title + "</title>");
        out.println("<center><h1>" + title + "(" + serverNodes.size() + Resources.getString((String)"\u4e2a\u8282\u70b9)", (String)"ThreadDumpAllHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + "</h1></center>");
        out.println("<tr>");
        out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?allThread=true&live=false", proxyurl) + ">All thread" + MAGIC2 + "");
        out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?allThread=true&live=true", proxyurl) + ">living thread" + MAGIC2 + "");
        out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?allThread=true&threadname=http-request-pool&live=false", proxyurl) + ">web request thread" + MAGIC2 + "");
        out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?allThread=true&threadname=http-request-pool&live=true", proxyurl) + ">living web request thread" + MAGIC2 + "");
        out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?allThread=true&threadname=" + "RpcRequest" + "&live=false", proxyurl) + ">service thread" + MAGIC2 + "");
        out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?allThread=true&threadname=" + "RpcRequest" + "&live=true", proxyurl) + ">living service thread" + MAGIC2 + "");
        out.println("</tr><br><br>");
    }

    static {
        readtimeout = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));
    }
}

