/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.trace;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.trace.TraceSourcePicker;
import kd.bos.monitor.util.ClassicTo404;
import kd.bos.monitor.util.UriQuery;

public class TraceListHandler
extends AbstractHttpHandler {
    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        String tracestr;
        boolean disable = ClassicTo404.redirectTo404(exchange);
        if (disable) {
            return;
        }
        String zipkinurl = System.getProperty("monitor.zipkin.url");
        String tracesApi = System.getProperty("monitor.zipkin.tracesApi", "/api/v1/traces?");
        String url = zipkinurl + tracesApi;
        Map<String, String> params = UriQuery.toMap(exchange.getRequestURI().getQuery());
        StringBuilder sb = new StringBuilder(url);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (url.endsWith("?")) {
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            } else {
                sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
            url = sb.toString();
        }
        try {
            tracestr = TraceSourcePicker.get(url);
        }
        catch (Exception ex) {
            return;
        }
        byte[] response = tracestr.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, response.length);
        OutputStream os = exchange.getResponseBody();
        os.write(response);
        exchange.close();
    }
}

