/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.trace;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.metric.MetricHandler;
import kd.bos.monitor.util.ClassicTo404;
import kd.bos.monitor.util.UriQuery;
import kd.bos.monitor.util.UrlUtils;

public class TraceResourceHandler
extends AbstractHttpHandler {
    private final String path;
    private String context;

    public TraceResourceHandler(String path, String context, Map<String, String> variables) {
        this.path = path;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle0(HttpExchange pExchange) throws IOException {
        boolean disable = ClassicTo404.redirectTo404(pExchange);
        if (disable) {
            return;
        }
        URI uri = pExchange.getRequestURI();
        OutputStream os = null;
        InputStream in = null;
        try {
            Map<String, String> params = UriQuery.toMap(pExchange.getRequestURI().getQuery());
            String reqPath = uri.getPath();
            int pos = reqPath.indexOf(this.context);
            reqPath = reqPath.substring(pos + this.context.length());
            if (!reqPath.startsWith("/")) {
                reqPath = "/" + reqPath;
            }
            if ("/".equals(reqPath)) {
                reqPath = "/index.html";
            }
            if ((in = MetricHandler.class.getResourceAsStream(this.path + reqPath)) == null) {
                pExchange.sendResponseHeaders(404, 0L);
                pExchange.close();
                return;
            }
            if (reqPath.endsWith(".js")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/javascript; charset=UTF-8");
            } else if (reqPath.endsWith(".jsx")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/javascript; charset=UTF-8");
            } else if (reqPath.endsWith(".css")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/css; charset=UTF-8");
            } else if (reqPath.endsWith(".html")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            } else if (reqPath.endsWith(".json")) {
                pExchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
            } else if (reqPath.endsWith(".properties")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            }
            String baseUrl = UrlUtils.getHomeUrl(pExchange, "tc");
            if (baseUrl.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                baseUrl = baseUrl.substring(baseUrl.indexOf("//") + 2);
                baseUrl = baseUrl.substring(baseUrl.indexOf("/"));
            }
            byte[] response = this.readBytes(in);
            if (reqPath.endsWith("/index.html")) {
                response = this.replaceIndex(response, params, baseUrl);
            }
            pExchange.sendResponseHeaders(202, response.length);
            os = pExchange.getResponseBody();
            os.write(response);
            pExchange.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private byte[] replaceIndex(byte[] response, Map<String, String> params, String baseUrl) throws UnsupportedEncodingException {
        String text = new String(response, "UTF-8");
        try {
            text = text.replace("{baseUrl}", baseUrl);
        }
        catch (Exception e) {
            return text.getBytes("UTF-8");
        }
        return text.getBytes("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(InputStream str) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int thisLine;
            while ((thisLine = str.read()) != -1) {
                bos.write(thisLine);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

