/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.MonitorHttpClients;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClients {
    private static Logger logger = LoggerFactory.getLogger(HttpClients.class);
    private static int default_connectionTimeout = 5000;
    private static int default_readTimeout = 300000;

    private static HttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setConnectTimeout(readTimeout).build()).build();
        return client;
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HttpClients.post(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        return MonitorHttpClients.post((String)url, header, body, (int)connectionTimeout, (int)readTimeout);
    }

    public static String postjson(String url, Map<String, String> header, String json) throws IOException {
        return HttpClients.postjson(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    public static String postjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) throws IOException {
        return MonitorHttpClients.postjson((String)url, header, (String)json, (int)connectionTimeout, (int)readTimeout);
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HttpClients.postAppJson(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        return MonitorHttpClients.postAppJson((String)url, header, body, (int)connectionTimeout, (int)readTimeout);
    }

    public static String get(String url) {
        return HttpClients.get(url, default_connectionTimeout, default_readTimeout);
    }

    public static String get(String url, int connectionTimeout, int readTimeout) {
        String content = null;
        try {
            content = MonitorHttpClients.get((String)url, (int)connectionTimeout, (int)readTimeout);
        }
        catch (Exception e) {
            logger.error("get result error by url", (Throwable)e);
        }
        return content;
    }

    public static String get(String url, Map<String, String> headers, int connectionTimeout, int readTimeout) {
        try {
            return MonitorHttpClients.get((String)url, headers, (int)connectionTimeout, (int)readTimeout);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.otherUnknow, new Object[]{"get data from url error, url: " + url});
        }
    }

    public static String putjson(String url, Map<String, String> header, String json) {
        return HttpClients.putjson(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    public static String putjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) {
        return MonitorHttpClients.putjson((String)url, header, (String)json, (int)connectionTimeout, (int)readTimeout);
    }

    public static String postFormData(String url, Map<String, String> headers, List<MonitorHttpClients.FormDataEntity> formDatas) {
        throw new UnsupportedOperationException();
    }

    public static String postFormData(String url, Map<String, String> headers, List<MonitorHttpClients.FormDataEntity> formDatas, int connectionTimeout, int readTimeout) {
        return MonitorHttpClients.postFormData((String)url, headers, formDatas, (int)connectionTimeout, (int)readTimeout);
    }
}

