/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql;

import java.util.Locale;

public final class DbType {
    public static final int KSQL = 0;
    public static final int DB2_UDB = 1;
    public static final int Oracle = 2;
    public static final int MS_SQL_Server = 3;
    public static final int Sybase = 4;
    public static final int PostgresSQL = 5;
    public static final int MySQL = 6;
    public static final int Oracle9 = 7;
    public static final int Oracle10 = 8;
    public static final int AS400 = 9;
    public static final int Derby = 10;
    public static final int DM = 11;
    public static final int GS = 12;
    public static final int GS100 = 13;
    public static final int GaussDB = 14;
    public static final int KingBase = 15;
    public static final int Vastbase = 16;
    public static final int TDSQL = 17;
    public static final int Gbase = 18;
    public static final int TiDB = 19;
    public static final int YasDB = 20;
    public static final int OceanBase_Oracle = 21;
    public static final int OceanBase_MySql = 22;
    public static final int HANA = 101;
    public static final int DRSQL = 102;
    public static final int Gauss200 = 103;
    public static final int Greenplum = 104;
    public static final int ClickHouse = 105;

    private DbType() {
    }

    public static int[] getAllTypes() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 16, 20, 21, 22, 101, 102, 103, 104, 105};
    }

    public static String getName(int dbType) {
        switch (dbType) {
            case 0: {
                return "KSQL";
            }
            case 1: {
                return "DB2 UDB";
            }
            case 2: {
                return "Oracle";
            }
            case 7: {
                return "Oracle9";
            }
            case 4: {
                return "Sybase";
            }
            case 5: {
                return "PostgresSQL";
            }
            case 6: {
                return "MySQL";
            }
            case 3: {
                return "MS SQL Server";
            }
            case 8: {
                return "Oracle10";
            }
            case 9: {
                return "AS400";
            }
            case 10: {
                return "Derby";
            }
            case 11: {
                return "DM";
            }
            case 12: {
                return "GS";
            }
            case 13: {
                return "GS100";
            }
            case 14: {
                return "GaussDB";
            }
            case 15: {
                return "KingBase";
            }
            case 16: {
                return "Vastbase";
            }
            case 17: {
                return "TDSQL";
            }
            case 18: {
                return "Gbase";
            }
            case 19: {
                return "TiDB";
            }
            case 20: {
                return "YasDB";
            }
            case 21: {
                return "OceanBase_Oracle";
            }
            case 22: {
                return "OceanBase_MySql";
            }
            case 101: {
                return "HANA";
            }
            case 102: {
                return "DRSQL";
            }
            case 103: {
                return "Gauss200";
            }
            case 104: {
                return "Greenplum";
            }
            case 105: {
                return "ClickHouse";
            }
        }
        throw new IllegalArgumentException("dbType, value is " + dbType);
    }

    public static boolean isOracle(int type) {
        return type == 8 || type == 7 || type == 2;
    }

    public static int getValue(String oName) {
        assert (oName != null);
        String name = oName.toLowerCase(Locale.ENGLISH);
        if ("ksql".equals(name)) {
            return 0;
        }
        if (name.indexOf("dm") != -1) {
            return 11;
        }
        if (name.indexOf("gs100") != -1) {
            return 13;
        }
        if (name.indexOf("gs") != -1) {
            return 12;
        }
        if (name.indexOf("mysql") != -1 || name.indexOf("mariadb") != -1) {
            return 6;
        }
        if (name.indexOf("gaussdb") != -1) {
            return 14;
        }
        if ("kingbase".equals(name)) {
            return 15;
        }
        if ("gbase".equals(name)) {
            return 18;
        }
        if (name.startsWith("oracle")) {
            if (name.indexOf(57) != -1) {
                return 7;
            }
            if (name.indexOf("10") != -1) {
                return 8;
            }
            return 2;
        }
        if (name.indexOf("postgressql") != -1 || name.indexOf("postgresql") != -1) {
            return 5;
        }
        if (name.indexOf("as400") != -1) {
            return 9;
        }
        if (name.startsWith("db2")) {
            return 1;
        }
        if (name.indexOf("sybase") != -1) {
            return 4;
        }
        if (name.indexOf("derby") != -1) {
            return 10;
        }
        if (name.indexOf("ms") != -1 || name.indexOf("microsoft") != -1 || name.indexOf("sqlserver") != -1) {
            return 3;
        }
        if (name.contains("tdsql")) {
            return 17;
        }
        if (name.contains("tidb")) {
            return 19;
        }
        if (name.contains("vastbase")) {
            return 16;
        }
        if (name.contains("yasdb")) {
            return 20;
        }
        if (name.contains("oceanbase_oracle")) {
            return 21;
        }
        if (name.contains("oceanbase_mysql")) {
            return 22;
        }
        if (name.equalsIgnoreCase("hana")) {
            return 101;
        }
        if (name.equalsIgnoreCase("drsql")) {
            return 102;
        }
        if (name.contains("greenplum")) {
            return 104;
        }
        if (name.contains("clickhouse")) {
            return 105;
        }
        throw new IllegalArgumentException("name:" + oName);
    }
}

