/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql;

import java.util.Locale;
import kd.bos.bundle.Resources;
import kd.bos.ksql.KSQLThreadCache;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.util.ConfigurationUtil;

public class KSqlLimiter {
    private static int max_sql_len = Integer.parseInt(System.getProperty("ksql.max_length", "2097152"));
    private static int maxSubstringLength = Math.min(max_sql_len, 1024);
    private static boolean limitSelectAllInSqlJoin = false;

    static final void limitMaxLength(String sql) {
        if (sql.length() > max_sql_len) {
            throw new IllegalArgumentException(Resources.getString((String)"bos-ksql", (String)"KSqlLimiter_0", (Object[])new Object[0]) + sql.length() + ">" + max_sql_len + ":" + sql.substring(0, maxSubstringLength) + " ...");
        }
    }

    public static void limitSelectAllColumn(SqlSelectBase select) {
        block3: {
            SqlSelect s;
            block4: {
                if (!(select instanceof SqlSelect)) break block3;
                s = (SqlSelect)select;
                if (!(s.tableSource instanceof SqlTableSource) || limitSelectAllInSqlJoin) break block4;
                String name = ((SqlTableSource)s.tableSource).getOrgName().toUpperCase(Locale.ENGLISH);
                if (name.startsWith("KSQL_")) break block3;
                for (Object column : s.selectList) {
                    SqlSelectItem si = (SqlSelectItem)column;
                    if (si.expr.type != 8 || !KSqlLimiter.isCheckSelectAllColumn()) continue;
                    throw new IllegalArgumentException(Resources.get((String)"bos-ksql", (String)"KSqlLimiter_1", (String)"ksql disable select *", (Object[])new Object[0]));
                }
                break block3;
            }
            if (limitSelectAllInSqlJoin && !KSqlLimiter.isKsqlTable(((SqlSelect)select).tableSource)) {
                for (Object column : s.selectList) {
                    SqlSelectItem si = (SqlSelectItem)column;
                    if (si.expr.type != 8 || !KSqlLimiter.isCheckSelectAllColumn()) continue;
                    throw new IllegalArgumentException(Resources.get((String)"bos-ksql", (String)"KSqlLimiter_1", (String)"ksql disable select *", (Object[])new Object[0]));
                }
            }
        }
    }

    private static boolean isKsqlTable(SqlTableSourceBase tableSourceBase) {
        if (tableSourceBase instanceof SqlTableSource) {
            String name = ((SqlTableSource)tableSourceBase).getOrgName().toUpperCase(Locale.ENGLISH);
            return name.startsWith("KSQL_");
        }
        if (tableSourceBase instanceof SqlJoinedTableSource) {
            return KSqlLimiter.isKsqlTable(((SqlJoinedTableSource)tableSourceBase).left) || KSqlLimiter.isKsqlTable(((SqlJoinedTableSource)tableSourceBase).right);
        }
        return false;
    }

    private static boolean isCheckSelectAllColumn() {
        Object isCheck = KSQLThreadCache.get("check.selectAllColumn");
        return isCheck != null ? (Boolean)isCheck : true;
    }

    static {
        ConfigurationUtil.observeBoolean((String)"ksql.forbid_select_star", (boolean)false, v -> {
            limitSelectAllInSqlJoin = v;
        });
    }
}

