/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.ksql.KSqlUtil;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.formater.DrSQLFormater;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.parser.SqlExprParser;
import org.apache.log4j.Logger;

public class KSqlTools {
    private static final Logger logger = Logger.getLogger(KSqlTools.class);

    public static void optimize(int optimizeMode, SqlSelectBase selectBase) throws SqlTranslateException {
        KSqlTools.singleOptimize(selectBase, optimizeMode);
        String oSql = KSqlTools.getSqlFromSelectBase(selectBase);
        KSqlTools.singleOptimize(selectBase, optimizeMode);
        String nSql = KSqlTools.getSqlFromSelectBase(selectBase);
        while (!nSql.equals(oSql)) {
            oSql = nSql;
            KSqlTools.singleOptimize(selectBase, optimizeMode);
            nSql = KSqlTools.getSqlFromSelectBase(selectBase);
        }
    }

    private static void singleOptimize(SqlSelectBase selectBase, int mode) throws SqlTranslateException {
        if (mode == -1) {
            return;
        }
        KSqlTools.inner_optimize_selectbase(selectBase, mode);
    }

    private static String getSqlFromSelectBase(SqlSelectBase selectBase) {
        StringBuilder buff = new StringBuilder();
        try {
            new DrSQLFormater(buff).formatSelectBase(selectBase);
        }
        catch (FormaterException e) {
            logger.warn((Object)e.getMessage());
        }
        return buff.toString();
    }

    private static void inner_optimize_selectbase(SqlSelectBase selectBase, int mode) throws ParserException {
        if (selectBase instanceof SqlSelect) {
            KSqlTools.OptimizeSelectBase((SqlSelect)selectBase, mode);
        } else if (selectBase instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)selectBase;
            KSqlTools.inner_optimize_selectbase(unionSelect.left, mode);
            KSqlTools.inner_optimize_selectbase(unionSelect.right, mode);
        }
    }

    private static void OptimizeSelectBase(SqlSelect select, int mode) {
        Map selectItemAliasMap = null;
        try {
            selectItemAliasMap = KSqlUtil.adjust(select, mode);
            KSqlUtil.optimize_table_source(select.tableSource, mode);
        }
        catch (ParserException e) {
            logger.warn((Object)e.getMessage());
        }
        HashSet usedTableAliasSet = new HashSet();
        Iterator iter = select.selectList.iterator();
        boolean hasCanNotOptimizeExpr = false;
        while (iter.hasNext()) {
            SqlSelectItem selectItem = (SqlSelectItem)iter.next();
            hasCanNotOptimizeExpr = KSqlUtil.computeUsedTableAlias(usedTableAliasSet, selectItem.expr);
            if (!hasCanNotOptimizeExpr) continue;
            return;
        }
        hasCanNotOptimizeExpr = KSqlUtil.computeUsedTableAlias(usedTableAliasSet, select.condition);
        if (hasCanNotOptimizeExpr) {
            return;
        }
        for (SqlExpr groupExpr : select.groupBy) {
            hasCanNotOptimizeExpr = KSqlUtil.computeUsedTableAlias(usedTableAliasSet, groupExpr);
            if (!hasCanNotOptimizeExpr) continue;
            return;
        }
        hasCanNotOptimizeExpr = KSqlUtil.computeUsedTableAlias(usedTableAliasSet, select.having);
        if (hasCanNotOptimizeExpr) {
            return;
        }
        for (SqlOrderByItem orderByItem : select.orderBy) {
            hasCanNotOptimizeExpr = KSqlUtil.computeUsedTableAlias(usedTableAliasSet, orderByItem.expr);
            if (!hasCanNotOptimizeExpr) continue;
            return;
        }
        SqlTableSourceBase tableSource = select.tableSource;
        HashMap joinConditionUsedAliasMap = new HashMap();
        KSqlUtil.computeJoinConditionUsedAlias(joinConditionUsedAliasMap, tableSource);
        select.tableSource = tableSource = KSqlUtil.cleanTableSource(usedTableAliasSet, joinConditionUsedAliasMap, tableSource, mode);
        if (selectItemAliasMap != null) {
            block7: for (SqlOrderByItem orderByItem : select.orderBy) {
                String orderExprString = orderByItem.expr.toString();
                for (Map.Entry entry : selectItemAliasMap.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!orderExprString.equalsIgnoreCase(value.toString())) continue;
                    try {
                        orderByItem.expr = new SqlExprParser(key.toString()).expr();
                        continue block7;
                    }
                    catch (Exception ex) {
                        logger.warn((Object)ex.getMessage());
                    }
                }
            }
        }
    }
}

