/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql;

import java.util.Iterator;
import java.util.List;
import kd.bos.ksql.FormaterContext;
import kd.bos.ksql.KSqlLimiter;
import kd.bos.ksql.TransInner;
import kd.bos.ksql.dom.SqlObject;
import kd.bos.ksql.dom.stmt.SqlSelectStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.extension.KSQLExtensionsRegister;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SqlParser;
import kd.bos.ksql.shell.trace.TraceInfo;
import kd.bos.ksql.visitor.ToSelectLimitVisitor;

public final class TransUtil {
    public static final String Dialect_Prefix = "/*dialect*/";
    private static final int DIALECT_PREFIX_LENGTH = "/*dialect*/".length();
    private static boolean throwExWhenNameTooLong = false;

    private TransUtil() {
    }

    public static String translate(String kSql, int targetDbType) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, null, null, throwExWhenNameTooLong);
    }

    public static String translate(String kSql, int targetDbType, FormatOptions options) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, options, null, throwExWhenNameTooLong);
    }

    public static String translate(String kSql, int targetDbType, FormatOptions options, FormaterContext formaterContext, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        if (kSql == null || kSql.length() == 0) {
            throw new IllegalArgumentException("KSQL can not be empty!");
        }
        if ((kSql.charAt(0) == ' ' || kSql.charAt(kSql.length() - 1) == ' ') && (kSql = kSql.trim()).length() == 0) {
            throw new IllegalArgumentException("KSQL can not be empty!");
        }
        if ((targetDbType == 6 || targetDbType == 17 || targetDbType == 19) && Boolean.parseBoolean(System.getProperty("ksql.mysql.escape.slash", "true"))) {
            StringBuilder buf = new StringBuilder(kSql.length());
            for (char ch : kSql.toCharArray()) {
                if (ch == '\\') {
                    buf.append(ch);
                }
                buf.append(ch);
            }
            if (kSql.length() != buf.length()) {
                kSql = buf.toString();
            }
        }
        KSqlLimiter.limitMaxLength(kSql);
        kSql = KSQLExtensionsRegister.handleKSQLBeforeTrans(kSql);
        if (kSql.startsWith(Dialect_Prefix)) {
            kSql = kSql.substring(DIALECT_PREFIX_LENGTH);
            while (kSql.startsWith(Dialect_Prefix)) {
                kSql = kSql.substring(DIALECT_PREFIX_LENGTH);
            }
            if (kSql.length() == 0) {
                throw new IllegalArgumentException("KSQL can not be empty!");
            }
            if (TransInner.isWarnDialectSQL()) {
                TransInner.warnDialectSQL(kSql);
            }
            return kSql;
        }
        String ret = TransInner.transSQL(kSql, targetDbType, options, formaterContext, throwExWhenNameTooLong);
        if ((ret = KSQLExtensionsRegister.handleKSQLAfterTrans(ret)).length() == 0) {
            throw new IllegalArgumentException("KSQL can not be empty: " + kSql);
        }
        return ret;
    }

    public static boolean isThrowExWhenNameTooLong() {
        return throwExWhenNameTooLong;
    }

    public static void setThrowExWhenNameTooLong(boolean throwExWhenNameTooLong) {
        TransUtil.throwExWhenNameTooLong = throwExWhenNameTooLong;
    }

    @Deprecated
    public static final String translate(String kSql, int targetDbType, TraceInfo traceInfo) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, null, null, throwExWhenNameTooLong);
    }

    @Deprecated
    public static final String translate(String kSql, int targetDbType, TraceInfo traceInfo, FormaterContext formaterContext) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, traceInfo == null ? null : traceInfo.getFormatOptions(), formaterContext, throwExWhenNameTooLong);
    }

    @Deprecated
    public static final String translate(String kSql, int targetDbType, TraceInfo traceInfo, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, null, null, throwExWhenNameTooLong);
    }

    @Deprecated
    public static String translate(String kSql, int targetDbType, FormatOptions options, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        return TransUtil.translate(kSql, targetDbType, options, null, throwExWhenNameTooLong);
    }

    @Deprecated
    public static final String translate(String ksql, int targetDbType, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        return TransUtil.translate(ksql, targetDbType, null, null, throwExWhenNameTooLong);
    }

    @Deprecated
    public static String translate(StringBuilder sqlBuffer, int targetDbType) throws SqlTranslateException {
        return TransUtil.translate(sqlBuffer.toString(), targetDbType, null, null, throwExWhenNameTooLong);
    }

    @Deprecated
    public static String translate(StringBuilder sqlBuffer, int targetDbType, boolean throwExWhenNameTooLong) throws SqlTranslateException {
        return TransUtil.translate(sqlBuffer.toString(), targetDbType, null, null, throwExWhenNameTooLong);
    }

    public static String changeToKSqlLimit(String ksql, int limit) throws ParserException {
        return TransUtil.changeToKSqlLimit(ksql, limit, 0);
    }

    private static String changeToKSqlLimit(String ksql, int limit, int offset) throws ParserException {
        Lexer lexer = new Lexer(ksql);
        SqlParser parser = new SqlParser(lexer);
        parser.setThrowExWhenNameTooLong(throwExWhenNameTooLong);
        List stmtCol = (List)parser.parseStmtList();
        if (stmtCol == null || stmtCol.size() <= 0) {
            return "";
        }
        ToSelectLimitVisitor topSelectVisitor = new ToSelectLimitVisitor(limit, offset);
        Iterator iterator = stmtCol.iterator();
        StringBuilder ret = new StringBuilder(1024);
        boolean flag = false;
        while (iterator.hasNext()) {
            SqlObject sqlObject;
            if (flag) {
                ret.append(';');
            }
            if ((sqlObject = (SqlObject)iterator.next()) instanceof SqlSelectStmt) {
                sqlObject.accept(topSelectVisitor);
            }
            ret.append(sqlObject.toString());
            flag = true;
        }
        return ret.toString();
    }
}

