/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.datatype;

public class DataType {
    public static final String CHAR = "CHAR";
    public static final String VARCHAR = "VARCHAR";
    public static final String NCHAR = "NCHAR";
    public static final String NVARCHAR = "NVARCHAR";
    public static final String BINARY = "BINARY";
    public static final String VARBINARY = "VARBINARY";
    public static final String BLOB = "BLOB";
    public static final String CLOB = "CLOB";
    public static final String NCLOB = "NCLOB";
    public static final String INT = "INT";
    public static final String TINYINT = "TINYINT";
    public static final String INTEGER = "INTEGER";
    public static final String DECIMAL = "DECIMAL";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String DATETIME = "DATETIME";
    public static final String FUNC_NATIVETYPE = "NATIVE_TYPE";
    private static DB2AS400 instanceDB2AS400 = new DB2AS400();
    private static DB2 instanceDB2 = new DB2();
    private static ORACLE instanceORACLE = new ORACLE();
    private static ORACLE10 instanceORACLE10 = new ORACLE10();
    private static ORACLE9 instanceORACLE9 = new ORACLE9();
    private static PostgresSQL postgreSQL = new PostgresSQL();
    private static MSSQL instanceMSSQL = new MSSQL();
    private static DM instanceDM = new DM();
    private static GS instanceGS = new GS();
    private static GS100 instanceGS100 = new GS100();
    private static OpenGauss instanceOpenGauss = new OpenGauss();
    private static KingBase instanceKingBase = new KingBase();
    private static Gbase instanceGbase = new Gbase();
    private static Gauss200 instanceGauss200 = new Gauss200();
    private static Greenplum instanceGreenplum = new Greenplum();
    private static ClickHouse instanceClickHouselum = new ClickHouse();

    public String nativeType(String type) {
        if (type == null) {
            return "";
        }
        return type.toUpperCase();
    }

    public static DataType getDataType(int dbtype) {
        switch (dbtype) {
            case 9: {
                return instanceDB2AS400;
            }
            case 1: {
                return instanceDB2;
            }
            case 2: {
                return instanceORACLE;
            }
            case 7: {
                return instanceORACLE9;
            }
            case 8: {
                return instanceORACLE10;
            }
            case 3: {
                return instanceMSSQL;
            }
            case 5: {
                return postgreSQL;
            }
            case 11: {
                return instanceDM;
            }
            case 12: {
                return instanceGS;
            }
            case 13: {
                return instanceGS100;
            }
            case 14: {
                return instanceOpenGauss;
            }
            case 15: {
                return instanceKingBase;
            }
            case 103: {
                return instanceGauss200;
            }
            case 104: {
                return instanceGreenplum;
            }
            case 105: {
                return instanceClickHouselum;
            }
        }
        return null;
    }

    static final class Gbase
    extends PostgresSQL {
        Gbase() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.VARCHAR.equalsIgnoreCase(type)) {
                return DataType.VARCHAR;
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "NVARCHAR2";
            }
            if (DataType.DECIMAL.equalsIgnoreCase(type)) {
                return DataType.DECIMAL;
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return "TIMESTAMP WITHOUT TIME ZONE";
            }
            return super.nativeType(type);
        }
    }

    static final class KingBase
    extends PostgresSQL {
        KingBase() {
        }
    }

    static final class Gauss200
    extends PostgresSQL {
        Gauss200() {
        }
    }

    static final class OpenGauss
    extends PostgresSQL {
        OpenGauss() {
        }
    }

    static class GS100
    extends DataType {
        GS100() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.VARCHAR.equalsIgnoreCase(type)) {
                return "VARCHAR2";
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "NVARCHAR2";
            }
            if (DataType.DECIMAL.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.INT.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.INTEGER.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.TINYINT.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return DataType.DATETIME;
            }
            if (DataType.DATE.equalsIgnoreCase(type)) {
                return DataType.DATETIME;
            }
            if (DataType.CLOB.equalsIgnoreCase(type)) {
                return DataType.CLOB;
            }
            return super.nativeType(type);
        }
    }

    static class DM
    extends DataType {
        DM() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.VARCHAR.equalsIgnoreCase(type)) {
                return "VARCHAR2";
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "NVARCHAR2";
            }
            if (DataType.DECIMAL.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.INT.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.INTEGER.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return "TIMESTAMP";
            }
            return super.nativeType(type);
        }
    }

    static final class GS
    extends DataType {
        GS() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.VARCHAR.equalsIgnoreCase(type)) {
                return "CHARACTER VARYING";
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "CHARACTER VARYING";
            }
            if (DataType.DECIMAL.equalsIgnoreCase(type)) {
                return "NUMERIC";
            }
            if (DataType.INT.equalsIgnoreCase(type)) {
                return DataType.INTEGER;
            }
            if (DataType.INTEGER.equalsIgnoreCase(type)) {
                return DataType.INTEGER;
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return "TIMESTAMP WITHOUT TIME ZONE";
            }
            if (DataType.BLOB.equalsIgnoreCase(type)) {
                return "BYTEA";
            }
            if (DataType.CLOB.equalsIgnoreCase(type)) {
                return "TEXT";
            }
            if (DataType.NCLOB.equalsIgnoreCase(type)) {
                return "TEXT";
            }
            return super.nativeType(type);
        }
    }

    static final class ClickHouse
    extends PostgresSQL {
        ClickHouse() {
        }
    }

    static final class Greenplum
    extends PostgresSQL {
        Greenplum() {
        }
    }

    static class PostgresSQL
    extends DataType {
        PostgresSQL() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.VARCHAR.equalsIgnoreCase(type)) {
                return "CHARACTER VARYING";
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "CHARACTER VARYING";
            }
            if (DataType.DECIMAL.equalsIgnoreCase(type)) {
                return "NUMERIC";
            }
            if (DataType.INT.equalsIgnoreCase(type)) {
                return DataType.INTEGER;
            }
            if (DataType.INTEGER.equalsIgnoreCase(type)) {
                return DataType.INTEGER;
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return "TIMESTAMP WITHOUT TIME ZONE";
            }
            if (DataType.BLOB.equalsIgnoreCase(type)) {
                return "BYTEA";
            }
            if (DataType.CLOB.equalsIgnoreCase(type)) {
                return "TEXT";
            }
            if (DataType.NCLOB.equalsIgnoreCase(type)) {
                return "TEXT";
            }
            return super.nativeType(type);
        }
    }

    static class ORACLE10
    extends ORACLE9 {
        ORACLE10() {
        }
    }

    static class ORACLE9
    extends ORACLE {
        ORACLE9() {
        }
    }

    static class ORACLE
    extends DataType {
        ORACLE() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.VARCHAR.equalsIgnoreCase(type)) {
                return "VARCHAR2";
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "NVARCHAR2";
            }
            if (DataType.DECIMAL.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.INT.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.INTEGER.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return "TIMESTAMP";
            }
            return super.nativeType(type);
        }
    }

    static class MSSQL
    extends DataType {
        MSSQL() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.BLOB.equalsIgnoreCase(type)) {
                return "IMAGE";
            }
            if (DataType.CLOB.equalsIgnoreCase(type)) {
                return "TEXT";
            }
            if (DataType.NCLOB.equalsIgnoreCase(type)) {
                return "NTEXT";
            }
            return super.nativeType(type);
        }
    }

    static class DB2
    extends DataType {
        DB2() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.TINYINT.equalsIgnoreCase(type)) {
                return "SMALLINT";
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return "TIMESTAMP";
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "VARGRAPHIC";
            }
            if (DataType.NCHAR.equalsIgnoreCase(type)) {
                return "GRAPHIC";
            }
            if (DataType.NCLOB.equalsIgnoreCase(type)) {
                return DataType.CLOB;
            }
            if (DataType.BINARY.equalsIgnoreCase(type)) {
                return DataType.VARCHAR;
            }
            if (DataType.VARBINARY.equalsIgnoreCase(type)) {
                return DataType.VARCHAR;
            }
            if (DataType.INT.equalsIgnoreCase(type)) {
                return DataType.INT;
            }
            return super.nativeType(type);
        }
    }

    static final class DB2AS400
    extends DB2 {
        DB2AS400() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.INT.equalsIgnoreCase(type)) {
                return DataType.INTEGER;
            }
            return super.nativeType(type);
        }
    }
}

