/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.dom.expr;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import kd.bos.ksql.dom.SqlObject;
import kd.bos.ksql.dom.expr.ExprType;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDoubleExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlNullExpr;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.formater.DrSQLFormater;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.parser.SqlExprParser;

public abstract class SqlExpr
extends SqlObject
implements Serializable {
    private String exprWord = "";
    private volatile List subQueries = null;
    public int type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List subQueries() {
        if (this.subQueries == null) {
            SqlExpr sqlExpr = this;
            synchronized (sqlExpr) {
                if (this.subQueries == null) {
                    this.subQueries = new ArrayList();
                }
            }
        }
        return this.subQueries;
    }

    protected SqlExpr(int type) {
        this.type = type;
        switch (type) {
            case 13: {
                this.setExprWord("IN");
                break;
            }
        }
    }

    public String typename() {
        return ExprType.typename(this.type);
    }

    @Override
    public void output(StringBuilder buffer, String prefix) {
        buffer.append(prefix);
        buffer.append("SqlExpr:");
        buffer.append(this.typename());
        buffer.append("\n");
    }

    public static SqlExpr toExpr(int value) {
        return new SqlIntExpr(Integer.toString(value));
    }

    public static SqlExpr toExpr(long value) {
        throw new UnsupportedOperationException("");
    }

    public static SqlExpr toExpr(double value) {
        return new SqlIntExpr(Double.toString(value));
    }

    public static SqlExpr toExpr(Timestamp value) {
        if (value == null) {
            return SqlNullExpr.instance;
        }
        throw new UnsupportedOperationException("");
    }

    public static SqlExpr toExpr(byte[] value) {
        if (value == null) {
            return SqlNullExpr.instance;
        }
        throw new UnsupportedOperationException("");
    }

    public static SqlExpr toExpr(BigDecimal value) {
        if (value == null) {
            return SqlNullExpr.instance;
        }
        return new SqlDoubleExpr(value.toString());
    }

    public static SqlExpr toCharExpr(String value) {
        if (value == null) {
            return SqlNullExpr.instance;
        }
        return new SqlCharExpr(value);
    }

    public static SqlExpr toNCharExpr(String value) {
        if (value == null) {
            return SqlNullExpr.instance;
        }
        return new SqlNCharExpr(value);
    }

    public void output(StringBuilder buff) {
        try {
            new DrSQLFormater(buff).formatExpr(this);
        }
        catch (FormaterException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        this.output(buff);
        return buff.toString();
    }

    @Override
    public Object clone() {
        String str = this.toString();
        try {
            SqlExprParser parser = new SqlExprParser(str);
            SqlExpr new_expr = parser.expr();
            return new_expr;
        }
        catch (ParserException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getExprWord() {
        return this.exprWord;
    }

    public String getOrgValue() {
        return this.toString();
    }

    public void setExprWord(String exprWord) {
        this.exprWord = exprWord;
    }
}

