/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.dom.stmt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.ksql.dom.SqlObject;
import kd.bos.ksql.dom.stmt.StmtType;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.formater.DrSQLFormater;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.parser.SqlStmtParser;

public abstract class SqlStmt
extends SqlObject
implements Serializable,
Cloneable {
    private List<String> reverseComments = new ArrayList<String>(1);
    public int type;

    protected SqlStmt(int type) {
        this.type = type;
    }

    public void addReverseComments(String commentContent) {
        this.reverseComments.add(commentContent);
    }

    public String typename() {
        return StmtType.typename(this.type);
    }

    @Override
    public Object clone() {
        String str = this.toString();
        try {
            SqlStmtParser parser = new SqlStmtParser(str);
            SqlStmt new_stmt = parser.stmt();
            return new_stmt;
        }
        catch (ParserException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void formatComments(StringBuilder buff) {
        for (int i = this.reverseComments.size() - 1; i >= 0; --i) {
            buff.append("/*").append(this.reverseComments.get(i)).append("*/");
        }
    }

    public void output(StringBuilder buff) {
        this.output(buff, null);
    }

    @Override
    public void output(StringBuilder buff, String prefix) {
        try {
            if (prefix != null) {
                buff.append(prefix);
            }
            this.formatComments(buff);
            new DrSQLFormater(buff).formatStmt(this);
        }
        catch (FormaterException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(512);
        this.output(buff);
        return buff.toString();
    }
}

