/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.ksql.dom.SqlBlockStmt;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlBreakStmt;
import kd.bos.ksql.dom.stmt.SqlCloseStmt;
import kd.bos.ksql.dom.stmt.SqlContinueStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlCursorLoopStmt;
import kd.bos.ksql.dom.stmt.SqlDeallocateStmt;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlDropTableStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlFetchStmt;
import kd.bos.ksql.dom.stmt.SqlGotoStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlLabelStmt;
import kd.bos.ksql.dom.stmt.SqlOpenStmt;
import kd.bos.ksql.dom.stmt.SqlSelectStmt;
import kd.bos.ksql.dom.stmt.SqlSetLocalVariantStmt;
import kd.bos.ksql.dom.stmt.SqlShowColumnsStmt;
import kd.bos.ksql.dom.stmt.SqlShowTablesStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.dom.stmt.SqlWhileStmt;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.TSQLFormater;
import kd.bos.ksql.parser.KeyWord;
import kd.bos.ksql.schema.FunctionDef;
import kd.bos.ksql.schema.ParameterDef;
import kd.bos.util.DisCardUtil;

public class DrSQLFormater
extends TSQLFormater {
    public static final DrSQLFormater instance = new DrSQLFormater();

    public DrSQLFormater(StringBuilder sb) {
        super(sb);
        this.max_length_of_index_name = 30;
        this.max_length_of_constraint_name = 18;
        this.max_length_of_column_name = 30;
        this.max_length_of_column_count = 255;
        this.max_length_of_row_size = 8000;
    }

    public DrSQLFormater() {
        this(null);
    }

    @Override
    public void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        super.formatInsertStmt(stmt);
    }

    public static List getStandardFuncList_0() {
        ArrayList<FunctionDef> list = new ArrayList<FunctionDef>();
        FunctionDef func = new FunctionDef("ABS", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("ACOS", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("ASIN", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("ATAN", "FLOAT");
        func.name = "ATAN";
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("ATN2", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("CEILING", "INT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("COS", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("EXPR", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("FLOOR", "INT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("MOD", "INT");
        func.addParam(new ParameterDef(null, "INT"));
        func.addParam(new ParameterDef(null, "INT"));
        list.add(func);
        func = new FunctionDef("LOG", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("POWER", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("ROUND", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        func.addParam(new ParameterDef(null, "INT"));
        list.add(func);
        func = new FunctionDef("SIGN", "BOOL");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("SIN", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("SQRT", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        func = new FunctionDef("TAN", "FLOAT");
        func.addParam(new ParameterDef(null, "FLOAT"));
        list.add(func);
        return list;
    }

    public boolean isValidateTableName(String tableName) {
        if (tableName == null || tableName.length() == 0) {
            return false;
        }
        int len = tableName.length();
        if (len > this.max_length_of_table_name) {
            return false;
        }
        return this.isValidateIdentifier(tableName);
    }

    public boolean isValidateIdentifier(String ident) {
        char ch = ident.charAt(0);
        if (ch != '_' && !Character.isLetter(ch)) {
            return false;
        }
        int len = ident.length();
        for (int i = 1; i < len; ++i) {
            ch = ident.charAt(i);
            if (ch == '_' || Character.isLetterOrDigit(ch)) continue;
            return false;
        }
        boolean isKeyword = KeyWord.instance.isKeyWord(ident);
        return !isKeyword;
    }

    public boolean isValidateColumnName(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return false;
        }
        int len = columnName.length();
        if (len > this.max_length_of_column_name) {
            return false;
        }
        return this.isValidateIdentifier(columnName);
    }

    public boolean isValidateIndexName(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return false;
        }
        int len = columnName.length();
        if (len > this.max_length_of_index_name) {
            return false;
        }
        return this.isValidateIdentifier(columnName);
    }

    public boolean isValidateConstraintName(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return false;
        }
        int len = columnName.length();
        if (len > this.max_length_of_constraint_name) {
            return false;
        }
        return this.isValidateIdentifier(columnName);
    }

    public static List getStandardFuncList_1() {
        ArrayList<FunctionDef> list = new ArrayList<FunctionDef>();
        FunctionDef func = new FunctionDef("ASCII", "INT");
        func.addParam(new ParameterDef(null, "CHAR(1)"));
        list.add(func);
        func = new FunctionDef("CHAR", "CHAR(1)");
        func.addParam(new ParameterDef(null, "INT"));
        list.add(func);
        return list;
    }

    @Override
    public void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        String sql = "SHOW TABLES";
        this.buffer.append(sql);
    }

    @Override
    public void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        String sql = "SHOW COLUMNS FROM '" + stmt.tableName + "'";
        this.buffer.append(sql);
    }

    public void formatExecStmt(SqlExecStmt stmt, FormatOptions options) throws FormaterException {
        this.buffer.append("EXEC ");
        this.buffer.append(stmt.processName);
        if (stmt.paramList.size() != 0) {
            this.buffer.append(" ");
            boolean flag = false;
            Iterator iter = stmt.paramList.iterator();
            while (iter.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iter.next();
                this.formatExpr(expr);
                flag = true;
            }
        }
    }

    @Override
    public void formatColumnDef(SqlColumnDef column) throws FormaterException {
        if (column.name == null) {
            throw new FormaterException("column name is null");
        }
        if (this.max_length_of_column_name != -1 && column.name != null && column.name.length() > this.max_length_of_column_name) {
            throw new FormaterException("column name greate than " + this.max_length_of_column_name + ", column name is '" + column.name + "'");
        }
        this.buffer.append(column.name);
        this.buffer.append(" ");
        if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("BINARY (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("DATETIME");
        } else if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("NUMERIC (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("INT") || column.dataType.equalsIgnoreCase("INTTEGER")) {
            this.buffer.append("INT");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("NCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("NCLOB (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NUMERIC")) {
            this.buffer.append("NUMERIC (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("NVARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("SMALLINT")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("VARBINARY (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else {
            throw new FormaterException("not support datatype, column name is '" + column.name + "' datatype is '" + column.dataType + "'");
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                this.buffer.append(" NULL");
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        } else {
            DisCardUtil.discard();
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    public void formatSelectItem(SqlSelectItem item) throws FormaterException {
        if (item.alias != null && item.alias.length() != 0) {
            this.formatExpr(item.expr);
            this.buffer.append(" ");
            this.buffer.append(item.alias);
        } else {
            this.formatExpr(item.expr, false);
        }
    }

    @Override
    public void formatSelect(SqlSelect select) throws FormaterException {
        this.buffer.append("SELECT ");
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct == 0) {
            DisCardUtil.discard();
        } else {
            throw new FormaterException("distinct option not support.");
        }
        if (select.limit != null) {
            this.buffer.append("TOP ");
            this.buffer.append(select.limit.rowCount);
            this.buffer.append(" ");
            if (select.limit.type == 1) {
                throw new FormaterException("'TOP PERCENT' is not support.");
            }
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlSelectItem item = (SqlSelectItem)iterator.next();
            this.formatSelectItem(item);
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        }
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
        }
        if (select.hierarchicalQueryClause != null) {
            throw new FormaterException("NOT SUPPORT hierarchicalQueryClause");
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                this.formatExpr(orderByIterm.expr);
                if (orderByIterm.chineseOrderByMode == 2 || orderByIterm.chineseOrderByMode == 4 || orderByIterm.chineseOrderByMode == 3) {
                    this.buffer.append(" ");
                    this.buffer.append(orderByIterm.getOrgChineseOrderByType());
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
    }

    @Override
    public void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            this.buffer.append(simpleTableSource.name);
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias);
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias);
            }
        } else {
            throw new FormaterException("not support tableSource:" + tableSource);
        }
    }

    @Override
    public void formatDateTimeExpr(SqlDateTimeExpr expr) throws FormaterException {
        this.buffer.append("{");
        if (expr.timeType() == -19000) {
            this.buffer.append("TS '");
            this.buffer.append(expr.getYear() < 10 ? "0" : "");
            this.buffer.append(expr.getYear());
            this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
            this.buffer.append(expr.getMonth());
            this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
            this.buffer.append(expr.getDate());
            this.buffer.append(expr.getHour() < 10 ? " 0" : " ");
            this.buffer.append(expr.getHour());
            this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
            this.buffer.append(expr.getMinute());
            this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
            this.buffer.append(expr.getSecond());
        } else if (expr.timeType() == -19001) {
            this.buffer.append("D '");
            this.buffer.append(expr.getYear() < 10 ? "0" : "");
            this.buffer.append(expr.getYear());
            this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
            this.buffer.append(expr.getMonth());
            this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
            this.buffer.append(expr.getDate());
        } else if (expr.timeType() == -19002) {
            this.buffer.append("T '");
            this.buffer.append(expr.getHour() < 10 ? "0" : "");
            this.buffer.append(expr.getHour());
            this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
            this.buffer.append(expr.getMinute());
            this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
            this.buffer.append(expr.getSecond());
        }
        this.buffer.append("'}");
    }

    @Override
    public void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        String methodNameI = expr.methodName.toUpperCase();
        this.buffer.append(methodNameI);
        this.buffer.append("(");
        boolean flag = false;
        for (SqlExpr pramExpr : expr.parameters) {
            if (flag) {
                this.buffer.append(", ");
            }
            this.formatExpr(pramExpr);
            flag = true;
        }
        this.buffer.append(")");
    }

    @Override
    public void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NOT ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            return;
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 0) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)expr.left;
                if (binaryOpLeft.operator == 0) {
                    this.formatExpr(binaryOpLeft, false);
                } else {
                    this.formatExpr(binaryOpLeft);
                }
            } else {
                this.formatExpr(expr.left);
            }
            this.buffer.append(" + ");
            if (expr.right instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpRight = (SqlBinaryOpExpr)expr.right;
                if (binaryOpRight.operator == 0) {
                    this.formatExpr(binaryOpRight, false);
                } else {
                    this.formatExpr(binaryOpRight);
                }
            } else {
                this.formatExpr(expr.right);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 8) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
            SqlExpr sqlExpr = expr;
            while (sqlExpr != null || !list.isEmpty()) {
                while (sqlExpr != null) {
                    if (!(sqlExpr instanceof SqlBinaryOpExpr)) {
                        this.formatExpr(sqlExpr);
                        sqlExpr = null;
                        continue;
                    }
                    SqlBinaryOpExpr sqlBExpr = sqlExpr;
                    if (sqlBExpr.operator == 8) {
                        if (sqlBExpr.left instanceof SqlBinaryOpExpr) {
                            SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)sqlBExpr.left;
                            if (binaryOpLeft.operator == 8) {
                                list.add(sqlBExpr.right);
                                sqlExpr = binaryOpLeft;
                                continue;
                            }
                            this.formatExpr(binaryOpLeft);
                            this.buffer.append(" OR ");
                            sqlExpr = sqlBExpr.right;
                            continue;
                        }
                        this.formatExpr(sqlBExpr.left);
                        this.buffer.append(" OR ");
                        sqlExpr = sqlBExpr.right;
                        continue;
                    }
                    this.formatExpr(sqlExpr);
                    sqlExpr = null;
                }
                if (list.isEmpty()) continue;
                this.buffer.append(" OR ");
                sqlExpr = (SqlExpr)list.remove(list.size() - 1);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        boolean needBrace = true;
        String opString = null;
        switch (expr.operator) {
            case 0: {
                opString = " + ";
                break;
            }
            case 1: {
                opString = " AS ";
                break;
            }
            case 2: {
                opString = " = ";
                break;
            }
            case 7: {
                needBrace = false;
                opString = " AND ";
                break;
            }
            case 8: {
                opString = " OR ";
                break;
            }
            case 42: {
                opString = " || ";
                break;
            }
            case 9: {
                opString = " / ";
                break;
            }
            case 10: {
                opString = " = ";
                break;
            }
            case 11: {
                opString = " > ";
                break;
            }
            case 12: {
                opString = " >= ";
                break;
            }
            case 14: {
                opString = " < ";
                break;
            }
            case 15: {
                opString = " <= ";
                break;
            }
            case 16: {
                opString = " <> ";
                break;
            }
            case 18: {
                opString = " LIKE ";
                break;
            }
            case 45: {
                opString = " ILIKE ";
                break;
            }
            case 44: {
                opString = " LIKE ";
                break;
            }
            case 20: {
                opString = ".";
                break;
            }
            case 21: {
                opString = " % ";
                break;
            }
            case 22: {
                opString = " * ";
                break;
            }
            case 23: {
                opString = " != ";
                break;
            }
            case 25: {
                opString = " !> ";
                break;
            }
            case 24: {
                opString = " !< ";
                break;
            }
            case 40: 
            case 46: {
                opString = " NOT LIKE ";
                break;
            }
            case 19: {
                opString = " >> ";
                break;
            }
            case 26: {
                opString = " - ";
                break;
            }
            case 27: {
                opString = " UNION ";
                break;
            }
            default: {
                throw new FormaterException("not support");
            }
        }
        if (appendBrace && needBrace) {
            this.buffer.append("(");
        }
        this.formatExpr(expr.left);
        this.buffer.append(opString);
        this.formatExpr(expr.right);
        if (appendBrace && needBrace) {
            this.buffer.append(")");
        }
    }

    @Override
    protected void validateCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        super.validateCreateTableStmt(stmt);
        if (stmt.name.indexOf(" ") >= 0) {
            throw new FormaterException("table name cannot contians space.");
        }
    }

    @Override
    public void formatBlockStmt(SqlBlockStmt stmt) throws FormaterException {
        int i;
        if (stmt.declItemList != null && stmt.declItemList.size() != 0) {
            this.buffer.append("DECLARE ");
            for (i = 0; i < stmt.declItemList.size(); ++i) {
                SqlBlockStmt.DeclItem item = (SqlBlockStmt.DeclItem)stmt.declItemList.get(i);
                if (item instanceof SqlBlockStmt.DeclVarItem) {
                    SqlBlockStmt.DeclVarItem declItem = (SqlBlockStmt.DeclVarItem)item;
                    this.buffer.append(item.name);
                    this.buffer.append(" ");
                    if (declItem.dataType.equalsIgnoreCase("BINARY")) {
                        this.buffer.append("BINARY (");
                        this.buffer.append(declItem.length);
                        this.buffer.append(")");
                    } else if (declItem.dataType.equalsIgnoreCase("BLOB")) {
                        this.buffer.append("BLOB");
                    } else if (declItem.dataType.equalsIgnoreCase("CHAR")) {
                        this.buffer.append("CHAR (");
                        this.buffer.append(declItem.length);
                        this.buffer.append(")");
                    } else if (declItem.dataType.equalsIgnoreCase("CLOB")) {
                        this.buffer.append("CLOB");
                    } else if (declItem.dataType.equalsIgnoreCase("DATETIME")) {
                        this.buffer.append("DATETIME");
                    } else if (declItem.dataType.equalsIgnoreCase("DECIMAL")) {
                        this.buffer.append("NUMERIC (");
                        this.buffer.append(declItem.precision);
                        this.buffer.append(", ");
                        this.buffer.append(declItem.scale);
                        this.buffer.append(")");
                    } else if (declItem.dataType.equalsIgnoreCase("INT") || declItem.dataType.equalsIgnoreCase("INTTEGER")) {
                        this.buffer.append("INT");
                    } else if (declItem.dataType.equalsIgnoreCase("NCHAR")) {
                        this.buffer.append("NCHAR (");
                        this.buffer.append(declItem.length);
                        this.buffer.append(")");
                    } else if (declItem.dataType.equalsIgnoreCase("NCLOB")) {
                        this.buffer.append("NCLOB");
                    } else if (declItem.dataType.equalsIgnoreCase("NUMERIC")) {
                        this.buffer.append("NUMERIC (");
                        this.buffer.append(declItem.precision);
                        this.buffer.append(", ");
                        this.buffer.append(declItem.scale);
                        this.buffer.append(")");
                    } else if (declItem.dataType.equalsIgnoreCase("NVARCHAR")) {
                        this.buffer.append("NVARCHAR (");
                        this.buffer.append(declItem.length);
                        this.buffer.append(")");
                    } else if (declItem.dataType.equalsIgnoreCase("SMALLINT")) {
                        this.buffer.append("SMALLINT");
                    } else if (declItem.dataType.equalsIgnoreCase("VARBINARY")) {
                        this.buffer.append("VARBINARY (");
                        this.buffer.append(declItem.length);
                        this.buffer.append(")");
                    } else if (declItem.dataType.equalsIgnoreCase("VARCHAR")) {
                        this.buffer.append("VARCHAR (");
                        this.buffer.append(declItem.length);
                        this.buffer.append(")");
                    } else {
                        throw new FormaterException("not support datatype, column name is '" + declItem.name + "' datatype is '" + declItem.dataType + "'");
                    }
                    if (declItem.defaultValueExpr != null) {
                        this.buffer.append(" = ");
                        this.formatExpr(declItem.defaultValueExpr);
                    }
                    this.buffer.append(";\n");
                    continue;
                }
                if (item instanceof SqlBlockStmt.DeclCurItem) {
                    SqlBlockStmt.DeclCurItem curItem = (SqlBlockStmt.DeclCurItem)item;
                    this.buffer.append("CURSOR ");
                    String name = curItem.name;
                    if (name != null && name.length() > 0 && name.charAt(0) == '@') {
                        name = name.substring(1);
                        this.buffer.append(name);
                    } else {
                        this.buffer.append(name);
                    }
                    this.buffer.append(" IS ");
                    this.formatSelectBase(curItem.select);
                    this.buffer.append(";\n");
                    continue;
                }
                throw new FormaterException("not support statement:" + item);
            }
        }
        this.buffer.append("BEGIN\n");
        int size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("END;");
    }

    @Override
    public void formatSetLocalVariantStmt(SqlSetLocalVariantStmt stmt) throws FormaterException {
        this.buffer.append("SET ");
        this.formatExpr(stmt.variant);
        this.buffer.append(" = ");
        this.formatExpr(stmt.value);
    }

    @Override
    public void formatIfStmt(SqlIfStmt stmt) throws FormaterException {
        SqlStmt itemStmt;
        int i;
        this.buffer.append("IF (");
        this.formatExpr(stmt.condition);
        this.buffer.append(")\n");
        this.buffer.append("BEGIN\n");
        for (i = 0; i < stmt.trueStmtList.size(); ++i) {
            itemStmt = (SqlStmt)stmt.trueStmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("END");
        if (stmt.falseStmtList != null && stmt.falseStmtList.size() > 0) {
            this.buffer.append("ELSE\n");
            this.buffer.append("BEGIN\n");
            for (i = 0; i < stmt.falseStmtList.size(); ++i) {
                itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                this.formatStmt(itemStmt);
                this.buffer.append(";\n");
            }
            this.buffer.append("END");
        }
    }

    @Override
    public void formatWhileStmt(SqlWhileStmt stmt) throws FormaterException {
        this.buffer.append("WHILE ");
        this.formatExpr(stmt.condition);
        this.buffer.append("\n");
        this.buffer.append("BEGIN\n");
        for (int i = 0; i < stmt.stmtList.size(); ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("END");
    }

    @Override
    public void formatDeallocateStmt(SqlDeallocateStmt stmt) throws FormaterException {
        this.buffer.append("DEALLOCATE ");
        this.buffer.append(stmt.curName);
    }

    @Override
    public void formatCloseStmt(SqlCloseStmt stmt) throws FormaterException {
        this.buffer.append("CLOSE ");
        this.buffer.append(stmt.curName);
    }

    @Override
    public void formatOpenStmt(SqlOpenStmt stmt) throws FormaterException {
        this.buffer.append("OPEN ");
        this.buffer.append(stmt.curName);
    }

    @Override
    public void formatCursorLoopStmt(SqlCursorLoopStmt stmt) throws FormaterException {
        SqlExpr expr;
        int i;
        this.buffer.append("CURSOR_LOOP ");
        this.buffer.append(stmt.curName);
        if (stmt.fieldList != null && stmt.fieldList.size() > 0) {
            this.buffer.append(" (");
            for (i = 0; i < stmt.fieldList.size(); ++i) {
                if (i != 0) {
                    this.buffer.append(", ");
                }
                expr = (SqlExpr)stmt.fieldList.get(i);
                this.formatExpr(expr);
            }
            this.buffer.append(")");
        }
        this.buffer.append(" INTO ");
        if (stmt.fieldList != null && stmt.intoList.size() > 0) {
            this.buffer.append(" (");
            for (i = 0; i < stmt.intoList.size(); ++i) {
                if (i != 0) {
                    this.buffer.append(", ");
                }
                expr = (SqlExpr)stmt.intoList.get(i);
                this.formatExpr(expr);
            }
            this.buffer.append(")");
        }
        this.buffer.append(" DO\n");
        int size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("END CURSOR_LOOP");
    }

    @Override
    public void formatFetchStmt(SqlFetchStmt stmt) throws FormaterException {
        throw new FormaterException("not support formater fetch statement");
    }

    @Override
    public void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        this.buffer.append("BREAK");
    }

    @Override
    public void formatContinueStmt(SqlContinueStmt stmt) throws FormaterException {
        this.buffer.append("CONTINUE");
    }

    @Override
    public void formatGotoStmt(SqlGotoStmt stmt) throws FormaterException {
        this.buffer.append("GOTO ");
        this.buffer.append(stmt.name);
    }

    @Override
    public void formatLabelStmt(SqlLabelStmt stmt) throws FormaterException {
        this.buffer.append(stmt.name);
        this.buffer.append(":");
    }

    @Override
    public void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        super.formatCreateTableStmt(stmt);
    }

    @Override
    public void formatDropTableStmt(SqlDropTableStmt stmt) throws FormaterException {
        super.formatDropTableStmt(stmt);
    }

    @Override
    public void formatAlterTableStmt(SqlAlterTableStmt stmt) throws FormaterException {
        super.formatAlterTableStmt(stmt);
    }

    @Override
    public void formatSelectStmt(SqlSelectStmt stmt) throws FormaterException {
        super.formatSelectStmt(stmt);
    }

    @Override
    public void formatUpdateStmt(SqlUpdateStmt stmt) throws FormaterException {
        super.formatUpdateStmt(stmt);
    }

    @Override
    public void formatDeleteStmt(SqlDeleteStmt stmt) throws FormaterException {
        super.formatDeleteStmt(stmt);
    }

    public static class Types {
    }
}

