/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import kd.bos.ksql.DbType;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.ksql.extension.KSQLExtensionsRegister;
import kd.bos.ksql.formater.ClickHouseSQLFormater;
import kd.bos.ksql.formater.DB2AS400SQLFormater;
import kd.bos.ksql.formater.DB2SQLFormater;
import kd.bos.ksql.formater.DMSQLFormater;
import kd.bos.ksql.formater.DrSQLFormater;
import kd.bos.ksql.formater.GS100SQLFormater;
import kd.bos.ksql.formater.GSSQLFormater;
import kd.bos.ksql.formater.Gauss200SQLFormater;
import kd.bos.ksql.formater.GaussDBSQLFormater;
import kd.bos.ksql.formater.GbaseFormater;
import kd.bos.ksql.formater.GreenplumFormater;
import kd.bos.ksql.formater.HANASQLFormater;
import kd.bos.ksql.formater.KingBaseSQLFormater;
import kd.bos.ksql.formater.MSTransactSQLFormater;
import kd.bos.ksql.formater.MySQLFormater;
import kd.bos.ksql.formater.OceanBaseForOracleSQLFormater;
import kd.bos.ksql.formater.Oracle10SQLFormater;
import kd.bos.ksql.formater.Oracle9SQLFormater;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.formater.SybaseTransactSQLFormater;
import kd.bos.ksql.formater.TDSQLFormater;
import kd.bos.ksql.formater.TiDBFormater;
import kd.bos.ksql.formater.VastbaseFormater;
import kd.bos.ksql.formater.YasDBSQLFormater;

public abstract class FormaterFactory {
    public static SQLFormater getFormater(int dbType) throws SqlTranslateException {
        switch (dbType) {
            case 9: {
                return new DB2AS400SQLFormater();
            }
            case 1: {
                return new DB2SQLFormater();
            }
            case 6: {
                return new MySQLFormater();
            }
            case 3: {
                return new MSTransactSQLFormater();
            }
            case 2: {
                return new Oracle9SQLFormater();
            }
            case 8: {
                return new Oracle10SQLFormater();
            }
            case 7: {
                return new Oracle9SQLFormater();
            }
            case 5: {
                return KSQLExtensionsRegister.getPostgreSQLFormater();
            }
            case 4: {
                return new SybaseTransactSQLFormater();
            }
            case 11: {
                return new DMSQLFormater();
            }
            case 12: {
                return new GSSQLFormater();
            }
            case 13: {
                return new GS100SQLFormater();
            }
            case 14: {
                return new GaussDBSQLFormater();
            }
            case 15: {
                return new KingBaseSQLFormater();
            }
            case 16: {
                return new VastbaseFormater();
            }
            case 18: {
                return new GbaseFormater();
            }
            case 17: {
                return new TDSQLFormater();
            }
            case 19: {
                return new TiDBFormater();
            }
            case 20: {
                return new YasDBSQLFormater();
            }
            case 21: {
                return new OceanBaseForOracleSQLFormater();
            }
            case 101: {
                return new HANASQLFormater();
            }
            case 102: {
                return new DrSQLFormater();
            }
            case 103: {
                return new Gauss200SQLFormater();
            }
            case 104: {
                return new GreenplumFormater();
            }
            case 105: {
                return new ClickHouseSQLFormater();
            }
        }
        throw new SqlTranslateException("DbType is not supported." + DbType.getName(dbType));
    }
}

