/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.expr.SqlAggregateExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.stmt.SqlDropTableStmt;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.Oracle10gHints;
import kd.bos.ksql.formater.Oracle9SQLFormater;
import kd.bos.ksql.formater.OracleHints;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.util.UUTN;
import kd.bos.util.DisCardUtil;

public class GS100SQLFormater
extends Oracle9SQLFormater {
    public GS100SQLFormater() {
        super(null);
    }

    public GS100SQLFormater(StringBuilder sb) {
        super(sb);
    }

    @Override
    public OracleHints getHints() {
        return Oracle10gHints.getInstance();
    }

    @Override
    protected String declareIntegerType() {
        return "INTEGER";
    }

    @Override
    protected void formatDropTableStmt(SqlDropTableStmt stmt) throws FormaterException {
        this.buffer.append("DROP TABLE ");
        this.buffer.append(this.formatTableName(stmt.tableName));
        if (UUTN.isTempTable(stmt.tableName)) {
            this.buffer.append(" PURGE");
        }
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        this.buffer.append(column.name);
        this.buffer.append(" ");
        if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR") || column.dataType.equalsIgnoreCase("VARCHAR2")) {
            this.buffer.append("VARCHAR2 (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("NCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR") || column.dataType.equalsIgnoreCase("NVARCHAR2")) {
            this.buffer.append("NVARCHAR2 (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NUMBER") || column.dataType.equalsIgnoreCase("DECIMAL")) {
            if (column.precision >= 0) {
                this.buffer.append("NUMBER (");
                this.buffer.append(column.precision);
                this.buffer.append(", ");
                this.buffer.append(column.scale);
                this.buffer.append(")");
            } else {
                this.buffer.append("NUMBER");
            }
        } else if (column.dataType.equalsIgnoreCase("INT") && !column.autoIncrement || column.dataType.equalsIgnoreCase("INTEGER") && !column.autoIncrement) {
            this.buffer.append("NUMBER (10)");
        } else if (column.dataType.equalsIgnoreCase("SMALLINT")) {
            this.buffer.append("NUMBER (10)");
        } else if (column.dataType.equalsIgnoreCase("BIGINT")) {
            this.buffer.append("NUMBER (19)");
        } else if (column.dataType.equalsIgnoreCase("DATETIME") || column.dataType.equalsIgnoreCase("DATE")) {
            this.buffer.append("DATE");
        } else if (column.dataType.equalsIgnoreCase("LONG")) {
            this.buffer.append("LONG");
        } else if (column.dataType.equalsIgnoreCase("RAW") || column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("RAW (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("LONG RAW") || column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("LONG RAW");
        } else if (column.dataType.equalsIgnoreCase("ROWID")) {
            this.buffer.append("ROWID");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("CLOB");
        } else if (column.dataType.equalsIgnoreCase("BFILE")) {
            this.buffer.append("BFILE");
        } else if (column.dataType.equalsIgnoreCase("UROWID")) {
            this.buffer.append("UROWID");
        } else if (column.dataType.equalsIgnoreCase("FLOAT")) {
            if (column.length != 0) {
                this.buffer.append("FLOAT (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else {
                this.buffer.append("FLOAT");
            }
        } else if (column.dataType.equalsIgnoreCase("INT") && column.autoIncrement) {
            this.buffer.append("INT");
            this.context.put("Identity", column.name);
        } else if (column.dataType.equalsIgnoreCase("XMLTYPE") || column.dataType.equalsIgnoreCase("XML")) {
            this.buffer.append("XMLTYPE");
        } else {
            throw new FormaterException("not support datatype, column name is '" + column.name + "' datatype is '" + column.dataType + "'");
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            if ((column.defaultValueExpr instanceof SqlCharExpr || column.defaultValueExpr instanceof SqlNCharExpr) && "".equals(column.defaultValueExpr.toString())) {
                this.buffer.append(" ' ' ");
            } else {
                this.formatExpr(column.defaultValueExpr);
            }
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                this.buffer.append(" NULL");
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        } else {
            DisCardUtil.discard();
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        if (select.into != null) {
            this.buffer.append("CREATE TABLE ");
            this.buffer.append(select.into.new_table);
            this.buffer.append(" AS ");
        }
        if (select.limit != null && (select.orderBy.size() != 0 || select.groupBy.size() != 0)) {
            this.buffer.append("SELECT * FROM (SELECT ");
        } else {
            this.buffer.append("SELECT ");
        }
        this.getHints().formatHints(select.getHints(), select, this.buffer);
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct == 0) {
            DisCardUtil.discard();
        } else {
            throw new FormaterException("distinct option not support.");
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            SqlIdentifierExpr tableNameExpr;
            SqlIdentifierExpr columnNameExpr;
            SqlSelectItem item;
            block101: {
                block99: {
                    block111: {
                        block110: {
                            block109: {
                                block108: {
                                    block107: {
                                        block106: {
                                            block105: {
                                                block104: {
                                                    block103: {
                                                        block102: {
                                                            block100: {
                                                                if (flag) {
                                                                    this.buffer.append(", ");
                                                                }
                                                                item = (SqlSelectItem)iterator.next();
                                                                if (!(item.expr instanceof SqlIdentifierExpr)) break block99;
                                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || item.alias != null) break block100;
                                                                item.alias = Token.KSQL_COL_NAME.value;
                                                                break block101;
                                                            }
                                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || item.alias != null) break block102;
                                                            item.alias = Token.KSQL_COL_DEFAULT.value;
                                                            break block101;
                                                        }
                                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value) || item.alias != null) break block103;
                                                        item.alias = Token.TABNAME.value;
                                                        break block101;
                                                    }
                                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value) || item.alias != null) break block104;
                                                    item.alias = Token.KSQL_CREATETIME.value;
                                                    break block101;
                                                }
                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || item.alias != null) break block105;
                                                item.alias = Token.KSQL_COL_TABNAME.value;
                                                break block101;
                                            }
                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) || item.alias != null) break block106;
                                            item.alias = Token.KSQL_COL_LENGTH.value;
                                            break block101;
                                        }
                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value) || item.alias != null) break block107;
                                        item.alias = Token.KSQL_COL_TYPE.value;
                                        break block101;
                                    }
                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) || item.alias != null) break block108;
                                    item.alias = Token.KSQL_COL_NULLABLE.value;
                                    break block101;
                                }
                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) || item.alias != null) break block109;
                                item.alias = Token.INDNAME.value;
                                break block101;
                            }
                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || item.alias != null) break block110;
                            item.alias = Token.KSQL_CONS_NAME.value;
                            break block101;
                        }
                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || item.alias != null) break block111;
                        item.alias = Token.KSQL_CONS_TABNAME.value;
                        break block101;
                    }
                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) || item.alias != null) break block101;
                    item.alias = Token.KSQL_CONS_TYPE.value;
                    break block101;
                }
                if (item.expr instanceof SqlAggregateExpr) {
                    List TparamList = ((SqlAggregateExpr)item.expr).paramList;
                    for (SqlExpr param : TparamList) {
                        if (!(param instanceof SqlIdentifierExpr)) continue;
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "COLUMN_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.INDNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "INDEX_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_TYPE";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                            ((SqlIdentifierExpr)param).value = "DATA_DEFAULT";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                            ((SqlIdentifierExpr)param).value = "NULLABLE";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
                            ((SqlIdentifierExpr)param).value = "DATA_LENGTH";
                            continue;
                        }
                        if (!((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) continue;
                        ((SqlIdentifierExpr)param).value = "DATA_TYPE";
                    }
                }
            }
            if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlIdentifierExpr) {
                    if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                        columnNameExpr = new SqlIdentifierExpr();
                        columnNameExpr.value = "COLUMN_NAME";
                        this.formatExpr(columnNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CREATE_TIME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "INDEX_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CONSTRAINT_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CONSTRAINT_TYPE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_DEFAULT";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "NULLABLE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_TYPE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_LENGTH";
                        this.formatExpr(tableNameExpr);
                    } else {
                        this.formatExpr(item.expr);
                    }
                } else {
                    this.formatExpr(item.expr);
                }
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase());
            } else if (item.expr instanceof SqlIdentifierExpr) {
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                    columnNameExpr = new SqlIdentifierExpr();
                    columnNameExpr.value = "COLUMN_NAME";
                    this.formatExpr(columnNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CREATE_TIME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "INDEX_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_TYPE";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "DATA_DEFAULT";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "NULLABLE";
                    this.formatExpr(tableNameExpr, false);
                } else {
                    this.formatExpr(item.expr, false);
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        } else {
            this.buffer.append(" FROM DUAL");
        }
        boolean whereFlag = false;
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
            whereFlag = true;
        }
        if (select.limit != null && select.orderBy.size() == 0 && select.groupBy.size() == 0) {
            this.buffer.insert(0, "SELECT * FROM ( ");
            this.buffer.append(")  rownum_t WHERE ROWNUM <= ");
            this.buffer.append(select.limit.rowCount + select.limit.offset);
            if (select.limit.type == 1) {
                throw new FormaterException("Not support");
            }
        }
        if (select.hierarchicalQueryClause != null) {
            if (select.hierarchicalQueryClause.startWithCondition != null) {
                this.buffer.append(" START WITH ");
                this.formatExpr(select.hierarchicalQueryClause.startWithCondition);
            }
            if (select.hierarchicalQueryClause.connectByCondition == null) {
                throw new FormaterException("connectByCondition is null");
            }
            this.buffer.append(" CONNECT BY ");
            this.formatExpr(select.hierarchicalQueryClause.connectByCondition);
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            if (select.hasWithRollUp) {
                this.buffer.append("ROLLUP(");
            }
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
            if (select.hasWithRollUp) {
                this.buffer.append(")");
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                if (orderByIterm.chineseOrderByMode != -1) {
                    this.buffer.append("NLSSORT(");
                    this.formatExpr(orderByIterm.expr);
                    this.buffer.append(",'NLS_SORT=");
                    if (orderByIterm.chineseOrderByMode == 2) {
                        this.buffer.append("SCHINESE_PINYIN_M')");
                    } else if (orderByIterm.chineseOrderByMode == 3) {
                        this.buffer.append("SCHINESE_STROKE_M')");
                    } else if (orderByIterm.chineseOrderByMode == 4) {
                        this.buffer.append("SCHINESE_RADICAL_M')");
                    }
                } else {
                    this.formatExpr(orderByIterm.expr);
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
            if (select.distinct != 1 && select.limit != null && select.groupBy.size() == 0) {
                DisCardUtil.discard();
            }
        }
        if (select.limit != null && (select.groupBy.size() != 0 || select.orderBy.size() != 0)) {
            this.buffer.append(")");
            this.buffer.insert(0, "SELECT * FROM ( ");
            this.buffer.append(") rownum_t WHERE ROWNUM <= ");
            this.buffer.append(select.limit.rowCount + select.limit.offset);
            if (select.limit.type == 1) {
                throw new FormaterException("Not support");
            }
        }
        if (select.limit != null && select.limit.offset != 0) {
            this.buffer.insert(0, "SELECT * FROM ( SELECT rownum_t2.*,ROWNUM as rownum_r FROM ( ");
            this.buffer.append(")  rownum_t2) rownum_t3 WHERE rownum_t3.rownum_r BETWEEN ").append(select.limit.offset + 1).append(" AND ").append(select.limit.rowCount + select.limit.offset);
        }
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        boolean binaryOpWithEscape;
        if (expr.operator == 21) {
            this.buffer.append("MOD(");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 0) {
            SqlBinaryOpExpr binaryOpExpr;
            SqlMethodInvokeExpr funcExpr;
            if (expr.left instanceof SqlCharExpr || expr.left instanceof SqlNCharExpr || expr.right instanceof SqlCharExpr || expr.right instanceof SqlNCharExpr) {
                this.formatExpr(expr.left);
                this.buffer.append(" || ");
                this.formatExpr(expr.right);
                return;
            }
            if (expr.left instanceof SqlMethodInvokeExpr) {
                funcExpr = (SqlMethodInvokeExpr)expr.left;
                if (funcExpr.methodName.equals("CHAR") || funcExpr.methodName.equals("LTRIM") || funcExpr.methodName.equals("RTRIM") || funcExpr.methodName.equals("LCASE") || funcExpr.methodName.equals("LOWER") || funcExpr.methodName.equals("UPPER") || funcExpr.methodName.equals("UCASE") || funcExpr.methodName.equals("SUBSTR")) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.right instanceof SqlMethodInvokeExpr) {
                funcExpr = (SqlMethodInvokeExpr)expr.right;
                if (funcExpr.methodName.equals("CHAR")) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                binaryOpExpr = (SqlBinaryOpExpr)expr.left;
                if (binaryOpExpr.left instanceof SqlCharExpr || binaryOpExpr.left instanceof SqlNCharExpr || binaryOpExpr.right instanceof SqlCharExpr || binaryOpExpr.right instanceof SqlNCharExpr) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.right instanceof SqlBinaryOpExpr) {
                binaryOpExpr = (SqlBinaryOpExpr)expr.right;
                if (binaryOpExpr.left instanceof SqlCharExpr || binaryOpExpr.left instanceof SqlNCharExpr || binaryOpExpr.right instanceof SqlCharExpr || binaryOpExpr.right instanceof SqlNCharExpr) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
        }
        if (expr.operator == 8) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
            SqlExpr sqlExpr = expr;
            while (sqlExpr != null || !list.isEmpty()) {
                while (sqlExpr != null) {
                    if (!(sqlExpr instanceof SqlBinaryOpExpr)) {
                        this.formatExpr(sqlExpr);
                        sqlExpr = null;
                        continue;
                    }
                    SqlBinaryOpExpr sqlBExpr = sqlExpr;
                    if (sqlBExpr.operator == 8) {
                        if (sqlBExpr.left instanceof SqlBinaryOpExpr) {
                            SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)sqlBExpr.left;
                            if (binaryOpLeft.operator == 8) {
                                list.add(sqlBExpr.right);
                                sqlExpr = binaryOpLeft;
                                continue;
                            }
                            this.formatExpr(binaryOpLeft);
                            this.buffer.append(" OR ");
                            sqlExpr = sqlBExpr.right;
                            continue;
                        }
                        this.formatExpr(sqlBExpr.left);
                        this.buffer.append(" OR ");
                        sqlExpr = sqlBExpr.right;
                        continue;
                    }
                    this.formatExpr(sqlExpr);
                    sqlExpr = null;
                }
                if (list.isEmpty()) continue;
                this.buffer.append(" OR ");
                sqlExpr = (SqlExpr)list.remove(list.size() - 1);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            if (expr.left instanceof SqlIdentifierExpr && this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) && expr.right instanceof SqlCharExpr) {
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formaterContext.setProperty("binaryOpWithEscape", "true");
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            this.formaterContext.setProperty("binaryOpWithEscape", "false");
            return;
        }
        if (expr.operator == 1) {
            String alias;
            this.formatExpr(expr.left);
            this.buffer.append(" AS ");
            if (expr.right instanceof SqlIdentifierExpr) {
                alias = ((SqlIdentifierExpr)expr.right).value.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlCharExpr) {
                alias = ((SqlCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlNCharExpr) {
                alias = ((SqlNCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        if (binaryOpWithEscape = Boolean.parseBoolean((String)this.formaterContext.getProperty("binaryOpWithEscape"))) {
            this.formatExpr(expr.left, false);
        } else {
            this.formatExpr(expr.left);
        }
        switch (expr.operator) {
            case 0: {
                this.buffer.append(" + ");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("not support");
            }
            case 4: {
                throw new FormaterException("not support");
            }
            case 5: {
                throw new FormaterException("not support");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 42: {
                this.buffer.append(" || ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("not support");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: 
            case 45: {
                this.buffer.append(" LIKE ");
                if (!(expr.left instanceof SqlIdentifierExpr) || !this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) || !(expr.right instanceof SqlCharExpr)) break;
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
                if (appendBrace) {
                    this.buffer.append(")");
                }
                return;
            }
            case 44: {
                this.buffer.append(" LIKE ");
                if (!(expr.left instanceof SqlIdentifierExpr) || !this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) || !(expr.right instanceof SqlCharExpr)) break;
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
                if (appendBrace) {
                    this.buffer.append(")");
                }
                return;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 40: 
            case 46: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("not support");
            }
        }
        this.formatExpr(expr.right);
        if (appendBrace) {
            this.buffer.append(")");
        }
    }
}

