/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kd.bos.ksql.datatype.DataType;
import kd.bos.ksql.dom.SqlBlockStmt;
import kd.bos.ksql.dom.SqlCaseItem;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableCheck;
import kd.bos.ksql.dom.SqlTableConstraint;
import kd.bos.ksql.dom.SqlTableForeignKey;
import kd.bos.ksql.dom.SqlTablePrimaryKey;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlTableUnique;
import kd.bos.ksql.dom.expr.SqlAggregateExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCaseExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlExistsExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlNullExpr;
import kd.bos.ksql.dom.stmt.SqlBreakStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlShowColumnsStmt;
import kd.bos.ksql.dom.stmt.SqlShowTablesStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.OracleSQLFormater;
import kd.bos.ksql.parser.Token;
import kd.bos.util.DisCardUtil;

public class HANASQLFormater
extends OracleSQLFormater {
    public HANASQLFormater(StringBuilder sb) {
        super(sb);
    }

    public HANASQLFormater() {
        super(null);
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        String sql = "SELECT TABLE_NAME FROM SYS.TABLES WHERE SCHEMA_NAME = CURRENT_SCHEMA ORDER BY TABLE_NAME";
        this.buffer.append(sql);
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        String sql = "SELECT COLUMN_NAME,DATA_TYPE_NAME AS DATA_TYPE,\"LENGTH\" AS DEFAULT_LENGTH ,\"LENGTH\" AS DATA_PRECISION, \"SCALE\" AS DATA_SCALE, IS_NULLABLE AS NULLABLE,TABLE_NAME FROM SYS.TABLE_COLUMNS ";
        if (stmt.tableName != null && stmt.tableName.length() != 0) {
            sql = sql + "WHERE SCHEMA_NAME = CURRENT_SCHEMA AND TABLE_NAME = '" + stmt.tableName + "' ";
        }
        sql = sql + " ORDER BY COLUMN_ID";
        this.buffer.append(sql);
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("CREATE");
        this.buffer.append(" TABLE");
        this.buffer.append(" ").append(stmt.name);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
        String ts = stmt.tableSpace;
        this.formatTableSpace(ts);
    }

    @Override
    protected void formatTableConstraint(SqlTableConstraint constraint) throws FormaterException {
        this.validConstraintName(constraint.name);
        if (constraint instanceof SqlTablePrimaryKey) {
            SqlTablePrimaryKey primaryKey = (SqlTablePrimaryKey)constraint;
            this.buffer.append(" PRIMARY KEY (");
            boolean flag = false;
            Iterator iterator = primaryKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            this.buffer.append(" UNIQUE (");
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableForeignKey) {
            String refColumnName;
            SqlTableForeignKey foreignKey = (SqlTableForeignKey)constraint;
            this.buffer.append(" FOREIGN KEY (");
            boolean flag = false;
            Iterator iterator = foreignKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
            this.buffer.append(" REFERENCES ");
            this.buffer.append(foreignKey.refTableName);
            this.buffer.append(" (");
            flag = false;
            iterator = foreignKey.refColumnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            if (!(constraint instanceof SqlTableCheck)) {
                throw new FormaterException("not support constraint:" + constraint);
            }
            SqlTableCheck check = (SqlTableCheck)constraint;
            this.buffer.append(" CHECK (");
            this.formatExpr(check.expr, false);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        this.buffer.append(column.name);
        this.buffer.append(" ");
        if (column.dataType.equalsIgnoreCase("INT") || column.dataType.equalsIgnoreCase("INTEGER")) {
            this.buffer.append("INTEGER");
        } else if (column.dataType.equalsIgnoreCase("BIGINT") || column.dataType.equalsIgnoreCase("LONG")) {
            this.buffer.append("BIGINT");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR") || column.dataType.equalsIgnoreCase("VARCHAR2")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR") || column.dataType.equalsIgnoreCase("NVARCHAR2")) {
            this.buffer.append("NVARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("DATETIME") || column.dataType.equalsIgnoreCase("DATE")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("NUMBER") || column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("NCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("SMALLINT")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY") || column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("VARBINARY (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("NCLOB");
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                this.buffer.append(" NULL");
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        } else {
            DisCardUtil.discard();
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        if (select.into != null) {
            this.buffer.append("CREATE TABLE ");
            this.buffer.append(select.into.new_table);
            this.buffer.append(" AS ");
        }
        this.buffer.append("SELECT ");
        this.formateQueryHints(select);
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else {
            if (select.distinct != 0) {
                throw new FormaterException("distinct option not support.");
            }
            DisCardUtil.discard();
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            SqlIdentifierExpr tableNameExpr;
            SqlSelectItem item;
            block96: {
                block94: {
                    block105: {
                        block104: {
                            block103: {
                                block102: {
                                    block101: {
                                        block100: {
                                            block99: {
                                                block98: {
                                                    block97: {
                                                        block95: {
                                                            if (flag) {
                                                                this.buffer.append(", ");
                                                            }
                                                            item = (SqlSelectItem)iterator.next();
                                                            if (!(item.expr instanceof SqlIdentifierExpr)) break block94;
                                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || item.alias != null) break block95;
                                                            item.alias = Token.KSQL_COL_NAME.value;
                                                            break block96;
                                                        }
                                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value) || item.alias != null) break block97;
                                                        item.alias = Token.TABNAME.value;
                                                        break block96;
                                                    }
                                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || item.alias != null) break block98;
                                                    item.alias = Token.KSQL_COL_TABNAME.value;
                                                    break block96;
                                                }
                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) || item.alias != null) break block99;
                                                item.alias = Token.KSQL_COL_LENGTH.value;
                                                break block96;
                                            }
                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value) || item.alias != null) break block100;
                                            item.alias = Token.KSQL_COL_TYPE.value;
                                            break block96;
                                        }
                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) || item.alias != null) break block101;
                                        item.alias = Token.KSQL_COL_NULLABLE.value;
                                        break block96;
                                    }
                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || item.alias != null) break block102;
                                    item.alias = Token.KSQL_COL_DEFAULT.value;
                                    break block96;
                                }
                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) || item.alias != null) break block103;
                                item.alias = Token.INDNAME.value;
                                break block96;
                            }
                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || item.alias != null) break block104;
                            item.alias = Token.KSQL_CONS_NAME.value;
                            break block96;
                        }
                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || item.alias != null) break block105;
                        item.alias = Token.KSQL_CONS_TABNAME.value;
                        break block96;
                    }
                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) || item.alias != null) break block96;
                    item.alias = Token.KSQL_CONS_TYPE.value;
                    break block96;
                }
                if (item.expr instanceof SqlAggregateExpr) {
                    List TparamList = ((SqlAggregateExpr)item.expr).paramList;
                    for (SqlExpr param : TparamList) {
                        if (!(param instanceof SqlIdentifierExpr)) continue;
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "COLUMN_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.INDNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "INDEX_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_TYPE";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                            ((SqlIdentifierExpr)param).value = "DATA_DEFAULT";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                            ((SqlIdentifierExpr)param).value = "NULLABLE";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
                            ((SqlIdentifierExpr)param).value = "DATA_LENGTH";
                            continue;
                        }
                        if (!((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) continue;
                        ((SqlIdentifierExpr)param).value = "DATA_TYPE";
                    }
                }
            }
            if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlIdentifierExpr) {
                    if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "COLUMN_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "INDEX_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CONSTRAINT_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CONSTRAINT_TYPE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_DEFAULT";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "NULLABLE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_LENGTH";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_TYPE";
                        this.formatExpr(tableNameExpr);
                    } else {
                        this.formatExpr(item.expr);
                    }
                } else {
                    this.formatExpr(item.expr);
                }
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase());
            } else if (item.expr instanceof SqlIdentifierExpr) {
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "COLUMN_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "INDEX_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_TYPE";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "DATA_DEFAULT";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "NULLABLE";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "DATA_LENGTH";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "DATA_TYPE";
                    this.formatExpr(tableNameExpr, false);
                } else {
                    this.formatExpr(item.expr, false);
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        } else {
            this.buffer.append(" FROM DUMMY");
        }
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
        }
        if (select.hierarchicalQueryClause != null) {
            if (select.hierarchicalQueryClause.startWithCondition != null) {
                this.buffer.append(" START WITH ");
                this.formatExpr(select.hierarchicalQueryClause.startWithCondition);
            }
            if (select.hierarchicalQueryClause.connectByCondition == null) {
                throw new FormaterException("connectByCondition is null");
            }
            this.buffer.append(" CONNECT BY ");
            this.formatExpr(select.hierarchicalQueryClause.connectByCondition);
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            if (select.hasWithRollUp) {
                this.buffer.append("ROLLUP(");
            }
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
            if (select.hasWithRollUp) {
                this.buffer.append(")");
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                if (orderByIterm.chineseOrderByMode != -1) {
                    this.buffer.append("NLSSORT(");
                    this.formatExpr(orderByIterm.expr);
                    this.buffer.append(",'NLS_SORT=");
                    if (orderByIterm.chineseOrderByMode == 2) {
                        this.buffer.append("SCHINESE_PINYIN_M')");
                    } else if (orderByIterm.chineseOrderByMode == 3) {
                        this.buffer.append("SCHINESE_STROKE_M')");
                    } else if (orderByIterm.chineseOrderByMode == 4) {
                        this.buffer.append("SCHINESE_RADICAL_M')");
                    }
                } else {
                    this.formatExpr(orderByIterm.expr);
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
        if (select.limit != null) {
            this.buffer.append(" LIMIT ").append(select.limit.rowCount).append(" OFFSET ");
            this.buffer.append(select.limit.offset);
        }
        if (select.tableSource instanceof SqlTableSource && ((SqlTableSource)select.tableSource).lockingHint != null && ((SqlTableSource)select.tableSource).lockingHint.length() > 0 && "holdlock".equalsIgnoreCase(((SqlTableSource)select.tableSource).lockingHint)) {
            this.buffer.append(" FOR UPDATE");
        }
    }

    @Override
    protected void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            if (simpleTableSource.name.startsWith("#")) {
                throw new FormaterException("not support talbeSource:" + simpleTableSource);
            }
            if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value)) {
                this.buffer.append("(SELECT TABLE_NAME FROM SYS.TABLES WHERE SCHEMA_NAME = CURRENT_SCHEMA)");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value)) {
                this.buffer.append("TABLE_COLUMNS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append("INDEX_COLUMNS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append("CONSTRAINTS");
            } else {
                this.buffer.append(simpleTableSource.name);
            }
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias.toUpperCase());
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT JOIN ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL JOIN ");
                    break;
                }
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else {
            if (!(tableSource instanceof SqlSubQueryTableSource)) {
                throw new FormaterException("not support tableSource:" + tableSource);
            }
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias.toUpperCase());
            }
        }
    }

    @Override
    protected void formatDateTimeExpr(SqlDateTimeExpr expr) throws FormaterException {
        switch (expr.timeType()) {
            case -19000: {
                this.buffer.append("TIMESTAMP'");
                this.buffer.append(expr.getYear() < 10 ? "0" : "");
                this.buffer.append(expr.getYear());
                this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
                this.buffer.append(expr.getMonth());
                this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
                this.buffer.append(expr.getDate());
                this.buffer.append(expr.getHour() < 10 ? " 0" : " ");
                this.buffer.append(expr.getHour());
                this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
                this.buffer.append(expr.getMinute());
                this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
                this.buffer.append(expr.getSecond());
                this.buffer.append("'");
                break;
            }
            case -19001: {
                this.buffer.append("DATE'");
                this.buffer.append(expr.getYear() < 10 ? "0" : "");
                this.buffer.append(expr.getYear());
                this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
                this.buffer.append(expr.getMonth());
                this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
                this.buffer.append(expr.getDate());
                this.buffer.append("'");
                break;
            }
            case -19002: {
                this.buffer.append("TIME'");
                this.buffer.append(expr.getHour() < 10 ? "0" : "");
                this.buffer.append(expr.getHour());
                this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
                this.buffer.append(expr.getMinute());
                this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
                this.buffer.append(expr.getSecond());
                this.buffer.append("'");
                break;
            }
            default: {
                throw new FormaterException("not support sql datetime expr:" + expr);
            }
        }
    }

    @Override
    protected void formatCaseExpr(SqlCaseExpr expr) throws FormaterException {
        this.buffer.append("CASE ");
        if (expr.valueExpr != null) {
            this.formatExpr(expr.valueExpr);
        }
        Iterator iterator = expr.itemList.iterator();
        while (iterator.hasNext()) {
            this.buffer.append(" WHEN ");
            SqlCaseItem caseItem = (SqlCaseItem)iterator.next();
            this.formatExpr(caseItem.conditionExpr);
            this.buffer.append(" THEN ");
            this.formatExpr(caseItem.valueExpr);
        }
        if (expr.elseExpr != null) {
            this.buffer.append(" ELSE ");
            this.formatExpr(expr.elseExpr);
        }
        this.buffer.append(" END");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if ((methodNameI = expr.methodName.toUpperCase(Locale.ENGLISH)).compareTo("ABS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ABS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ACOS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ACOS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ASIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ATAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATN2") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ATAN2(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CEILING") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CEIL(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("COS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("COS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("EXP") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("EXP(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("FLOOR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("FLOOR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MOD") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("MOD(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOG") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.equals("LOG10")) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LOG(10,");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("POWER") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("POWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ROUND") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            SqlExpr thirdExpr = (SqlExpr)expr.parameters.get(2);
            if (!(thirdExpr instanceof SqlIntExpr)) {
                throw new FormaterException("ERROR");
            }
            int val = Integer.parseInt(((SqlIntExpr)thirdExpr).text);
            if (val == 0) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            this.buffer.append("TRUNC(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SIGN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SIGN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SQRT") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SQRT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASCII") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("ASCII(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHARINDEX") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("INSTR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("INSTR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CONCAT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CONCAT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEFT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SUBSTR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 0, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LENGTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOWER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LOWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LOWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("REPLACE") == 0) {
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("REPLACE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RIGHT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SUBSTR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", CASE WHEN LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(") >= ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" THEN ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" * -1 ELSE LENGTH(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(") * -1 END, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SOUNDEX") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SOUNDEX(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SUBSTRING") == 0) {
            int startIndex;
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("SUBSTR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            if (expr.parameters.get(1) instanceof SqlIntExpr && (startIndex = ((SqlIntExpr)expr.parameters.get((int)1)).value) < 1) {
                if (startIndex == 0) {
                    expr.parameters.set(1, new SqlIntExpr(1));
                }
                if (startIndex < 0) {
                    throw new FormaterException("SUBSTRING parameter2 cannot not smaller then 1S.");
                }
            }
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LTRIM(RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("UCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("UPPER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("UPPER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("UPPER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TOCHAR") == 0 || methodNameI.compareTo("TO_CHAR") == 0) {
            this.format_TOCHAR_Invoke(expr);
            return;
        }
        if (methodNameI.compareTo("CONVERT") == 0) {
            if (!(expr.parameters.get(0) instanceof SqlIdentifierExpr)) throw new FormaterException("unexpect parameter:" + expr.parameters.get(0));
            SqlIdentifierExpr identExpr = (SqlIdentifierExpr)expr.parameters.get(0);
            if (identExpr.value.compareToIgnoreCase("DATETIME") == 0) {
                this.buffer.append("TO_TIMESTAMP(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'YYYY-MM-DD HH24:MI:SS')");
                return;
            }
            if (identExpr.value.compareToIgnoreCase("VARCHAR") != 0 && identExpr.value.compareToIgnoreCase("NVARCHAR") != 0 && identExpr.value.compareToIgnoreCase("CHAR") != 0) {
                if (identExpr.value.compareToIgnoreCase("NCHAR") != 0) throw new FormaterException("unexpect expression:" + identExpr.value);
            }
            this.buffer.append("TO_VARCHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CURDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CURRENT_DATE");
            return;
        }
        if (methodNameI.compareTo("CURTIME") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CURRENT_TIME");
            return;
        }
        if (methodNameI.compareTo("DATEADD") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ADD_SECONDS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(",");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DATETIMEADD") == 0) {
            if (expr.parameters.size() != 3) throw new FormaterException("unexpect parameters.");
            SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
            if (!(datepartExpr instanceof SqlIdentifierExpr)) throw new FormaterException("illegal datepart.");
            String datepart = ((SqlIdentifierExpr)datepartExpr).value;
            if (datepart == null) throw new FormaterException("illegal datepart.");
            if (datepart.length() == 0) {
                throw new FormaterException("illegal datepart.");
            }
            if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                this.buffer.append("(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + INTERVAL '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("' YEAR)");
                return;
            }
            if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                this.buffer.append("(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + INTERVAL '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("' MONTH)");
                return;
            }
            if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                this.buffer.append("(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + INTERVAL '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("' DAY)");
                return;
            }
            if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                this.buffer.append("(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + INTERVAL '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("' HOUR)");
                return;
            }
            if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                this.buffer.append("(");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(" + INTERVAL '");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append("' MINUTE)");
                return;
            }
            if (!"SECOND".equals(datepart) && !"SS".equals(datepart)) {
                if (!"S".equals(datepart)) throw new FormaterException("unexpect datepart:" + datepart);
            }
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(" + INTERVAL '");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append("' SECOND)");
            return;
        }
        if (methodNameI.compareTo("DATEDIFF") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexpect parameters.");
            this.buffer.append("SECONDS_BETWEEN(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(",");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'DAY')");
            return;
        }
        if (methodNameI.compareTo("DAYOFMONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'DD'))");
            return;
        }
        if (methodNameI.compareTo("DAYOFWEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'D'))");
            return;
        }
        if (methodNameI.compareTo("DAYOFYEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'DDD'))");
            return;
        }
        if (methodNameI.compareTo("GETDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("SYSDATE");
            return;
        }
        if (methodNameI.compareTo("HOUR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'HH24'))");
            return;
        }
        if (methodNameI.compareTo("MINUTE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'MI'))");
            return;
        }
        if (methodNameI.compareTo("MONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'MM'))");
            return;
        }
        if (methodNameI.compareTo("MONTHNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'MON')");
            return;
        }
        if (methodNameI.compareTo("NOW") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("CURRENT_TIMESTAMP");
            return;
        }
        if (methodNameI.compareTo("QUARTER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'Q'))");
            return;
        }
        if (methodNameI.compareTo("SECOND") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'SS'))");
            return;
        }
        if (methodNameI.compareTo("WEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'WW'))");
            return;
        }
        if (methodNameI.compareTo("YEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'YYYY'))");
            return;
        }
        if (methodNameI.compareTo("TO_DATE") == 0) {
            this.format_TO_DATE_Invoke(expr);
            return;
        }
        if (methodNameI.compareTo("MONTHS_BETWEEN") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("((TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'YYYY')) - TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", 'YYYY'))) * 12 + TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", 'MM')) - TO_NUMBER(TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", 'MM')))");
            return;
        }
        if (methodNameI.compareTo("DAYS_BETWEEN") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ROUND((TRUNC( CAST(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" AS DATE), 'DD') - TRUNC( CAST(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" AS DATE), 'DD')))");
            return;
        }
        if (methodNameI.compareTo("ADD_DAYS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_HOURS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append("/24)");
            return;
        }
        if (methodNameI.compareTo("ADD_MINUTES") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append("/1440)");
            return;
        }
        if (methodNameI.compareTo("ADD_SECONDS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append("/86400)");
            return;
        }
        if (methodNameI.compareTo("ADD_MONTHS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ADD_MONTHS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_YEARS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ADD_MONTHS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(" * 12)");
            return;
        }
        if (methodNameI.compareTo("DATENAME") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
            if (!(datepartExpr instanceof SqlIdentifierExpr)) return;
            String datepart = ((SqlIdentifierExpr)datepartExpr).value;
            if (datepart == null) throw new FormaterException("illegal datepart.");
            if (datepart.length() == 0) {
                throw new FormaterException("illegal datepart.");
            }
            if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'YYYY')");
                return;
            }
            if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'MM')");
                return;
            }
            if ("QUARTER".equals(datepart) || "QQ".equals(datepart) || "Q".equals(datepart)) {
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'Q')");
                return;
            }
            if ("DAYOFYEAR".equals(datepart) || "DY".equals(datepart) || "Y".equals(datepart)) {
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'DDD')");
                return;
            }
            if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'DD')");
                return;
            }
            if ("WEEK".equals(datepart) || "WK".equals(datepart) || "WW".equals(datepart)) {
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'IW')");
                return;
            }
            if ("WEEKDAY".equals(datepart) || "DW".equals(datepart)) {
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'DAY')");
                return;
            }
            if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'HH24')");
                return;
            }
            if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'MI')");
                return;
            }
            if ("SECOND".equals(datepart) || "SS".equals(datepart) || "S".equals(datepart)) {
                this.buffer.append("TO_CHAR(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(", 'SS')");
                return;
            }
            if (!"MILLISECOND".equals(datepart)) {
                if (!"MS".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
            }
            this.buffer.append("TO_CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", 'SSxFF3')");
            return;
        }
        if (methodNameI.compareTo("ISNULL") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("IFNULL(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NULLIF") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("NULLIF(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_DECIMAL") == 0 || methodNameI.compareTo("DECIMAL") == 0 || methodNameI.compareTo("DEC") == 0) {
            if (expr.parameters.size() != 1) {
                if (expr.parameters.size() != 3) throw new FormaterException("TO_DECIMAL's parameters num: " + expr.parameters.size());
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS NUMBER(");
                this.buffer.append(expr.parameters.get(1));
                this.buffer.append(", ");
                this.buffer.append(expr.parameters.get(2));
                this.buffer.append("))");
                return;
            }
            if (expr.parameters.get(0) instanceof SqlNullExpr) {
                this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                return;
            }
            this.buffer.append("CAST(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" AS NUMBER)");
            return;
        }
        if (methodNameI.compareTo("TO_NUMBER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TO_NUMBER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_BLOB") == 0 || methodNameI.compareTo("BLOB") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            if (!(expr.parameters.get(0) instanceof SqlNullExpr)) return;
            this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
            return;
        }
        if (methodNameI.compareTo("TO_INT") == 0 || methodNameI.compareTo("TO_INTEGER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            if (expr.parameters.get(0) instanceof SqlNullExpr) {
                this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                return;
            }
            this.buffer.append("FLOOR(TO_NUMBER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("TO_NVARCHAR") == 0 || methodNameI.compareTo("TONVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            return;
        }
        if (methodNameI.compareTo("TO_VARCHAR") == 0 || methodNameI.compareTo("TOVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            return;
        }
        if (methodNameI.compareTo("NEWID") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
            this.buffer.append("LOWER(NEWID())");
            return;
        }
        if (methodNameI.compareTo("NEWBOSID") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("NEWBOSID(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NATIVE_TYPE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR parameterNATIVE_TYPE");
            SqlCharExpr cexpr = (SqlCharExpr)expr.parameters.get(0);
            String type = cexpr.text;
            type = DataType.getDataType(2).nativeType(type);
            this.formatExpr(new SqlCharExpr(type));
            return;
        }
        if (methodNameI.compareTo("FIND_IN_SET") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append(expr.parameters.get(0));
            this.buffer.append(" =any(?) ");
            return;
        }
        if (methodNameI.compareTo("NOT_FIND_IN_SET") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.buffer.append(expr.parameters.get(0));
            this.buffer.append(" !=any(?) ");
            return;
        }
        this.formeatUnkownMethodInvokeExpr(expr);
    }

    @Override
    protected void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        this.buffer.append("break");
    }

    @Override
    protected void formatIfStmt(SqlBlockStmt block, SqlIfStmt stmt) throws FormaterException {
        if (stmt.condition instanceof SqlExistsExpr) {
            int i;
            int falseListCount;
            SqlExistsExpr existExpr = (SqlExistsExpr)stmt.condition;
            this.buffer.append("DO BEGIN\n");
            this.buffer.append("DECLARE CNT ").append(this.declareIntegerType()).append(";\n");
            this.formatIFExistSelectBase(existExpr.subQuery);
            this.buffer.append(";\n");
            if (existExpr.not) {
                this.buffer.append("IF CNT = 0 THEN\n");
            } else {
                this.buffer.append("IF CNT > 0 THEN\n");
            }
            for (falseListCount = 0; falseListCount < stmt.trueStmtList.size(); ++falseListCount) {
                this.buffer.append("EXECUTE IMMEDIATE '");
                this.context.put("isScriptContext", "1");
                i = this.buffer.length();
                SqlStmt itemStmt = (SqlStmt)stmt.trueStmtList.get(falseListCount);
                this.formatStmt(block, itemStmt);
                this.buffer = this.handleComma(this.buffer, i);
                this.buffer.append("';\n");
                this.context.put("isScriptContext", null);
            }
            falseListCount = stmt.falseStmtList.size();
            if (falseListCount > 0) {
                this.buffer.append("ELSE\n");
                for (i = 0; i < falseListCount; ++i) {
                    this.buffer.append("EXECUTE IMMEDIATE '");
                    this.context.put("isScriptContext", "1");
                    int pos = this.buffer.length();
                    SqlStmt itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                    this.formatStmt(block, itemStmt);
                    this.buffer = this.handleComma(this.buffer, pos);
                    this.buffer.append("';\n");
                    this.context.put("isScriptContext", null);
                }
            }
            this.buffer.append("END IF;\n");
            this.buffer.append("END;");
        } else {
            SqlStmt itemStmt;
            int i;
            this.buffer.append("if ");
            this.formatExpr(stmt.condition);
            this.buffer.append(" then\n");
            this.buffer.append("begin\n");
            for (i = 0; i < stmt.trueStmtList.size(); ++i) {
                itemStmt = (SqlStmt)stmt.trueStmtList.get(i);
                this.formatStmt(block, itemStmt);
                this.buffer.append(";\n");
            }
            this.buffer.append("end;\n");
            if (stmt.falseStmtList != null && stmt.falseStmtList.size() > 0) {
                this.buffer.append("else\n");
                this.buffer.append("begin\n");
                for (i = 0; i < stmt.falseStmtList.size(); ++i) {
                    itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                    this.formatStmt(block, itemStmt);
                    this.buffer.append(";\n");
                }
                this.buffer.append("end;\n");
            }
            this.buffer.append("end if");
        }
    }

    @Override
    protected String declareIntegerType() {
        return "INTEGER";
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        boolean binaryOpWithEscape;
        if (expr.operator == 21) {
            this.buffer.append("MOD(");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 0) {
            SqlBinaryOpExpr binaryOpExpr;
            SqlMethodInvokeExpr funcExpr;
            if (expr.left instanceof SqlCharExpr || expr.left instanceof SqlNCharExpr || expr.right instanceof SqlCharExpr || expr.right instanceof SqlNCharExpr) {
                this.formatExpr(expr.left);
                this.buffer.append(" || ");
                this.formatExpr(expr.right);
                return;
            }
            if (expr.left instanceof SqlMethodInvokeExpr) {
                funcExpr = (SqlMethodInvokeExpr)expr.left;
                if (funcExpr.methodName.equals("CHAR") || funcExpr.methodName.equals("LTRIM") || funcExpr.methodName.equals("RTRIM") || funcExpr.methodName.equals("LCASE") || funcExpr.methodName.equals("LOWER") || funcExpr.methodName.equals("UPPER") || funcExpr.methodName.equals("UCASE") || funcExpr.methodName.equals("SUBSTR")) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.right instanceof SqlMethodInvokeExpr) {
                funcExpr = (SqlMethodInvokeExpr)expr.right;
                if (funcExpr.methodName.equals("CHAR")) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                binaryOpExpr = (SqlBinaryOpExpr)expr.left;
                if (binaryOpExpr.left instanceof SqlCharExpr || binaryOpExpr.left instanceof SqlNCharExpr || binaryOpExpr.right instanceof SqlCharExpr || binaryOpExpr.right instanceof SqlNCharExpr) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.right instanceof SqlBinaryOpExpr) {
                binaryOpExpr = (SqlBinaryOpExpr)expr.right;
                if (binaryOpExpr.left instanceof SqlCharExpr || binaryOpExpr.left instanceof SqlNCharExpr || binaryOpExpr.right instanceof SqlCharExpr || binaryOpExpr.right instanceof SqlNCharExpr) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
        }
        if (expr.operator == 8) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
            SqlExpr sqlExpr = expr;
            while (sqlExpr != null || !list.isEmpty()) {
                while (sqlExpr != null) {
                    if (!(sqlExpr instanceof SqlBinaryOpExpr)) {
                        this.formatExpr(sqlExpr);
                        sqlExpr = null;
                        continue;
                    }
                    SqlBinaryOpExpr sqlBExpr = sqlExpr;
                    if (sqlBExpr.operator == 8) {
                        if (sqlBExpr.left instanceof SqlBinaryOpExpr) {
                            SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)sqlBExpr.left;
                            if (binaryOpLeft.operator == 8) {
                                list.add(sqlBExpr.right);
                                sqlExpr = binaryOpLeft;
                                continue;
                            }
                            this.formatExpr(binaryOpLeft);
                            this.buffer.append(" OR ");
                            sqlExpr = sqlBExpr.right;
                            continue;
                        }
                        this.formatExpr(sqlBExpr.left);
                        this.buffer.append(" OR ");
                        sqlExpr = sqlBExpr.right;
                        continue;
                    }
                    this.formatExpr(sqlExpr);
                    sqlExpr = null;
                }
                if (list.isEmpty()) continue;
                this.buffer.append(" OR ");
                sqlExpr = (SqlExpr)list.remove(list.size() - 1);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            if (expr.left instanceof SqlIdentifierExpr && this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) && expr.right instanceof SqlCharExpr) {
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formaterContext.setProperty("binaryOpWithEscape", "true");
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            this.formaterContext.setProperty("binaryOpWithEscape", "false");
            return;
        }
        if (expr.operator == 1) {
            String alias;
            this.formatExpr(expr.left);
            this.buffer.append(" AS ");
            if (expr.right instanceof SqlIdentifierExpr) {
                alias = ((SqlIdentifierExpr)expr.right).value.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlCharExpr) {
                alias = ((SqlCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlNCharExpr) {
                alias = ((SqlNCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        if (binaryOpWithEscape = Boolean.parseBoolean((String)this.formaterContext.getProperty("binaryOpWithEscape"))) {
            this.formatExpr(expr.left, false);
        } else {
            this.formatExpr(expr.left);
        }
        switch (expr.operator) {
            case 0: {
                this.buffer.append(" + ");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("not support");
            }
            case 4: {
                throw new FormaterException("not support");
            }
            case 5: {
                throw new FormaterException("not support");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 42: {
                this.buffer.append(" || ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("not support");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: 
            case 45: {
                this.buffer.append(" LIKE ");
                if (!(expr.left instanceof SqlIdentifierExpr) || !this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) || !(expr.right instanceof SqlCharExpr)) break;
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
                if (appendBrace) {
                    this.buffer.append(")");
                }
                return;
            }
            case 44: {
                this.buffer.append(" LIKE ");
                if (!(expr.left instanceof SqlIdentifierExpr) || !this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) || !(expr.right instanceof SqlCharExpr)) break;
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
                if (appendBrace) {
                    this.buffer.append(")");
                }
                return;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 40: 
            case 46: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("not support");
            }
        }
        this.formatExpr(expr.right);
        if (appendBrace) {
            this.buffer.append(")");
        }
    }
}

