/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.formater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.ksql.dom.AbstractUpdateItem;
import kd.bos.ksql.dom.KHint;
import kd.bos.ksql.dom.KHints;
import kd.bos.ksql.dom.SqlAlterTableAddDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableAddItem;
import kd.bos.ksql.dom.SqlAlterTableAlterColumnItem;
import kd.bos.ksql.dom.SqlAlterTableDropDefaultItem;
import kd.bos.ksql.dom.SqlAlterTableDropItem;
import kd.bos.ksql.dom.SqlBlockStmt;
import kd.bos.ksql.dom.SqlCaseItem;
import kd.bos.ksql.dom.SqlColumnDef;
import kd.bos.ksql.dom.SqlInsert;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableCheck;
import kd.bos.ksql.dom.SqlTableConstraint;
import kd.bos.ksql.dom.SqlTableForeignKey;
import kd.bos.ksql.dom.SqlTablePrimaryKey;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlTableUnique;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.dom.SqlUpdate;
import kd.bos.ksql.dom.SqlUpdateItem;
import kd.bos.ksql.dom.SubQueryUpdateItem;
import kd.bos.ksql.dom.expr.QueryExpr;
import kd.bos.ksql.dom.expr.SqlAggregateExpr;
import kd.bos.ksql.dom.expr.SqlAllColumnExpr;
import kd.bos.ksql.dom.expr.SqlAllExpr;
import kd.bos.ksql.dom.expr.SqlAnyExpr;
import kd.bos.ksql.dom.expr.SqlBetweenExpr;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCaseExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlDoubleExpr;
import kd.bos.ksql.dom.expr.SqlExistsExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlIdentityExpr;
import kd.bos.ksql.dom.expr.SqlInListExpr;
import kd.bos.ksql.dom.expr.SqlInSubQueryExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlLongExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlNotExpr;
import kd.bos.ksql.dom.expr.SqlNullExpr;
import kd.bos.ksql.dom.expr.SqlPriorIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlSomeExpr;
import kd.bos.ksql.dom.expr.SqlVarRefExpr;
import kd.bos.ksql.dom.expr.SqlXinListExpr;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlBreakStmt;
import kd.bos.ksql.dom.stmt.SqlCloseStmt;
import kd.bos.ksql.dom.stmt.SqlContinueStmt;
import kd.bos.ksql.dom.stmt.SqlCreateIndexStmt;
import kd.bos.ksql.dom.stmt.SqlCreateTableStmt;
import kd.bos.ksql.dom.stmt.SqlCursorLoopStmt;
import kd.bos.ksql.dom.stmt.SqlDeallocateStmt;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlDropTableStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlFetchStmt;
import kd.bos.ksql.dom.stmt.SqlGotoStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlLabelStmt;
import kd.bos.ksql.dom.stmt.SqlOpenStmt;
import kd.bos.ksql.dom.stmt.SqlSelectStmt;
import kd.bos.ksql.dom.stmt.SqlSetLocalVariantStmt;
import kd.bos.ksql.dom.stmt.SqlShowColumnsStmt;
import kd.bos.ksql.dom.stmt.SqlShowTablesStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.ksql.dom.stmt.SqlWhileStmt;
import kd.bos.ksql.exception.NotSupportedException;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.function.FunctionFactory;
import kd.bos.ksql.function.KSQLFunction;
import kd.bos.ksql.function.KSQLFunctionType;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.util.UUTN;
import kd.bos.util.DisCardUtil;

public class YasDBSQLFormater
extends SQLFormater {
    public YasDBSQLFormater() {
        super(null);
    }

    @Override
    protected void formatNChar(SqlNCharExpr expr) throws FormaterException {
        this.buffer.append("N");
        this.buffer.append("'");
        this.buffer.append(expr.text);
        this.buffer.append("'");
    }

    @Override
    protected void formatExecStmt(SqlExecStmt stmt) throws FormaterException {
        this.buffer.append("CALL ");
        this.buffer.append(stmt.processName);
        if (stmt.paramList.size() != 0) {
            this.buffer.append(" (");
            boolean flag = false;
            Iterator iter = stmt.paramList.iterator();
            while (iter.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iter.next();
                this.formatExpr(expr);
                flag = true;
            }
            this.buffer.append(')');
        }
    }

    @Override
    public String format(Collection stmtList) throws FormaterException {
        Iterator iterator = stmtList.iterator();
        this.context.clear();
        boolean appendOpenFlag = false;
        if (stmtList.size() > 1) {
            appendOpenFlag = true;
            this.buffer.append("BEGIN\n");
        }
        boolean flag = false;
        while (iterator.hasNext()) {
            if (flag) {
                if (this.buffer.charAt(this.buffer.length() - 1) != ';') {
                    this.buffer.append(";");
                }
                this.buffer.append("\n");
            }
            SqlStmt stmt = (SqlStmt)iterator.next();
            if (appendOpenFlag && stmt instanceof SqlSelectStmt) {
                this.buffer.append("OPEN ? FOR ");
            }
            this.formatStmt(stmt);
            flag = true;
        }
        if (stmtList.size() > 1) {
            if (this.buffer.charAt(this.buffer.length() - 1) != ';') {
                this.buffer.append(";\nEND;");
            } else {
                this.buffer.append("\nEND;");
            }
        }
        return this.buffer.toString();
    }

    @Override
    protected void formatHintForDelete(SqlDeleteStmt stmt) throws FormaterException {
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        String sql = "SELECT TABLE_NAME FROM USER_TABLES ORDER BY TABLE_NAME";
        this.buffer.append(sql);
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        String sql = "SELECT COLUMN_NAME, DATA_TYPE, DEFAULT_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, TABLE_NAME FROM USER_TAB_COLUMNS ";
        if (stmt.tableName != null && stmt.tableName.length() != 0) {
            sql = sql + "WHERE TABLE_NAME = '" + stmt.tableName + "' ";
        }
        sql = sql + " ORDER BY COLUMN_ID";
        this.buffer.append(sql);
    }

    protected void formatAlterTableStmtOld(SqlAlterTableStmt stmt) throws FormaterException {
        this.buffer.append("ALTER TABLE ");
        this.buffer.append(stmt.tableName);
        if (stmt.item instanceof SqlAlterTableAddItem) {
            SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)stmt.item;
            this.buffer.append(" ADD (");
            Iterator iterator = addColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlColumnDef columnDef = (SqlColumnDef)iterator.next();
                this.formatColumnDef(columnDef);
                flag = true;
            }
            iterator = addColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                this.formatTableConstraint(constraint);
            }
            this.buffer.append(")");
        } else if (stmt.item instanceof SqlAlterTableDropItem) {
            String columnDef;
            SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)stmt.item;
            this.buffer.append(" DROP ");
            Iterator iterator = dropColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("COLUMN ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(columnDef);
                flag = true;
            }
            iterator = dropColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("CONSTRAINT ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(columnDef);
                flag = true;
            }
        } else if (stmt.item instanceof SqlAlterTableAlterColumnItem) {
            SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)stmt.item;
            this.buffer.append(" MODIFY ");
            this.formatColumnDef(alterColumnDefItem.columnDef);
        } else if (stmt.item instanceof SqlAlterTableAddDefaultItem) {
            SqlAlterTableAddDefaultItem addDefaultItem = (SqlAlterTableAddDefaultItem)stmt.item;
            this.buffer.append(" MODIFY ");
            this.buffer.append(addDefaultItem.columnName);
            this.buffer.append(" DEFAULT ");
            this.formatExpr(addDefaultItem.value);
        } else if (stmt.item instanceof SqlAlterTableDropDefaultItem) {
            SqlAlterTableDropDefaultItem dropDefaultItem = (SqlAlterTableDropDefaultItem)stmt.item;
            this.buffer.append(" MODIFY ");
            this.buffer.append(dropDefaultItem.columnName);
            this.buffer.append(" DEFAULT ");
            this.buffer.append("null");
        } else {
            throw new FormaterException("not support statement:" + stmt);
        }
    }

    @Override
    protected void formatAlterTableStmt(SqlAlterTableStmt stmt) throws FormaterException {
        if (stmt.items == null || stmt.items.size() <= 1) {
            this.formatAlterTableStmtOld(stmt);
            return;
        }
        Iterator itemsIterator = stmt.items.iterator();
        boolean flag = false;
        StringBuilder sb = new StringBuilder();
        while (itemsIterator.hasNext()) {
            StringBuilder oldBuffer;
            Object columnDef;
            Iterator iterator;
            if (!flag) {
                this.buffer.append("call xalter_table('").append(stmt.tableName).append("', '(");
            } else {
                sb.append("), (");
            }
            Object obj = itemsIterator.next();
            if (obj instanceof SqlAlterTableAddItem) {
                StringBuilder oldBuffer2;
                SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)obj;
                sb.append(" ADD (");
                iterator = addColumnDefItem.columnDefItemList.iterator();
                boolean addItemFlag = false;
                while (iterator.hasNext()) {
                    if (addItemFlag) {
                        sb.append(", ");
                    }
                    columnDef = (SqlColumnDef)iterator.next();
                    oldBuffer2 = this.buffer;
                    this.buffer = new StringBuilder();
                    this.formatColumnDef((SqlColumnDef)columnDef);
                    sb.append((CharSequence)this.buffer);
                    this.buffer = oldBuffer2;
                    addItemFlag = true;
                }
                iterator = addColumnDefItem.constraintItemList.iterator();
                addItemFlag = false;
                while (iterator.hasNext()) {
                    SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                    oldBuffer2 = this.buffer;
                    this.buffer = new StringBuilder();
                    this.formatTableConstraint(constraint);
                    sb.append((CharSequence)this.buffer);
                    this.buffer = oldBuffer2;
                }
                sb.append(")");
            } else if (obj instanceof SqlAlterTableDropItem) {
                SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)obj;
                sb.append(" DROP ");
                iterator = dropColumnDefItem.columnDefItemList.iterator();
                boolean dropItemFlag = false;
                while (iterator.hasNext()) {
                    if (dropItemFlag) {
                        sb.append(", ");
                    } else {
                        sb.append("(");
                    }
                    columnDef = (String)iterator.next();
                    sb.append((String)columnDef);
                    dropItemFlag = true;
                }
                if (dropItemFlag) {
                    sb.append(")");
                }
                iterator = dropColumnDefItem.constraintItemList.iterator();
                dropItemFlag = false;
                while (iterator.hasNext()) {
                    if (dropItemFlag) {
                        sb.append(", ");
                    } else {
                        sb.append("CONSTRAINT ");
                    }
                    columnDef = (String)iterator.next();
                    sb.append((String)columnDef);
                    dropItemFlag = true;
                }
            } else if (obj instanceof SqlAlterTableAlterColumnItem) {
                SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)obj;
                sb.append(" MODIFY ");
                oldBuffer = this.buffer;
                this.buffer = new StringBuilder();
                this.formatColumnDef(alterColumnDefItem.columnDef);
                sb.append((CharSequence)this.buffer);
                this.buffer = oldBuffer;
            } else if (obj instanceof SqlAlterTableAddDefaultItem) {
                SqlAlterTableAddDefaultItem addDefaultItem = (SqlAlterTableAddDefaultItem)obj;
                sb.append(" MODIFY ");
                sb.append(addDefaultItem.columnName);
                sb.append(" DEFAULT ");
                oldBuffer = this.buffer;
                this.buffer = new StringBuilder();
                this.formatExpr(addDefaultItem.value);
                sb.append(this.buffer.toString().replaceAll("'", "''"));
                this.buffer = oldBuffer;
            } else if (obj instanceof SqlAlterTableDropDefaultItem) {
                SqlAlterTableDropDefaultItem dropDefaultItem = (SqlAlterTableDropDefaultItem)obj;
                sb.append(" MODIFY ");
                sb.append(dropDefaultItem.columnName);
                sb.append(" DEFAULT ");
                sb.append("null");
            } else {
                throw new FormaterException("not support statement:" + stmt);
            }
            flag = true;
        }
        if (flag) {
            this.buffer.append((CharSequence)sb);
            this.buffer.append(")'");
        }
        this.buffer.append(")");
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("CREATE");
        if (stmt.name.startsWith("GZT")) {
            this.buffer.append(" GLOBAL TEMPORARY");
        }
        this.buffer.append(" TABLE");
        this.buffer.append(" ").append(stmt.name);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
        if (UUTN.isTempTable(stmt.name)) {
            this.buffer.append(" NOLOGGING ");
        }
        String ts = null;
        if (UUTN.isTempTable(stmt.name) && this.options != null) {
            ts = this.options.getTempTableSpace();
        }
        if (ts == null) {
            ts = stmt.tableSpace;
        }
        this.formatTableSpace(ts);
    }

    protected void formatTableConstraint(SqlTableConstraint constraint) throws FormaterException {
        this.validConstraintName(constraint.name);
        if (constraint.name != null && constraint.name.length() != 0) {
            this.buffer.append("CONSTRAINT ");
            this.buffer.append(constraint.name);
        }
        if (constraint instanceof SqlTablePrimaryKey) {
            SqlTablePrimaryKey primaryKey = (SqlTablePrimaryKey)constraint;
            this.buffer.append(" PRIMARY KEY (");
            boolean flag = false;
            Iterator iterator = primaryKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            if (unique.clustered) {
                this.buffer.append(" UNIQUE CLUSTERED (");
            } else {
                this.buffer.append(" UNIQUE (");
            }
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableForeignKey) {
            SqlTableForeignKey foreignKey = (SqlTableForeignKey)constraint;
            this.buffer.append(" FOREIGN KEY (");
            boolean flag = false;
            Iterator iterator = foreignKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
            this.buffer.append(" REFERENCES ");
            this.buffer.append(foreignKey.refTableName);
            this.buffer.append(" (");
            flag = false;
            iterator = foreignKey.refColumnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableCheck) {
            SqlTableCheck check = (SqlTableCheck)constraint;
            this.buffer.append(" CHECK (");
            this.formatExpr(check.expr, false);
            this.buffer.append(")");
        } else {
            throw new FormaterException("not support constraint:" + constraint);
        }
    }

    protected final void formatTableConstraintList(Collection constraintList) throws FormaterException {
        for (SqlTableConstraint constraint : constraintList) {
            this.buffer.append(", ");
            this.formatTableConstraint(constraint);
        }
    }

    protected final void formatTableSpace(String tableSpace) {
        if (tableSpace != null && tableSpace.length() > 0) {
            this.buffer.append(" TABLESPACE ").append(tableSpace);
        }
    }

    @Override
    protected void formatCreateIndexStmt(SqlCreateIndexStmt stmt) throws FormaterException {
        if (stmt.isUnique) {
            this.buffer.append("CREATE UNIQUE INDEX ");
        }
        if (stmt.isCluster) {
            this.buffer.append("CREATE INDEX ");
        }
        if (!stmt.isCluster && !stmt.isUnique) {
            this.buffer.append("CREATE INDEX ");
        }
        this.buffer.append(stmt.indexName);
        this.buffer.append(" ON ");
        this.buffer.append(stmt.tableName);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.itemList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
            if (orderByIterm.chineseOrderByMode != -1) {
                this.buffer.append("NLSSORT(\"");
                this.formatExpr(orderByIterm.expr);
                this.buffer.append("\",'NLS_SORT=");
                if (orderByIterm.chineseOrderByMode == 2) {
                    this.buffer.append("SCHINESE_PINYIN_M')");
                } else if (orderByIterm.chineseOrderByMode == 3) {
                    this.buffer.append("SCHINESE_STROKE_M')");
                } else if (orderByIterm.chineseOrderByMode == 4) {
                    this.buffer.append("SCHINESE_RADICAL_M')");
                }
            } else {
                this.formatExpr(orderByIterm.expr);
            }
            if (orderByIterm.mode == 0) {
                DisCardUtil.discard();
            } else {
                this.buffer.append(" DESC");
            }
            flag = true;
        }
        this.buffer.append(")");
        if (UUTN.isTempTable(stmt.tableName) && this.options != null) {
            String ts = this.options.getTempTableSpace();
            if (ts != null && ts.length() > 0) {
                this.buffer.append(" TABLESPACE ").append(ts);
            }
            this.buffer.append(" NOLOGGING");
        }
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        this.buffer.append(column.name);
        this.buffer.append(" ");
        if (column.dataType.equalsIgnoreCase("CHAR") || column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR") || column.dataType.equalsIgnoreCase("VARCHAR2")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR") || column.dataType.equalsIgnoreCase("NVARCHAR2")) {
            this.buffer.append("NVARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NUMBER") || column.dataType.equalsIgnoreCase("DECIMAL")) {
            if (column.precision >= 0) {
                this.buffer.append("NUMBER (");
                this.buffer.append(column.precision);
                this.buffer.append(", ");
                this.buffer.append(column.scale);
                this.buffer.append(")");
            } else {
                this.buffer.append("NUMBER");
            }
        } else if (column.dataType.equalsIgnoreCase("INT") && !column.autoIncrement || column.dataType.equalsIgnoreCase("INTEGER") && !column.autoIncrement) {
            this.buffer.append("INT");
        } else if (column.dataType.equalsIgnoreCase("SMALLINT")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("BIGINT") || column.dataType.equalsIgnoreCase("LONG")) {
            this.buffer.append("BIGINT");
        } else if (column.dataType.equalsIgnoreCase("DATETIME") || column.dataType.equalsIgnoreCase("DATE")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("RAW") || column.dataType.equalsIgnoreCase("BINARY") || column.dataType.equalsIgnoreCase("LONG RAW") || column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("RAW (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("ROWID")) {
            this.buffer.append("ROWID");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BLOB");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("CLOB");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("NCLOB");
        } else if (column.dataType.equalsIgnoreCase("BFILE")) {
            this.buffer.append("BLOB");
        } else if (column.dataType.equalsIgnoreCase("BOOLEAN")) {
            this.buffer.append("BOOLEAN");
        } else if (column.dataType.equalsIgnoreCase("FLOAT")) {
            if (column.length != 0) {
                this.buffer.append("FLOAT (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else {
                this.buffer.append("FLOAT");
            }
        } else if (column.dataType.equalsIgnoreCase("DOUBLE")) {
            if (column.length != 0) {
                this.buffer.append("DOUBLE (");
                this.buffer.append(column.length);
                this.buffer.append(")");
            } else {
                this.buffer.append("DOUBLE");
            }
        } else if (column.dataType.equalsIgnoreCase("INT") && column.autoIncrement) {
            this.buffer.append("INT");
            this.context.put("Identity", column.name);
        } else {
            throw new FormaterException("not support datatype, column name is '" + column.name + "' datatype is '" + column.dataType + "'");
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                this.buffer.append(" NULL");
            }
        } else if (column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        } else {
            DisCardUtil.discard();
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        if (select.into != null) {
            this.buffer.append("CREATE TABLE ");
            this.buffer.append(select.into.new_table);
            this.buffer.append(" AS ");
        }
        if (select.limit != null && (select.orderBy.size() != 0 || select.groupBy.size() != 0)) {
            this.buffer.append("SELECT * FROM (SELECT ");
        } else {
            this.buffer.append("SELECT ");
        }
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct == 0) {
            DisCardUtil.discard();
        } else {
            throw new FormaterException("distinct option not support.");
        }
        Iterator iterator = select.selectList.iterator();
        boolean flag = false;
        while (iterator.hasNext()) {
            SqlIdentifierExpr tableNameExpr;
            SqlIdentifierExpr columnNameExpr;
            SqlSelectItem item;
            block103: {
                block101: {
                    block113: {
                        block112: {
                            block111: {
                                block110: {
                                    block109: {
                                        block108: {
                                            block107: {
                                                block106: {
                                                    block105: {
                                                        block104: {
                                                            block102: {
                                                                if (flag) {
                                                                    this.buffer.append(", ");
                                                                }
                                                                item = (SqlSelectItem)iterator.next();
                                                                if (!(item.expr instanceof SqlIdentifierExpr)) break block101;
                                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || item.alias != null) break block102;
                                                                item.alias = Token.KSQL_COL_NAME.value;
                                                                break block103;
                                                            }
                                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || item.alias != null) break block104;
                                                            item.alias = Token.KSQL_COL_DEFAULT.value;
                                                            break block103;
                                                        }
                                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value) || item.alias != null) break block105;
                                                        item.alias = Token.TABNAME.value;
                                                        break block103;
                                                    }
                                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value) || item.alias != null) break block106;
                                                    item.alias = Token.KSQL_CREATETIME.value;
                                                    break block103;
                                                }
                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || item.alias != null) break block107;
                                                item.alias = Token.KSQL_COL_TABNAME.value;
                                                break block103;
                                            }
                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) || item.alias != null) break block108;
                                            item.alias = Token.KSQL_COL_LENGTH.value;
                                            break block103;
                                        }
                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value) || item.alias != null) break block109;
                                        item.alias = Token.KSQL_COL_TYPE.value;
                                        break block103;
                                    }
                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) || item.alias != null) break block110;
                                    item.alias = Token.KSQL_COL_NULLABLE.value;
                                    break block103;
                                }
                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) || item.alias != null) break block111;
                                item.alias = Token.INDNAME.value;
                                break block103;
                            }
                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || item.alias != null) break block112;
                            item.alias = Token.KSQL_CONS_NAME.value;
                            break block103;
                        }
                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || item.alias != null) break block113;
                        item.alias = Token.KSQL_CONS_TABNAME.value;
                        break block103;
                    }
                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) || item.alias != null) break block103;
                    item.alias = Token.KSQL_CONS_TYPE.value;
                    break block103;
                }
                if (item.expr instanceof SqlAggregateExpr) {
                    List TparamList = ((SqlAggregateExpr)item.expr).paramList;
                    for (SqlExpr param : TparamList) {
                        if (!(param instanceof SqlIdentifierExpr)) continue;
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "COLUMN_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.INDNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "INDEX_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "TABLE_NAME";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                            ((SqlIdentifierExpr)param).value = "CONSTRAINT_TYPE";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                            ((SqlIdentifierExpr)param).value = "DATA_DEFAULT";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                            ((SqlIdentifierExpr)param).value = "NULLABLE";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
                            ((SqlIdentifierExpr)param).value = "DATA_LENGTH";
                            continue;
                        }
                        if (!((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) continue;
                        ((SqlIdentifierExpr)param).value = "DATA_TYPE";
                    }
                }
            }
            if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlIdentifierExpr) {
                    if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                        columnNameExpr = new SqlIdentifierExpr();
                        columnNameExpr.value = "COLUMN_NAME";
                        this.formatExpr(columnNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CREATE_TIME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "INDEX_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CONSTRAINT_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "TABLE_NAME";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "CONSTRAINT_TYPE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_DEFAULT";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "NULLABLE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_TYPE";
                        this.formatExpr(tableNameExpr);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "DATA_LENGTH";
                        this.formatExpr(tableNameExpr);
                    } else {
                        this.formatExpr(item.expr);
                    }
                } else {
                    this.formatExpr(item.expr);
                }
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase());
            } else if (item.expr instanceof SqlIdentifierExpr) {
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                    columnNameExpr = new SqlIdentifierExpr();
                    columnNameExpr.value = "COLUMN_NAME";
                    this.formatExpr(columnNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CREATE_TIME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "INDEX_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "TABLE_NAME";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "CONSTRAINT_TYPE";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "DATA_DEFAULT";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "NULLABLE";
                    this.formatExpr(tableNameExpr, false);
                } else {
                    this.formatExpr(item.expr, false);
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        } else {
            this.buffer.append(" FROM DUAL");
        }
        boolean whereFlag = false;
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
            whereFlag = true;
        }
        if (select.limit != null && select.orderBy.size() == 0 && select.groupBy.size() == 0) {
            if (!whereFlag) {
                this.buffer.append(" WHERE ROWNUM <= ");
            } else {
                this.buffer.append(" AND ROWNUM <= ");
            }
            this.buffer.append(select.limit.rowCount + select.limit.offset);
            if (select.limit.type == 1) {
                throw new FormaterException("Not support");
            }
            whereFlag = true;
        }
        if (select.hierarchicalQueryClause != null) {
            if (select.hierarchicalQueryClause.startWithCondition != null) {
                this.buffer.append(" START WITH ");
                this.formatExpr(select.hierarchicalQueryClause.startWithCondition);
            }
            if (select.hierarchicalQueryClause.connectByCondition == null) {
                throw new FormaterException("connectByCondition is null");
            }
            this.buffer.append(" CONNECT BY ");
            this.formatExpr(select.hierarchicalQueryClause.connectByCondition);
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            if (select.hasWithRollUp) {
                this.buffer.append("ROLLUP(");
            }
            flag = false;
            iterator = select.groupBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)iterator.next();
                this.formatExpr(expr);
                flag = true;
            }
            if (select.hasWithRollUp) {
                this.buffer.append(")");
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                if (orderByIterm.chineseOrderByMode != -1) {
                    this.buffer.append("NLSSORT(");
                    this.formatExpr(orderByIterm.expr);
                    this.buffer.append(",'NLS_SORT=");
                    if (orderByIterm.chineseOrderByMode == 2) {
                        this.buffer.append("SCHINESE_PINYIN_M')");
                    } else if (orderByIterm.chineseOrderByMode == 3) {
                        this.buffer.append("SCHINESE_STROKE_M')");
                    } else if (orderByIterm.chineseOrderByMode == 4) {
                        this.buffer.append("SCHINESE_RADICAL_M')");
                    }
                } else {
                    this.formatExpr(orderByIterm.expr);
                }
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
            if (select.distinct != 1 && select.limit != null && select.groupBy.size() == 0) {
                DisCardUtil.discard();
            }
        }
        if (select.limit != null && (select.groupBy.size() != 0 || select.orderBy.size() != 0) && select.limit != null) {
            this.buffer.append(") WHERE ROWNUM <= ");
            this.buffer.append(select.limit.rowCount + select.limit.offset);
            if (select.limit.type == 1) {
                throw new FormaterException("Not support");
            }
        }
        if (select.limit != null && select.limit.offset != 0) {
            this.buffer.insert(0, "SELECT * FROM ( SELECT rownum_t.*,ROWNUM as rownum_r FROM ( ");
            this.buffer.append(")  rownum_t) rownum_t2 WHERE rownum_t2.rownum_r BETWEEN ").append(select.limit.offset + 1).append(" AND ").append(select.limit.rowCount + select.limit.offset);
        }
    }

    @Override
    protected void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value)) {
                this.buffer.append("(SELECT OBJECT_NAME TABLE_NAME,CREATED CREATE_TIME FROM USER_OBJECTS WHERE OBJECT_TYPE='TABLE' OR OBJECT_TYPE='VIEW')");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value)) {
                this.buffer.append("USER_TAB_COLUMNS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.TABLECOLUMNDEFAULTVALUE.value)) {
                this.buffer.append("USER_TAB_COLUMNS");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append("USER_INDEXES");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append("USER_CONSTRAINTS");
            } else {
                this.buffer.append(simpleTableSource.name);
            }
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias.toUpperCase());
            }
            if (simpleTableSource.lockingHint != null && simpleTableSource.lockingHint.length() > 0 && "holdlock".equalsIgnoreCase(simpleTableSource.lockingHint)) {
                this.buffer.append(" FOR UPDATE");
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias.toUpperCase());
            }
        } else {
            throw new FormaterException("not support tableSource:" + tableSource);
        }
    }

    @Override
    protected void formatDateTimeExpr(SqlDateTimeExpr expr) throws FormaterException {
        this.buffer.append("TO_DATE('");
        if (expr.timeType() == -19000) {
            this.buffer.append(expr.getYear() < 10 ? "0" : "");
            this.buffer.append(expr.getYear());
            this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
            this.buffer.append(expr.getMonth());
            this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
            this.buffer.append(expr.getDate());
            this.buffer.append(expr.getHour() < 10 ? " 0" : " ");
            this.buffer.append(expr.getHour());
            this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
            this.buffer.append(expr.getMinute());
            this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
            this.buffer.append(expr.getSecond());
            this.buffer.append("', 'YYYY-MM-DD HH24:MI:SS')");
        } else if (expr.timeType() == -19001) {
            this.buffer.append(expr.getYear() < 10 ? "0" : "");
            this.buffer.append(expr.getYear());
            this.buffer.append(expr.getMonth() < 10 ? "-0" : "-");
            this.buffer.append(expr.getMonth());
            this.buffer.append(expr.getDate() < 10 ? "-0" : "-");
            this.buffer.append(expr.getDate());
            this.buffer.append("', 'YYYY-MM-DD')");
        } else if (expr.timeType() == -19002) {
            this.buffer.append(expr.getHour() < 10 ? "0" : "");
            this.buffer.append(expr.getHour());
            this.buffer.append(expr.getMinute() < 10 ? ":0" : ":");
            this.buffer.append(expr.getMinute());
            this.buffer.append(expr.getSecond() < 10 ? ":0" : ":");
            this.buffer.append(expr.getSecond());
            this.buffer.append("', 'HH24:MI:SS')");
        }
    }

    @Override
    protected void formatCaseExpr(SqlCaseExpr expr) throws FormaterException {
        if (expr.valueExpr != null) {
            this.buffer.append("DECODE(");
            this.formatExpr(expr.valueExpr);
            Iterator iterator = expr.itemList.iterator();
            while (iterator.hasNext()) {
                this.buffer.append(", ");
                SqlCaseItem caseItem = (SqlCaseItem)iterator.next();
                this.formatExpr(caseItem.conditionExpr);
                this.buffer.append(", ");
                this.formatExpr(caseItem.valueExpr);
            }
            if (expr.elseExpr != null) {
                this.buffer.append(", ");
                this.formatExpr(expr.elseExpr);
            }
            this.buffer.append(")");
        } else {
            this.buffer.append("CASE ");
            Iterator iterator = expr.itemList.iterator();
            while (iterator.hasNext()) {
                this.buffer.append(" WHEN ");
                SqlCaseItem caseItem = (SqlCaseItem)iterator.next();
                this.formatExpr(caseItem.conditionExpr);
                this.buffer.append(" THEN ");
                this.formatExpr(caseItem.valueExpr);
            }
            if (expr.elseExpr != null) {
                this.buffer.append(" ELSE ");
                this.formatExpr(expr.elseExpr);
            }
            this.buffer.append(" END");
        }
    }

    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        KSQLFunctionType ksqlFunctionType;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if ((ksqlFunctionType = KSQLFunctionType.functionNameOf(methodNameI = expr.methodName.toUpperCase(Locale.ENGLISH))) == null) {
            throw new FormaterException("not support this function [" + methodNameI + "]");
        }
        KSQLFunction function = FunctionFactory.build(20, ksqlFunctionType);
        function.execute(expr, this);
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        boolean binaryOpWithEscape;
        if (expr.operator == 21) {
            this.buffer.append("MOD(");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 0) {
            SqlBinaryOpExpr binaryOpExpr;
            SqlMethodInvokeExpr funcExpr;
            if (expr.left instanceof SqlCharExpr || expr.left instanceof SqlNCharExpr || expr.right instanceof SqlCharExpr || expr.right instanceof SqlNCharExpr) {
                this.formatExpr(expr.left);
                this.buffer.append(" || ");
                this.formatExpr(expr.right);
                return;
            }
            if (expr.left instanceof SqlMethodInvokeExpr) {
                funcExpr = (SqlMethodInvokeExpr)expr.left;
                if (funcExpr.methodName.equals("CHAR") || funcExpr.methodName.equals("LTRIM") || funcExpr.methodName.equals("RTRIM") || funcExpr.methodName.equals("LCASE") || funcExpr.methodName.equals("LOWER") || funcExpr.methodName.equals("UPPER") || funcExpr.methodName.equals("UCASE") || funcExpr.methodName.equals("SUBSTR")) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.right instanceof SqlMethodInvokeExpr) {
                funcExpr = (SqlMethodInvokeExpr)expr.right;
                if (funcExpr.methodName.equals("CHAR")) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.left instanceof SqlBinaryOpExpr) {
                binaryOpExpr = (SqlBinaryOpExpr)expr.left;
                if (binaryOpExpr.left instanceof SqlCharExpr || binaryOpExpr.left instanceof SqlNCharExpr || binaryOpExpr.right instanceof SqlCharExpr || binaryOpExpr.right instanceof SqlNCharExpr) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
            if (expr.right instanceof SqlBinaryOpExpr) {
                binaryOpExpr = (SqlBinaryOpExpr)expr.right;
                if (binaryOpExpr.left instanceof SqlCharExpr || binaryOpExpr.left instanceof SqlNCharExpr || binaryOpExpr.right instanceof SqlCharExpr || binaryOpExpr.right instanceof SqlNCharExpr) {
                    this.formatExpr(expr.left);
                    this.buffer.append(" || ");
                    this.formatExpr(expr.right);
                    return;
                }
            }
        }
        if (expr.operator == 8) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            ArrayList<SqlExpr> list = new ArrayList<SqlExpr>();
            SqlExpr sqlExpr = expr;
            while (sqlExpr != null || !list.isEmpty()) {
                while (sqlExpr != null) {
                    if (!(sqlExpr instanceof SqlBinaryOpExpr)) {
                        this.formatExpr(sqlExpr);
                        sqlExpr = null;
                        continue;
                    }
                    SqlBinaryOpExpr sqlBExpr = sqlExpr;
                    if (sqlBExpr.operator == 8) {
                        if (sqlBExpr.left instanceof SqlBinaryOpExpr) {
                            SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)sqlBExpr.left;
                            if (binaryOpLeft.operator == 8) {
                                list.add(sqlBExpr.right);
                                sqlExpr = binaryOpLeft;
                                continue;
                            }
                            this.formatExpr(binaryOpLeft);
                            this.buffer.append(" OR ");
                            sqlExpr = sqlBExpr.right;
                            continue;
                        }
                        this.formatExpr(sqlBExpr.left);
                        this.buffer.append(" OR ");
                        sqlExpr = sqlBExpr.right;
                        continue;
                    }
                    this.formatExpr(sqlExpr);
                    sqlExpr = null;
                }
                if (list.isEmpty()) continue;
                this.buffer.append(" OR ");
                sqlExpr = (SqlExpr)list.remove(list.size() - 1);
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 10) {
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            if (expr.left instanceof SqlIdentifierExpr && this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) && expr.right instanceof SqlCharExpr) {
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formaterContext.setProperty("binaryOpWithEscape", "true");
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            this.formaterContext.setProperty("binaryOpWithEscape", "false");
            return;
        }
        if (expr.operator == 1) {
            String alias;
            this.formatExpr(expr.left);
            this.buffer.append(" AS ");
            if (expr.right instanceof SqlIdentifierExpr) {
                alias = ((SqlIdentifierExpr)expr.right).value.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlCharExpr) {
                alias = ((SqlCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlNCharExpr) {
                alias = ((SqlNCharExpr)expr.right).text.toUpperCase();
                this.buffer.append(alias);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        if (binaryOpWithEscape = Boolean.parseBoolean((String)this.formaterContext.getProperty("binaryOpWithEscape"))) {
            this.formatExpr(expr.left, false);
        } else {
            this.formatExpr(expr.left);
        }
        switch (expr.operator) {
            case 0: {
                this.buffer.append(" + ");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("not support");
            }
            case 4: {
                throw new FormaterException("not support");
            }
            case 5: {
                throw new FormaterException("not support");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 42: {
                this.buffer.append(" || ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("not support");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: 
            case 45: {
                this.buffer.append(" LIKE ");
                if (!(expr.left instanceof SqlIdentifierExpr) || !this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) || !(expr.right instanceof SqlCharExpr)) break;
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
                if (appendBrace) {
                    this.buffer.append(")");
                }
                return;
            }
            case 44: {
                this.buffer.append(" LIKE ");
                if (!(expr.left instanceof SqlIdentifierExpr) || !this.isToUpperCaseExpr((SqlIdentifierExpr)expr.left) || !(expr.right instanceof SqlCharExpr)) break;
                this.context.put("toUpperCase", "toUpperCase");
                this.formatChar((SqlCharExpr)expr.right);
                this.context.put("toUpperCase", null);
                if (appendBrace) {
                    this.buffer.append(")");
                }
                return;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 40: 
            case 46: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("not support");
            }
        }
        this.formatExpr(expr.right);
        if (appendBrace) {
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatPriorIdentifierExpr(SqlPriorIdentifierExpr expr) throws FormaterException {
        this.buffer.append("PRIOR ");
        this.buffer.append(expr.value);
    }

    @Override
    protected void formatUpdateStmt(SqlUpdateStmt stmt) throws FormaterException {
        SqlUpdate update = stmt.update;
        if (update.updateList.get(0) instanceof SubQueryUpdateItem) {
            SubQueryUpdateItem queryItem = (SubQueryUpdateItem)update.updateList.get(0);
            if (queryItem.subQuery != null && !queryItem.subQuery.getHints().isEmpty()) {
                this.formatUpdateStmt_New(stmt);
                return;
            }
        }
        this.formatUpdateStmt_old(stmt);
    }

    private void formatUpdateStmt_New(SqlUpdateStmt stmt) throws FormaterException {
        SqlUpdate update = stmt.update;
        if (update.updateList.get(0) instanceof SubQueryUpdateItem) {
            String tPrefix = "KSQL_T_";
            String vPrefix = "KSQL_V_";
            this.buffer.append("UPDATE ");
            this.buffer.append("(");
            SubQueryUpdateItem queryItem = (SubQueryUpdateItem)update.updateList.get(0);
            this.formatSelectForUpdate(queryItem.subQuery, update, queryItem, tPrefix, vPrefix);
            this.formatSelectBase(queryItem.subQuery);
            this.buffer.append(") SET ");
            List cols = queryItem.columnList;
            for (int i = 0; i < cols.size(); ++i) {
                this.buffer.append(i > 0 ? ", " : "");
                this.buffer.append(vPrefix).append(i).append("=").append(tPrefix).append(i);
            }
        } else {
            this.buffer.append("UPDATE ");
            this.buffer.append(update.updateTable.name);
            if (update.updateTable.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(update.updateTable.alias);
            }
            this.buffer.append(" SET ");
            boolean flag = false;
            Iterator iterator = update.updateList.iterator();
            while (iterator.hasNext()) {
                this.buffer.append(flag ? ", " : "");
                SqlUpdateItem item = (SqlUpdateItem)iterator.next();
                this.buffer.append(item.name);
                this.buffer.append(" = ");
                this.formatExpr(item.expr);
                flag = true;
            }
            if (update.tableSource != null) {
                throw new FormaterException("not support");
            }
            if (update.condition != null) {
                this.buffer.append(" WHERE ");
                this.formatExpr(update.condition);
            }
        }
    }

    private void formatSelectForUpdate(SqlSelectBase select, SqlUpdate update, SubQueryUpdateItem queryItem, String tPrefix, String vPrefix) {
        if (select instanceof SqlSelect) {
            SqlSelect sSelect = (SqlSelect)select;
            boolean tableSourceExist = this.tableSourceExist(select, update.updateTable.name, update.updateTable.alias);
            if (!tableSourceExist) {
                if (sSelect.tableSource == null) {
                    sSelect.tableSource = update.updateTable;
                } else if (update.updateTable != null) {
                    SqlJoinedTableSource sjts = new SqlJoinedTableSource();
                    sjts.joinType = 4;
                    sjts.left = update.updateTable;
                    sjts.right = sSelect.tableSource;
                    sSelect.tableSource = sjts;
                }
            }
            if (update.condition != null) {
                if (sSelect.condition == null) {
                    sSelect.condition = update.condition;
                } else {
                    SqlBinaryOpExpr opExpr = new SqlBinaryOpExpr();
                    opExpr.operator = 7;
                    opExpr.left = sSelect.condition;
                    opExpr.right = update.condition;
                    sSelect.condition = opExpr;
                }
            }
            sSelect.getHints().add(0, new KHint("BYPASS_UJVC"));
            for (int i = 0; i < sSelect.selectList.size(); ++i) {
                SqlSelectItem item = (SqlSelectItem)sSelect.selectList.get(i);
                item.alias = tPrefix + i;
            }
            String name = update.updateTable.alias;
            if (name == null || name.trim().length() == 0) {
                name = update.updateTable.name;
            }
            for (int i = 0; i < queryItem.columnList.size(); ++i) {
                SqlSelectItem item = new SqlSelectItem();
                item.alias = vPrefix + i;
                SqlBinaryOpExpr expr = new SqlBinaryOpExpr();
                expr.operator = 20;
                expr.left = new SqlIdentifierExpr(name);
                expr.right = new SqlIdentifierExpr((String)queryItem.columnList.get(i));
                item.expr = expr;
                sSelect.selectList.add(item);
            }
        } else if (select instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)select;
            this.formatSelectForUpdate(unionSelect.left, update, queryItem, tPrefix, vPrefix);
            this.formatSelectForUpdate(unionSelect.right, update, queryItem, tPrefix, vPrefix);
        }
    }

    private boolean tableSourceExist(SqlSelectBase select, String name, String alais) {
        if (select instanceof SqlSelect) {
            SqlSelect sSelect = (SqlSelect)select;
            return this.tableSourceExist(sSelect.tableSource, name, alais);
        }
        if (select instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)select;
            if (this.tableSourceExist(unionSelect.left, name, alais)) {
                return true;
            }
            return this.tableSourceExist(unionSelect.right, name, alais);
        }
        return false;
    }

    private boolean tableSourceExist(SqlTableSourceBase selectBase, String name, String alais) {
        if (selectBase instanceof SqlTableSource) {
            SqlTableSource ts = (SqlTableSource)selectBase;
            if (alais == null) {
                return ts.alias == null && name.equalsIgnoreCase(ts.name);
            }
            return alais.equals(ts.alias) && name.equalsIgnoreCase(ts.name);
        }
        if (selectBase instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource ts = (SqlJoinedTableSource)selectBase;
            if (this.tableSourceExist(ts.left, name, alais)) {
                return true;
            }
            return this.tableSourceExist(ts.right, name, alais);
        }
        return false;
    }

    private void formatUpdateStmt_old(SqlUpdateStmt stmt) throws FormaterException {
        SqlUpdate update = stmt.update;
        this.buffer.append("UPDATE ");
        this.buffer.append(update.updateTable.name);
        if (update.updateTable.alias != null) {
            this.buffer.append(" ");
            this.buffer.append(update.updateTable.alias);
        }
        this.buffer.append(" SET ");
        boolean flag = false;
        for (AbstractUpdateItem abstract_item : update.updateList) {
            if (flag) {
                this.buffer.append(", ");
            }
            this.formateUpdateItem(abstract_item);
            flag = true;
        }
        if (update.tableSource != null) {
            throw new FormaterException("not support");
        }
        boolean whereFlag = false;
        if (update.condition != null) {
            whereFlag = true;
            this.buffer.append(" WHERE ");
            this.formatExpr(update.condition);
        }
        if (!KHints.containHint(update.getHints(), "NOT_GEN_EXISTS")) {
            for (AbstractUpdateItem abstract_item : update.updateList) {
                if (!(abstract_item instanceof SubQueryUpdateItem)) continue;
                if (whereFlag) {
                    this.buffer.append(" AND ");
                } else {
                    this.buffer.append(" WHERE ");
                    whereFlag = true;
                }
                this.buffer.append("EXISTS (");
                this.formatSelectBase(((SubQueryUpdateItem)abstract_item).subQuery);
                this.buffer.append(")");
            }
        }
    }

    @Override
    protected void formatBlockStmt(SqlBlockStmt stmt) throws FormaterException {
        int i;
        int size;
        if (stmt.declItemList != null && stmt.declItemList.size() > 0) {
            this.buffer.append("declare\n");
            size = stmt.declItemList.size();
            for (i = 0; i < size; ++i) {
                String name;
                SqlBlockStmt.DeclItem item = (SqlBlockStmt.DeclItem)stmt.declItemList.get(i);
                if (item instanceof SqlBlockStmt.DeclVarItem) {
                    SqlBlockStmt.DeclVarItem varItem = (SqlBlockStmt.DeclVarItem)item;
                    name = varItem.name;
                    if (name != null && name.length() > 0 && name.charAt(0) == '@') {
                        name = name.substring(1);
                        this.buffer.append(name);
                    } else {
                        this.buffer.append(name);
                    }
                    this.buffer.append(" ");
                    if (varItem.dataType.equalsIgnoreCase("CHAR") || varItem.dataType.equalsIgnoreCase("NCHAR")) {
                        this.buffer.append("CHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("VARCHAR") || varItem.dataType.equalsIgnoreCase("VARCHAR2")) {
                        this.buffer.append("VARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NVARCHAR") || varItem.dataType.equalsIgnoreCase("NVARCHAR2")) {
                        this.buffer.append("NVARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NUMBER") || varItem.dataType.equalsIgnoreCase("DECIMAL")) {
                        if (varItem.precision >= 0) {
                            this.buffer.append("NUMBER (");
                            this.buffer.append(varItem.precision);
                            this.buffer.append(", ");
                            this.buffer.append(varItem.scale);
                            this.buffer.append(")");
                        } else {
                            this.buffer.append("NUMBER");
                        }
                    } else if (varItem.dataType.equalsIgnoreCase("INT") || varItem.dataType.equalsIgnoreCase("INTEGER")) {
                        this.buffer.append("INT");
                    } else if (varItem.dataType.equalsIgnoreCase("SMALLINT")) {
                        this.buffer.append("SMALLINT");
                    } else if (varItem.dataType.equalsIgnoreCase("BIGINT") || varItem.dataType.equalsIgnoreCase("LONG")) {
                        this.buffer.append("BIGINT");
                    } else if (varItem.dataType.equalsIgnoreCase("DATETIME") || varItem.dataType.equalsIgnoreCase("DATE")) {
                        this.buffer.append("TIMESTAMP");
                    } else if (varItem.dataType.equalsIgnoreCase("RAW") || varItem.dataType.equalsIgnoreCase("BINARY") || varItem.dataType.equalsIgnoreCase("LONG RAW") || varItem.dataType.equalsIgnoreCase("VARBINARY")) {
                        this.buffer.append("RAW (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("ROWID")) {
                        this.buffer.append("ROWID");
                    } else if (varItem.dataType.equalsIgnoreCase("BLOB")) {
                        this.buffer.append("BLOB");
                    } else if (varItem.dataType.equalsIgnoreCase("CLOB")) {
                        this.buffer.append("CLOB");
                    } else if (varItem.dataType.equalsIgnoreCase("NCLOB")) {
                        this.buffer.append("NCLOB");
                    } else if (varItem.dataType.equalsIgnoreCase("BFILE")) {
                        this.buffer.append("BLOB");
                    } else if (varItem.dataType.equalsIgnoreCase("BOOLEAN")) {
                        this.buffer.append("BOOLEAN");
                    } else if (varItem.dataType.equalsIgnoreCase("FLOAT")) {
                        if (varItem.length != 0) {
                            this.buffer.append("FLOAT (");
                            this.buffer.append(varItem.length);
                            this.buffer.append(")");
                        } else {
                            this.buffer.append("FLOAT");
                        }
                    } else if (varItem.dataType.equalsIgnoreCase("DOUBLE")) {
                        if (varItem.length != 0) {
                            this.buffer.append("DOUBLE (");
                            this.buffer.append(varItem.length);
                            this.buffer.append(")");
                        } else {
                            this.buffer.append("DOUBLE");
                        }
                    } else {
                        throw new FormaterException("not support datatype, column name is '" + varItem.name + "' datatype is '" + varItem.dataType + "'");
                    }
                    if (varItem.defaultValueExpr != null) {
                        this.buffer.append(" := ");
                        this.formatExpr(varItem.defaultValueExpr);
                    }
                    this.buffer.append(";\n");
                    continue;
                }
                if (item instanceof SqlBlockStmt.DeclCurItem) {
                    SqlBlockStmt.DeclCurItem curItem = (SqlBlockStmt.DeclCurItem)item;
                    this.buffer.append("CURSOR ");
                    name = curItem.name;
                    if (name != null && name.length() > 0 && name.charAt(0) == '@') {
                        name = name.substring(1);
                        this.buffer.append(name);
                    } else {
                        this.buffer.append(name);
                    }
                    this.buffer.append(" IS ");
                    this.formatSelectBase(curItem.select);
                    this.buffer.append(";\n");
                    continue;
                }
                throw new FormaterException("not support statement:" + item);
            }
        }
        this.buffer.append("begin\n");
        size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(stmt, itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("end;");
    }

    @Override
    protected void formatSetLocalVariantStmt(SqlSetLocalVariantStmt stmt) throws FormaterException {
        this.formatExpr(stmt.variant);
        this.buffer.append(" := ");
        this.formatExpr(stmt.value);
    }

    @Override
    protected void formatVarRef(SqlVarRefExpr expr) throws FormaterException {
        String name = expr.text;
        if (name != null && name.length() > 0 && name.charAt(0) == '@') {
            name = name.substring(1);
            this.buffer.append(name);
        } else {
            this.buffer.append(expr.text);
        }
    }

    @Override
    protected void formatIfStmt(SqlIfStmt stmt) throws FormaterException {
        this.formatIfStmt(null, stmt);
    }

    protected String declareIntegerType() {
        return "PLS_INTEGER";
    }

    protected void formatIfStmt(SqlBlockStmt block, SqlIfStmt stmt) throws FormaterException {
        if (stmt.condition instanceof SqlExistsExpr) {
            SqlExistsExpr existExpr = (SqlExistsExpr)stmt.condition;
            this.buffer.append("DECLARE CNT ").append(this.declareIntegerType()).append(";\n");
            this.buffer.append("BEGIN\n");
            this.formatIFExistSelectBase(existExpr.subQuery);
            this.buffer.append(";\n");
            if (existExpr.not) {
                this.buffer.append("IF CNT = 0 THEN\n");
            } else {
                this.buffer.append("IF CNT > 0 THEN\n");
            }
            for (int i = 0; i < stmt.trueStmtList.size(); ++i) {
                this.buffer.append("EXECUTE IMMEDIATE '");
                this.context.put("isScriptContext", "1");
                int pos = this.buffer.length();
                SqlStmt itemStmt = (SqlStmt)stmt.trueStmtList.get(i);
                this.formatStmt(block, itemStmt);
                this.buffer = this.handleComma(this.buffer, pos);
                this.buffer.append("';\n");
                this.context.put("isScriptContext", null);
            }
            int falseListCount = stmt.falseStmtList.size();
            if (falseListCount > 0) {
                this.buffer.append("ELSE\n");
                for (int i = 0; i < falseListCount; ++i) {
                    this.buffer.append("EXECUTE IMMEDIATE '");
                    this.context.put("isScriptContext", "1");
                    int pos = this.buffer.length();
                    SqlStmt itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                    this.formatStmt(block, itemStmt);
                    this.buffer = this.handleComma(this.buffer, pos);
                    this.buffer.append("';\n");
                    this.context.put("isScriptContext", null);
                }
            }
            this.buffer.append("END IF;\n");
            this.buffer.append("END;");
        } else {
            SqlStmt itemStmt;
            int i;
            this.buffer.append("if ");
            this.formatExpr(stmt.condition);
            this.buffer.append(" then\n");
            this.buffer.append("begin\n");
            for (i = 0; i < stmt.trueStmtList.size(); ++i) {
                itemStmt = (SqlStmt)stmt.trueStmtList.get(i);
                this.formatStmt(block, itemStmt);
                this.buffer.append(";\n");
            }
            this.buffer.append("end;\n");
            if (stmt.falseStmtList != null && stmt.falseStmtList.size() > 0) {
                this.buffer.append("else\n");
                this.buffer.append("begin\n");
                for (i = 0; i < stmt.falseStmtList.size(); ++i) {
                    itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                    this.formatStmt(block, itemStmt);
                    this.buffer.append(";\n");
                }
                this.buffer.append("end;\n");
            }
            this.buffer.append("end if");
        }
    }

    @Override
    protected void formatWhileStmt(SqlWhileStmt stmt) throws FormaterException {
        this.formatWhileStmt(null, stmt);
    }

    protected void formatWhileStmt(SqlBlockStmt block, SqlWhileStmt stmt) throws FormaterException {
        Integer loopCount = null;
        Map attrs = block.extendedAttributes();
        loopCount = (Integer)attrs.get("LOOP_COUNT");
        loopCount = loopCount == null ? Integer.valueOf(0) : Integer.valueOf(loopCount + 1);
        attrs.put("LOOP_COUNT", loopCount);
        attrs.put("CURRENT_LOOP_COUNT", loopCount);
        String loopName = "ksql_loop_" + loopCount;
        this.buffer.append("while ");
        this.formatExpr(stmt.condition);
        this.buffer.append(" loop\n");
        this.buffer.append("begin\n");
        for (int i = 0; i < stmt.stmtList.size(); ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(block, itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("end;\n");
        this.buffer.append("<<");
        this.buffer.append(loopName);
        this.buffer.append("_end>>\nNULL;\n");
        this.buffer.append("end loop");
        Map attrs2 = block.extendedAttributes();
        loopCount = (Integer)attrs2.get("LOOP_COUNT");
        if (loopCount != null) {
            loopCount = loopCount - 1;
            attrs2.put("CURRENT_LOOP_COUNT", loopCount);
        }
    }

    @Override
    protected void formatDeallocateStmt(SqlDeallocateStmt stmt) throws FormaterException {
        this.buffer.append("-- skip deallocate");
    }

    @Override
    protected void formatCloseStmt(SqlCloseStmt stmt) throws FormaterException {
        this.buffer.append("CLOSE ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatOpenStmt(SqlOpenStmt stmt) throws FormaterException {
        this.buffer.append("OPEN ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatCursorLoopStmt(SqlCursorLoopStmt stmt) throws FormaterException {
        this.formatCursorLoopStmt(null, stmt);
    }

    protected void formatCursorLoopStmt(SqlBlockStmt block, SqlCursorLoopStmt stmt) throws FormaterException {
        int i;
        Integer loopCount = null;
        Map attrs = block.extendedAttributes();
        loopCount = (Integer)attrs.get("LOOP_COUNT");
        loopCount = loopCount == null ? Integer.valueOf(0) : Integer.valueOf(loopCount + 1);
        attrs.put("LOOP_COUNT", loopCount);
        attrs.put("CURRENT_LOOP_COUNT", loopCount);
        String curName = stmt.curName;
        if (curName != null && curName.length() > 0 && curName.charAt(0) == '@') {
            curName = curName.substring(1);
        }
        this.buffer.append("open ");
        this.buffer.append(curName);
        this.buffer.append(";\n");
        this.buffer.append("loop\n");
        this.buffer.append("fetch ");
        this.buffer.append(curName);
        this.buffer.append(" into ");
        int size = stmt.intoList.size();
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            SqlExpr expr = (SqlExpr)stmt.intoList.get(i);
            this.formatExpr(expr);
        }
        this.buffer.append(";\n");
        size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(block, itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("exit when ");
        this.buffer.append(curName);
        this.buffer.append("%notfound;\n");
        this.buffer.append("end loop;\n");
        this.buffer.append("close ");
        this.buffer.append(curName);
        Map attrs2 = block.extendedAttributes();
        loopCount = (Integer)attrs2.get("LOOP_COUNT");
        if (loopCount != null) {
            loopCount = loopCount - 1;
            attrs2.put("CURRENT_LOOP_COUNT", loopCount);
        }
    }

    @Override
    protected void formatFetchStmt(SqlFetchStmt stmt) throws FormaterException {
        this.buffer.append("fetch ");
        String curName = stmt.curName;
        if (curName != null && curName.length() > 0 && curName.charAt(0) == '@') {
            curName = curName.substring(1);
        }
        this.buffer.append(curName);
        this.buffer.append(" into ");
        int size = stmt.intoList.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            SqlExpr expr = (SqlExpr)stmt.intoList.get(i);
            this.formatExpr(expr);
        }
    }

    @Override
    protected void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        this.buffer.append("exit");
    }

    @Override
    protected void formatContinueStmt(SqlContinueStmt stmt) throws FormaterException {
        throw new FormaterException("not support format continue statement");
    }

    protected void formatContinueStmt(SqlBlockStmt block, SqlContinueStmt stmt) throws FormaterException {
        Integer loopCount = null;
        if (block != null) {
            Map attrs = block.extendedAttributes();
            loopCount = (Integer)attrs.get("CURRENT_LOOP_COUNT");
        }
        if (loopCount == null) {
            throw new FormaterException("Fatal Error.");
        }
        String loopName = "ksql_loop_" + loopCount;
        this.buffer.append("goto ");
        this.buffer.append(loopName);
        this.buffer.append("_end");
    }

    protected void formatStmt(SqlBlockStmt block, SqlStmt stmt) throws FormaterException {
        if (stmt instanceof SqlIfStmt) {
            this.formatIfStmt(block, (SqlIfStmt)stmt);
        } else if (stmt instanceof SqlWhileStmt) {
            this.formatWhileStmt(block, (SqlWhileStmt)stmt);
        } else if (stmt instanceof SqlCursorLoopStmt) {
            this.formatCursorLoopStmt(block, (SqlCursorLoopStmt)stmt);
        } else if (stmt instanceof SqlContinueStmt) {
            this.formatContinueStmt(block, (SqlContinueStmt)stmt);
        } else {
            this.formatStmt(stmt);
        }
    }

    @Override
    protected void formatGotoStmt(SqlGotoStmt stmt) throws FormaterException {
        throw new FormaterException("not support format goto statement");
    }

    @Override
    protected void formatLabelStmt(SqlLabelStmt stmt) throws FormaterException {
        throw new FormaterException("not support format label statement");
    }

    @Override
    protected void formatInListExpr(SqlInListExpr expr) throws FormaterException {
        this.buffer.append("(");
        this.formatExpr(expr.expr);
        if (expr.not) {
            this.buffer.append(" NOT IN (");
        } else {
            this.buffer.append(" IN (");
        }
        Iterator iterator = expr.targetList.iterator();
        boolean flag = false;
        int index = 1;
        while (iterator.hasNext()) {
            SqlExpr exprItem = (SqlExpr)iterator.next();
            if (index < 1000) {
                if (flag) {
                    this.buffer.append(", ");
                }
                this.formatExpr(exprItem);
                flag = true;
            } else {
                if (expr.not) {
                    this.buffer.append(") AND ");
                } else {
                    this.buffer.append(") OR ");
                }
                this.formatExpr(expr.expr);
                if (expr.not) {
                    this.buffer.append(" NOT IN (");
                } else {
                    this.buffer.append(" IN (");
                }
                this.formatExpr(exprItem);
                flag = true;
                index = 1;
            }
            ++index;
        }
        this.buffer.append(")");
        this.buffer.append(")");
    }

    @Override
    public void formatExpr(SqlExpr expr, boolean appendBrace) throws FormaterException {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        if (expr instanceof SqlAllColumnExpr) {
            this.buffer.append("*");
        } else if (expr instanceof SqlIdentifierExpr) {
            this.formatIdentifierExpr(expr);
        } else if (expr instanceof SqlIntExpr) {
            this.buffer.append(((SqlIntExpr)expr).text);
        } else if (expr instanceof SqlLongExpr) {
            this.buffer.append(((SqlLongExpr)expr).text);
        } else if (expr instanceof SqlDoubleExpr) {
            this.buffer.append(((SqlDoubleExpr)expr).text);
        } else if (expr instanceof SqlBinaryOpExpr) {
            this.formatBinaryOpExpr((SqlBinaryOpExpr)expr, appendBrace);
        } else if (expr instanceof SqlMethodInvokeExpr) {
            this.formatMethodInvokeExpr((SqlMethodInvokeExpr)expr);
        } else if (expr instanceof SqlAggregateExpr) {
            this.formatAggregateExprExpr((SqlAggregateExpr)expr);
        } else if (expr instanceof SqlCharExpr) {
            this.formatChar((SqlCharExpr)expr);
        } else if (expr instanceof SqlNCharExpr) {
            this.formatNChar((SqlNCharExpr)expr);
        } else if (expr instanceof SqlVarRefExpr) {
            this.formatVarRef((SqlVarRefExpr)expr);
        } else if (expr instanceof SqlCaseExpr) {
            this.formatCaseExpr((SqlCaseExpr)expr);
        } else if (expr instanceof SqlInListExpr) {
            this.formatInListExpr((SqlInListExpr)expr);
        } else if (expr instanceof SqlXinListExpr) {
            this.formatXinListExpr((SqlXinListExpr)expr);
        } else if (expr instanceof SqlExistsExpr) {
            this.formatExiststExpr((SqlExistsExpr)expr);
        } else if (expr instanceof SqlInSubQueryExpr) {
            this.formatInSubQueryExpr((SqlInSubQueryExpr)expr);
        } else if (expr instanceof SqlAllExpr) {
            this.formatAllExpr((SqlAllExpr)expr);
        } else if (expr instanceof SqlBetweenExpr) {
            this.formatBetweenExpr((SqlBetweenExpr)expr);
        } else if (expr instanceof SqlAnyExpr) {
            this.formatAnyExpr((SqlAnyExpr)expr);
        } else if (expr instanceof SqlSomeExpr) {
            this.formatSomeExpr((SqlSomeExpr)expr);
        } else if (expr instanceof SqlNullExpr) {
            this.buffer.append("NULL");
        } else if (expr instanceof SqlDateTimeExpr) {
            this.formatDateTimeExpr((SqlDateTimeExpr)expr);
        } else if (expr instanceof QueryExpr) {
            this.formatQueryExpr((QueryExpr)expr);
        } else if (expr instanceof SqlPriorIdentifierExpr) {
            this.formatPriorIdentifierExpr((SqlPriorIdentifierExpr)expr);
        } else if (expr instanceof SqlNotExpr) {
            this.formatNotExpr((SqlNotExpr)expr);
        } else if (expr.type == 28) {
            this.formatIdentityExpr(expr);
        } else {
            throw new FormaterException("Not support " + expr);
        }
    }

    protected void formatIdentityExpr(SqlExpr expr) {
        if (this.context.get("Identity") == null) {
            SqlIdentityExpr identityExpr = (SqlIdentityExpr)expr;
            this.context.put("Identity", "1|" + identityExpr.name);
            StringBuilder sequenceBuffer = new StringBuilder();
            sequenceBuffer.append("CREATE SEQUENCE ");
            sequenceBuffer.append(identityExpr.name);
            sequenceBuffer.append(";\n");
            this.buffer.insert(0, sequenceBuffer.toString());
            this.buffer.append(identityExpr.name);
            this.buffer.append(".Nextval");
        }
    }

    @Override
    protected void formatIdentifierExpr(SqlExpr expr) {
        String ident = ((SqlIdentifierExpr)expr).value;
        if (ident.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
            ident = "COLUMN_NAME";
        } else if (ident.equalsIgnoreCase(Token.INDNAME.value)) {
            ident = "INDEX_NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
            ident = "TABLE_NAME";
        } else if (ident.equalsIgnoreCase(Token.TABNAME.value)) {
            ident = "TABLE_NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
            ident = "CREATE_TIME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
            ident = "CONSTRAINT_NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
            ident = "TABLE_NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
            ident = "CONSTRAINT_TYPE";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
            ident = "DATA_DEFAULT";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
            ident = "NULLABLE";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
            ident = "DATA_TYPE";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
            ident = "DATA_LENGTH";
        }
        if (ident != null && ident.length() != 0 && ident.charAt(0) == '\"') {
            this.buffer.append(ident.toUpperCase());
        } else {
            this.buffer.append(ident);
        }
    }

    @Override
    protected void formatChar(SqlCharExpr expr) throws FormaterException {
        String text = expr.text;
        if (text.equalsIgnoreCase(Token.KSQL_CT_P.value)) {
            text = "P";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_F.value)) {
            text = "R";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_U.value)) {
            text = "U";
        } else if (text.equalsIgnoreCase(Token.KSQL_CT_C.value)) {
            text = "C";
        }
        this.buffer.append("'");
        if (this.context.get("toUpperCase") != null) {
            this.buffer.append(text.toUpperCase());
        } else {
            this.buffer.append(text);
        }
        this.buffer.append("'");
    }

    protected void formatIFExistSelectBase(SqlSelectBase select) throws FormaterException {
        if (!(select instanceof SqlSelect)) {
            throw new NotSupportedException("Not support SQL Statement :" + select);
        }
        SqlSelect ifExistsSelect = (SqlSelect)select;
        ifExistsSelect.selectList.clear();
        SqlAggregateExpr countExpr = new SqlAggregateExpr("COUNT");
        countExpr.paramList.add(new SqlAllColumnExpr());
        ifExistsSelect.selectList.add(new SqlSelectItem(countExpr, "FCOUNT INTO CNT"));
        this.formatSelect(ifExistsSelect);
    }

    @Override
    protected void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        boolean flag;
        Iterator iterator;
        boolean hasRowNum = false;
        SqlInsert insert = stmt.insert;
        this.buffer.append("INSERT ");
        if (insert.getHints() != null && !insert.getHints().isEmpty()) {
            this.buffer.append("INTO ");
        } else {
            this.buffer.append("INTO ");
        }
        this.buffer.append(insert.tableName);
        if (!insert.columnList.isEmpty()) {
            this.buffer.append(" (");
            iterator = insert.columnList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                Object colItem;
                if (flag) {
                    this.buffer.append(", ");
                }
                if ((colItem = iterator.next()) instanceof SqlIdentifierExpr) {
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    if (identExpr.value.equalsIgnoreCase("KSQL_SEQ")) {
                        hasRowNum = true;
                    }
                    this.buffer.append(identExpr.value);
                } else if (colItem instanceof String) {
                    this.buffer.append((String)colItem);
                } else {
                    throw new FormaterException("unexpect expression: '" + colItem + "'");
                }
                flag = true;
            }
            this.buffer.append(")");
        }
        if (insert.valueList.size() != 0) {
            this.buffer.append(" VALUES (");
            iterator = insert.valueList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr valueExpr = (SqlExpr)iterator.next();
                this.formatExpr(valueExpr);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(" ");
            if (hasRowNum) {
                this.buffer.append("SELECT ROWNUM,KSQL_V1.* FROM (");
            }
            this.formatSelectBase(stmt.insert.subQuery);
            if (hasRowNum) {
                this.buffer.append(") KSQL_V1");
            }
        }
    }

    @Override
    protected void formatDropTableStmt(SqlDropTableStmt stmt) throws FormaterException {
        this.buffer.append("DROP TABLE ");
        this.buffer.append(this.formatTableName(stmt.tableName));
    }

    @Override
    protected void formatIdentity(SqlExpr stmt) {
        this.buffer.append(" ROWNUM ");
    }
}

