/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.function.yasdb;

import java.util.Locale;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.function.KSQLFunction;

public class YasDBDateAddFunction
implements KSQLFunction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(SqlMethodInvokeExpr expr, SQLFormater formater) throws FormaterException {
        String methodNameI = expr.methodName.toUpperCase(Locale.ENGLISH);
        StringBuilder buffer = formater.getBuffer();
        if (methodNameI.compareTo("DATEADD") == 0) {
            if (expr.parameters.size() == 2) {
                buffer.append("(");
                formater.formatExpr((SqlExpr)expr.parameters.get(0));
                buffer.append(" + ");
                formater.formatExpr((SqlExpr)expr.parameters.get(1));
                buffer.append("/60/60/24)");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("Function DATEADD only support two or three parameters,but now have " + expr.parameters.size() + ".");
            this.dateAdd(expr, formater, methodNameI);
            return;
        } else {
            if (methodNameI.compareTo("DATETIMEADD") != 0) return;
            if (expr.parameters.size() != 3) throw new FormaterException("Function DATEADD only support two or three parameters,but now have " + expr.parameters.size() + ".");
            this.dateAdd(expr, formater, methodNameI);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dateAdd(SqlMethodInvokeExpr expr, SQLFormater formater, String functionName) throws FormaterException {
        StringBuilder buffer = formater.getBuffer();
        SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
        if (!(datepartExpr instanceof SqlIdentifierExpr)) throw new FormaterException("Function " + functionName + " not support datepart:" + datepartExpr.toString());
        String datepart = ((SqlIdentifierExpr)datepartExpr).value;
        if (datepart == null || datepart.length() == 0) {
            throw new FormaterException("illegal datepart.");
        }
        if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
            buffer.append("ADD_MONTHS(");
            formater.formatExpr((SqlExpr)expr.parameters.get(2));
            buffer.append(", TRUNC(");
            formater.formatExpr((SqlExpr)expr.parameters.get(1));
            buffer.append(") * 12)");
            return;
        } else if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
            buffer.append("ADD_MONTHS(");
            formater.formatExpr((SqlExpr)expr.parameters.get(2));
            buffer.append(", TRUNC(");
            formater.formatExpr((SqlExpr)expr.parameters.get(1));
            buffer.append(" ))");
            return;
        } else if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
            buffer.append("(");
            formater.formatExpr((SqlExpr)expr.parameters.get(2));
            buffer.append(" + TRUNC(");
            formater.formatExpr((SqlExpr)expr.parameters.get(1));
            buffer.append("))");
            return;
        } else if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
            buffer.append("(");
            formater.formatExpr((SqlExpr)expr.parameters.get(2));
            buffer.append(" + TRUNC(");
            formater.formatExpr((SqlExpr)expr.parameters.get(1));
            buffer.append(") / 24)");
            return;
        } else if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
            buffer.append("(");
            formater.formatExpr((SqlExpr)expr.parameters.get(2));
            buffer.append(" + TRUNC(");
            formater.formatExpr((SqlExpr)expr.parameters.get(1));
            buffer.append(") / 24 / 60)");
            return;
        } else {
            if (!"SECOND".equals(datepart) && !"SS".equals(datepart) && !"S".equals(datepart)) throw new FormaterException("Function " + functionName + " not support datepart:" + datepart);
            buffer.append("(");
            formater.formatExpr((SqlExpr)expr.parameters.get(2));
            buffer.append(" + TRUNC(");
            formater.formatExpr((SqlExpr)expr.parameters.get(1));
            buffer.append(") / 24 / 60 / 60)");
        }
    }
}

