/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.function.yasdb;

import java.util.Locale;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.function.KSQLFunction;

public class YasDBDateNameFunction
implements KSQLFunction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(SqlMethodInvokeExpr expr, SQLFormater formater) throws FormaterException {
        if (expr.parameters.size() != 2) throw new FormaterException("Function datename only support two parameters,but now have " + expr.parameters.size() + ".");
        StringBuilder buffer = formater.getBuffer();
        SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
        if (!(datepartExpr instanceof SqlIdentifierExpr)) return;
        String datepart = ((SqlIdentifierExpr)datepartExpr).value;
        if (datepart == null || datepart.length() == 0) {
            throw new FormaterException("illegal datepart.");
        }
        datepart = datepart.toUpperCase(Locale.ENGLISH);
        buffer.append("TO_CHAR(TO_DATE(");
        formater.formatExpr((SqlExpr)expr.parameters.get(1));
        buffer.append(",'").append(this.getFormat(expr.parameters.get(1))).append("')");
        if ("YEAR".equals(datepart) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
            buffer.append(", 'YYYY')");
            return;
        } else if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
            buffer.append(", 'MM')");
            return;
        } else if ("QUARTER".equals(datepart) || "QQ".equals(datepart) || "Q".equals(datepart)) {
            buffer.append(", 'Q')");
            return;
        } else if ("DAYOFYEAR".equals(datepart) || "DY".equals(datepart) || "Y".equals(datepart)) {
            buffer.append(", 'DDD')");
            return;
        } else if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
            buffer.append(", 'DD')");
            return;
        } else if ("WEEK".equals(datepart) || "WK".equals(datepart) || "WW".equals(datepart)) {
            buffer.append(", 'IW')");
            return;
        } else if ("WEEKDAY".equals(datepart) || "DW".equals(datepart)) {
            buffer.append(", 'DAY')");
            return;
        } else if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
            buffer.append(", 'HH24')");
            return;
        } else if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
            buffer.append(", 'MI')");
            return;
        } else if ("SECOND".equals(datepart) || "SS".equals(datepart) || "S".equals(datepart)) {
            buffer.append(", 'SS')");
            return;
        } else {
            if (!"MILLISECOND".equals(datepart) && !"MS".equals(datepart)) throw new FormaterException("Function datename not support datepart:" + datepart);
            formater.formatExpr((SqlExpr)expr.parameters.get(1));
            buffer.append(", 'SSxFF3')");
        }
    }

    private String getFormat(Object expr) {
        if (expr instanceof SqlCharExpr) {
            SqlCharExpr sqlCharExpr = (SqlCharExpr)expr;
            if (sqlCharExpr.text.indexOf(":") < 0) {
                return "YYYY-MM-DD";
            }
            return "YYYY-MM-DD HH:MI:SS";
        }
        return "YYYY-MM-DD";
    }
}

