/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.function.yasdb;

import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlMethodInvokeExpr;
import kd.bos.ksql.formater.FormaterException;
import kd.bos.ksql.formater.SQLFormater;
import kd.bos.ksql.function.KSQLFunction;

public class YasDBToDateFunction
implements KSQLFunction {
    @Override
    public void execute(SqlMethodInvokeExpr expr, SQLFormater formater) throws FormaterException {
        if (expr.parameters.size() != 1) {
            throw new FormaterException("Function todate only support one parameter,but now have " + expr.parameters.size() + ".");
        }
        String format = "'YYYY-MM-DD HH24:MI:SS'";
        StringBuilder buffer = formater.getBuffer();
        if (expr.parameters.get(0) instanceof SqlCharExpr) {
            SqlCharExpr dateTimeSqlExpr = (SqlCharExpr)expr.parameters.get(0);
            if (dateTimeSqlExpr.text.indexOf(".") > 0) {
                buffer.append("TO_TIMESTAMP");
                buffer.append("(");
                format = "'YYYY-MM-DD HH24:MI:SS:FF9'";
                formater.formatExpr(new SqlCharExpr(dateTimeSqlExpr.text));
            } else if (dateTimeSqlExpr.text.indexOf(":") < 0) {
                buffer.append("TO_DATE");
                buffer.append("(");
                if (dateTimeSqlExpr.text.endsWith(" ")) {
                    formater.formatExpr(new SqlCharExpr(dateTimeSqlExpr.text + "00:00:00"));
                } else {
                    formater.formatExpr(new SqlCharExpr(dateTimeSqlExpr.text + " 00:00:00"));
                }
            } else {
                buffer.append("TO_DATE");
                buffer.append("(");
                formater.formatExpr(dateTimeSqlExpr);
            }
        } else {
            buffer.append("TO_DATE");
            buffer.append("(");
            formater.formatExpr((SqlExpr)expr.parameters.get(0));
        }
        buffer.append(", ").append(format).append(")");
    }
}

