/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.parser;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.ksql.KSqlLimiter;
import kd.bos.ksql.KSqlUtil;
import kd.bos.ksql.dom.HierarchicalQueryClause;
import kd.bos.ksql.dom.SqlJoinedTableSource;
import kd.bos.ksql.dom.SqlOrderByItem;
import kd.bos.ksql.dom.SqlSelect;
import kd.bos.ksql.dom.SqlSelectBase;
import kd.bos.ksql.dom.SqlSelectInto;
import kd.bos.ksql.dom.SqlSelectItem;
import kd.bos.ksql.dom.SqlSelectLimit;
import kd.bos.ksql.dom.SqlSubQueryTableSource;
import kd.bos.ksql.dom.SqlTableSource;
import kd.bos.ksql.dom.SqlTableSourceBase;
import kd.bos.ksql.dom.SqlUnionSelect;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlExpr;
import kd.bos.ksql.dom.expr.SqlIdentifierExpr;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.HintsParser;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SqlExprParser;
import kd.bos.ksql.parser.SqlParserBase;
import kd.bos.ksql.parser.Token;
import kd.bos.ksql.parser.TokenList;
import kd.bos.ksql.rebuild.SqlStmtRebuilder;
import kd.bos.util.DisCardUtil;

public class SelectParser
extends SqlParserBase {
    private final TokenList _tokenList;
    private final SqlExprParser exprParser;

    public SelectParser(String sql) throws ParserException {
        Lexer lexer = new Lexer(sql);
        this._tokenList = new TokenList(lexer);
        this.exprParser = new SqlExprParser(this._tokenList);
    }

    public SelectParser(TokenList tokenList) {
        this._tokenList = tokenList;
        this.exprParser = new SqlExprParser(this._tokenList);
    }

    public SqlSelectBase select() throws ParserException {
        return this.select(true);
    }

    public SqlSelectBase select(boolean parseOrderBy) throws ParserException {
        SqlSelectBase rtnValue;
        SqlSelectBase select;
        if (this._tokenList.lookup(0).equals(Token.SelectToken)) {
            select = new SqlSelect();
            select.setSelectWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match(Token.SelectToken);
            this.selectHint((SqlSelect)select);
            this.selectListOption((SqlSelect)select);
            this.top((SqlSelect)select);
            this.selectList(select.selectList);
            this.into((SqlSelect)select);
            this.from((SqlSelect)select);
            this.where((SqlSelect)select);
            this.hierarchicalQueryClause((SqlSelect)select);
            this.groupBy((SqlSelect)select);
            rtnValue = this.selectRest(select);
        } else if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            this._tokenList.match();
            select = this.select();
            this._tokenList.match(Token.CloseBraceToken);
            if (parseOrderBy) {
                this.orderBy(select);
            }
            rtnValue = this.selectRest(select);
        } else {
            throw new ParserException("not support token:" + this._tokenList.lookup(0));
        }
        if (parseOrderBy) {
            this.orderBy(rtnValue);
        }
        if (this._tokenList.lookup(0).equals(Token.OptionToken)) {
            String optionWd = this._tokenList.lookup((int)0).value;
            this._tokenList.match();
            Map optionMap = rtnValue.getOptionMap();
            List optionWord = rtnValue.getOptionMapOrgWord();
            boolean flag = false;
            while (true) {
                int num;
                String numStr;
                String word;
                String query_hint;
                if ("CONCAT".equalsIgnoreCase(query_hint = this._tokenList.lookup((int)0).value)) {
                    flag = true;
                    this._tokenList.match(3);
                    word = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(Token.UnionToken);
                    optionMap.put("CONCAT UNION", null);
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("EXPAND".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    word = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(8, "VIEWS", false);
                    optionMap.put("EXPAND VIEWS", null);
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("FAST".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    numStr = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(8);
                    num = Integer.parseInt(numStr);
                    optionMap.put("FAST", num);
                    optionWord.add(optionWd + " " + query_hint);
                    continue;
                }
                if ("FASTFIRSTROW".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    optionMap.put("FASTFIRSTROW", null);
                    optionWord.add(optionWd + " " + query_hint);
                    continue;
                }
                if ("FOR".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    word = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(Token.UpdateToken);
                    optionMap.put("FORCE UPDATE", null);
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("FORCE".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    word = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(Token.OrderToken);
                    optionMap.put("FORCE ORDER", null);
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("HASH".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    word = this._tokenList.lookup((int)0).value;
                    if (this._tokenList.lookup(0).equals(Token.GroupToken)) {
                        this._tokenList.match();
                        optionMap.put("HASH GROUP", null);
                    } else if (this._tokenList.lookup(0).equals(Token.UnionToken)) {
                        this._tokenList.match();
                        optionMap.put("HASH UNION", null);
                    } else if (this._tokenList.lookup(0).equals(Token.JoinToken)) {
                        this._tokenList.match();
                        optionMap.put("HASH JOIN", null);
                    } else {
                        throw new ParserException("not support token:" + this._tokenList.lookup(0));
                    }
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("KEEP".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    word = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(Token.PlanToken);
                    optionMap.put("KEEP PLAN", null);
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("KEEPFIXED".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    word = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(Token.PlanToken);
                    optionMap.put("KEEPFIXED PLAN", null);
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("MAXDOP".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    numStr = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(8);
                    num = Integer.parseInt(numStr);
                    optionMap.put("MAXDOP", new Integer(num));
                    optionWord.add(optionWd + " " + query_hint);
                    continue;
                }
                if ("MERGE".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    word = this._tokenList.lookup((int)0).value;
                    if (this._tokenList.lookup(0).equals(Token.UnionToken)) {
                        this._tokenList.match();
                        optionMap.put("MERGE UNION", null);
                    } else if (this._tokenList.lookup(0).equals(Token.JoinToken)) {
                        this._tokenList.match();
                        optionMap.put("MERGE JOIN", null);
                    } else {
                        throw new ParserException("not support token:" + this._tokenList.lookup(0));
                    }
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("ORDER".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match(3);
                    word = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(Token.GroupToken);
                    optionMap.put("ORDER GROUP", null);
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("LOOP".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    word = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(Token.JoinToken);
                    optionMap.put("LOOP JOIN", null);
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("ROBUST".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    word = this._tokenList.lookup((int)0).value;
                    this._tokenList.match(Token.PlanToken);
                    optionMap.put("ROBUST PLAN", null);
                    optionWord.add(optionWd + " " + query_hint + " " + word);
                    continue;
                }
                if ("ROWLOCK".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    optionMap.put("ROWLOCK", null);
                    optionWord.add(optionWd + " " + query_hint);
                    continue;
                }
                if ("TABLOCK".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    optionMap.put("TABLOCK", null);
                    optionWord.add(optionWd + " " + query_hint);
                    continue;
                }
                if ("UPDLOCK".equalsIgnoreCase(query_hint)) {
                    flag = true;
                    this._tokenList.match();
                    optionMap.put("UPDLOCK", null);
                    optionWord.add(optionWd + " " + query_hint);
                    continue;
                }
                if (!"XLOCK".equalsIgnoreCase(query_hint)) break;
                flag = true;
                this._tokenList.match();
                optionMap.put("XLOCK", null);
                optionWord.add(optionWd + " " + query_hint);
            }
            if (!flag) {
                throw new ParserException("Syntax Error. Option hints ... , current token is : " + this._tokenList.lookup(0).toString());
            }
        }
        KSqlUtil.AutoChineseSortField(rtnValue);
        KSqlLimiter.limitSelectAllColumn(rtnValue);
        return rtnValue;
    }

    private void into(SqlSelect select) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.IntoToken)) {
            String intoWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            if (this._tokenList.lookup((int)0).type == 1) {
                SqlSelectInto into = new SqlSelectInto();
                into.setIntoWord(intoWord);
                into.new_table = this._tokenList.lookup((int)0).value;
                into.setNewTableOrgName(this._tokenList.lookup(0).getOrgValue());
                this._tokenList.match();
                select.into = into;
            } else {
                throw new ParserException("Error. token:" + this._tokenList.lookup((int)0).value, this._tokenList.lookup((int)0).beginLine, this._tokenList.lookup((int)0).beginColumn);
            }
        }
    }

    private final SqlSelectBase selectRest(SqlSelectBase select) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.UnionToken)) {
            this._tokenList.match();
            int option = 0;
            if (this._tokenList.lookup(0).equals(Token.AllToken)) {
                this._tokenList.match();
                option = 1;
            }
            SqlSelectBase right = this.select(false);
            select = new SqlUnionSelect(select, right, option);
            select = this.selectRest(select);
        }
        return select;
    }

    private void hierarchicalQueryClause(SqlSelect select) throws ParserException {
        HierarchicalQueryClause hierarchicalQueryClause = null;
        String hierarchicalQueryClauseWord = "";
        if (this._tokenList.lookup(0).equals(Token.StartToken)) {
            hierarchicalQueryClauseWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            hierarchicalQueryClauseWord = hierarchicalQueryClauseWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.WithToken);
            hierarchicalQueryClause = new HierarchicalQueryClause();
            hierarchicalQueryClause.setStartWithWord(hierarchicalQueryClauseWord);
            hierarchicalQueryClause.startWithCondition = this.exprParser.expr();
        }
        if (this._tokenList.lookup(0).equals(Token.ConnectToken)) {
            hierarchicalQueryClauseWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            hierarchicalQueryClauseWord = hierarchicalQueryClauseWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.ByToken);
            if (hierarchicalQueryClause == null) {
                hierarchicalQueryClause = new HierarchicalQueryClause();
            }
            hierarchicalQueryClause.setConnectByWord(hierarchicalQueryClauseWord);
            hierarchicalQueryClause.connectByCondition = this.exprParser.expr();
        }
        select.hierarchicalQueryClause = hierarchicalQueryClause;
    }

    private final void selectListOption(SqlSelect select) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.DistinctToken)) {
            select.setDistinctWord(this._tokenList.lookup(0).getOrgValue());
            select.distinct = 1;
            this._tokenList.match();
        } else if (this._tokenList.lookup(0).equals(Token.AllToken)) {
            select.setDistinctWord(this._tokenList.lookup(0).getOrgValue());
            select.distinct = 0;
            this._tokenList.match();
        }
    }

    private void selectHint(SqlSelect select) throws ParserException {
        if (this._tokenList.lookup((int)0).type == 16) {
            String hints = this._tokenList.lookup((int)0).value;
            select.getHints().addAll(HintsParser.parse(hints));
            this._tokenList.match();
        }
    }

    private final void top(SqlSelect select) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.TopToken)) {
            select.setTopWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            if (this._tokenList.lookup((int)0).type == 8) {
                SqlSelectLimit top = new SqlSelectLimit(Integer.parseInt(this._tokenList.lookup((int)0).value));
                this._tokenList.match();
                if (this._tokenList.lookup(0).equals(Token.CommaToken)) {
                    this._tokenList.match();
                    if (this._tokenList.lookup((int)0).type == 8) {
                        top.offset = Integer.parseInt(this._tokenList.lookup((int)0).value);
                        this._tokenList.match();
                    }
                }
                if (this._tokenList.lookup(0).equals(Token.PercentToken)) {
                    top.type = 1;
                    this._tokenList.match();
                }
                select.limit = top;
            } else {
                throw new ParserException("Error. ", this._tokenList.lookup((int)0).beginLine, this._tokenList.lookup((int)0).beginColumn);
            }
        }
    }

    private final void from(SqlSelect select) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.FromToken)) {
            select.setFromWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            select.tableSource = this.tableSource();
        }
    }

    private final void where(SqlSelect select) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.WhereToken)) {
            SqlExpr expr;
            select.setWhereWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            select.condition = expr = this.exprParser.expr();
        }
        select.condition = SqlStmtRebuilder.rebuild(select.condition, select);
    }

    private final void groupBy(SqlSelect select) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.GroupToken)) {
            String tmp = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            tmp = tmp + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.ByToken);
            select.setGroupByWord(tmp);
            this.exprParser.exprList(select.groupBy);
            this.withRollUp(select);
            this.having(select);
        }
    }

    private final void withRollUp(SqlSelect select) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.WithToken)) {
            String tmp = this._tokenList.lookup(0).getOrgValue();
            if (this._tokenList.lookup(1).equals(Token.RollUpToken)) {
                tmp = tmp + " " + this._tokenList.lookup(1).getOrgValue();
                select.setWithRollUpWord(tmp);
                select.hasWithRollUp = true;
                this._tokenList.match();
                this._tokenList.match();
            }
        }
    }

    private final void having(SqlSelect select) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.HavingToken)) {
            select.setHavingWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            select.having = this.exprParser.expr();
        }
    }

    private final void orderBy(SqlSelectBase select) throws ParserException {
        if (this._tokenList.lookup(0).equals(Token.OrderToken)) {
            String tmp = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            tmp = tmp + " " + this._tokenList.lookup(0).getOrgValue();
            select.setOrderByWord(tmp);
            do {
                SqlOrderByItem orderByItem;
                this._tokenList.match();
                String chineseOBN = null;
                int chineseOrderByMode = -1;
                SqlExpr expr = this.exprParser.expr();
                if (this._tokenList.lookup(0).equals(Token.PinYinToken)) {
                    chineseOBN = this._tokenList.lookup(0).getOrgValue();
                    chineseOrderByMode = 2;
                    this._tokenList.match();
                } else if (this._tokenList.lookup(0).equals(Token.StrokeToken)) {
                    chineseOBN = this._tokenList.lookup(0).getOrgValue();
                    chineseOrderByMode = 3;
                    this._tokenList.match();
                } else if (this._tokenList.lookup(0).equals(Token.RadicalToken)) {
                    chineseOBN = this._tokenList.lookup(0).getOrgValue();
                    chineseOrderByMode = 4;
                    this._tokenList.match();
                } else {
                    chineseOrderByMode = -1;
                }
                if (this._tokenList.lookup(0).equals(Token.AscToken)) {
                    orderByItem = new SqlOrderByItem(expr, 0, chineseOrderByMode);
                    orderByItem.setOrgOrderByName(this._tokenList.lookup(0).getOrgValue());
                    orderByItem.setOrgChineseOrderByType(chineseOBN);
                    this._tokenList.match();
                } else if (this._tokenList.lookup(0).equals(Token.DescToken)) {
                    orderByItem = new SqlOrderByItem(expr, 1, chineseOrderByMode);
                    orderByItem.setOrgOrderByName(this._tokenList.lookup(0).getOrgValue());
                    orderByItem.setOrgChineseOrderByType(chineseOBN);
                    this._tokenList.match();
                } else {
                    orderByItem = new SqlOrderByItem(expr, 0, chineseOrderByMode);
                    orderByItem.setOrgOrderByName("");
                    orderByItem.setOrgChineseOrderByType(chineseOBN);
                }
                select.orderBy.add(orderByItem);
            } while (this._tokenList.lookup(0).equals(Token.CommaToken));
        }
    }

    private final void selectList(Collection selectItemCol) throws ParserException {
        SqlExpr expr = this.exprParser.expr();
        String alias = null;
        boolean isMark = false;
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)expr;
            if ((binaryOpExpr.operator == 2 || binaryOpExpr.operator == 10) && binaryOpExpr.left instanceof SqlIdentifierExpr) {
                expr = binaryOpExpr.right;
                alias = ((SqlIdentifierExpr)binaryOpExpr.left).value;
                isMark = true;
            }
        }
        String[] sb = new String[2];
        if (alias == null) {
            alias = this.as(sb);
        } else {
            sb[0] = "";
            sb[1] = alias;
        }
        selectItemCol.add(new SqlSelectItem(expr, alias, sb[1], sb[0], isMark));
        while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            this._tokenList.match();
            alias = null;
            expr = this.exprParser.expr();
            isMark = false;
            if (expr instanceof SqlBinaryOpExpr) {
                SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)expr;
                if ((binaryOpExpr.operator == 2 || binaryOpExpr.operator == 10) && binaryOpExpr.left instanceof SqlIdentifierExpr) {
                    expr = binaryOpExpr.right;
                    alias = ((SqlIdentifierExpr)binaryOpExpr.left).value;
                    isMark = true;
                }
            }
            sb = new String[2];
            if (alias == null) {
                alias = this.as(sb);
            } else {
                sb[0] = "";
                sb[1] = alias;
            }
            selectItemCol.add(new SqlSelectItem(expr, alias, sb[1], sb[0], isMark));
        }
    }

    public SqlTableSourceBase tableSource() throws ParserException {
        StringBuilder orgTableName;
        StringBuilder tableName;
        SqlTableSourceBase tablesource = null;
        int openBraceCount = 0;
        if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            this._tokenList.match();
            tablesource = this.tableSource();
            SqlSubQueryTableSource subQueryTabSrc = null;
            if (tablesource instanceof SqlSubQueryTableSource) {
                subQueryTabSrc = (SqlSubQueryTableSource)tablesource;
                subQueryTabSrc.subQuery = this.selectRest(subQueryTabSrc.subQuery);
            }
            this._tokenList.match(Token.CloseBraceToken);
            String[] sb = new String[2];
            String alias = this.as(sb);
            if (alias != null && alias.length() != 0 && subQueryTabSrc != null) {
                subQueryTabSrc.alias = alias;
                subQueryTabSrc.setAsWord(sb[0]);
                subQueryTabSrc.setOrgAlias(sb[1]);
            }
            tablesource = this.tableSourceRest(tablesource);
            return tablesource;
        }
        if (this._tokenList.lookup(0).equals(Token.SelectToken)) {
            SelectParser selectParser = new SelectParser(this._tokenList);
            SqlSelectBase subQuery = selectParser.select();
            tablesource = new SqlSubQueryTableSource(subQuery);
        } else if (this._tokenList.lookup((int)0).type == 1) {
            tableName = new StringBuilder();
            orgTableName = new StringBuilder();
            tableName.append(this._tokenList.lookup((int)0).value);
            orgTableName.append(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match(1);
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                this._tokenList.match();
                this._tokenList.match(2);
                this._tokenList.match(Token.CloseBraceToken);
                tableName.append("(?)");
                tablesource = new SqlTableSource(tableName.toString());
                ((SqlTableSource)tablesource).setOrgName(orgTableName.toString());
                ((SqlTableSource)tablesource).setVariableTable(true);
            } else {
                while (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                    tableName.append(".");
                    orgTableName.append(".");
                    this._tokenList.match();
                    tableName.append(this._tokenList.lookup((int)0).value);
                    orgTableName.append(this._tokenList.lookup(0).getOrgValue());
                    this._tokenList.match(1);
                }
                tablesource = new SqlTableSource(tableName.toString());
                ((SqlTableSource)tablesource).setOrgName(orgTableName.toString());
            }
        } else if (this._tokenList.lookup((int)0).type == 3 && (this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.USERTABLES.value) || this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.USERCOLUMNS.value) || this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.SYSINDEXES.value)) || this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.SYSCONSTRAINTS.value) || this._tokenList.lookup((int)0).value.equalsIgnoreCase(Token.FunctionToken.value)) {
            tableName = new StringBuilder();
            orgTableName = new StringBuilder();
            tableName.append(this._tokenList.lookup((int)0).value);
            orgTableName.append(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match(3);
            tablesource = new SqlTableSource(tableName.toString());
            ((SqlTableSource)tablesource).setOrgName(orgTableName.toString());
        }
        while (openBraceCount != 0) {
            this._tokenList.match(Token.CloseBraceToken);
            --openBraceCount;
        }
        return this.tableSourceRest(tablesource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SqlTableSourceBase tableSourceRest(SqlTableSourceBase tablesource) throws ParserException {
        SqlTableSourceBase right;
        String joinWord;
        if (this._tokenList.lookup(0).equals(Token.AsToken)) {
            tablesource.setAsWord(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            if (this._tokenList.lookup((int)0).type == 1) {
                if (tablesource.alias != null) throw new ParserException("Error");
                tablesource.alias = this._tokenList.lookup((int)0).value;
                tablesource.setOrgAlias(this._tokenList.lookup(0).getOrgValue());
                this._tokenList.match();
                tablesource = this.tableSourceRest(tablesource);
            } else {
                if (this._tokenList.lookup((int)0).type != 6) throw new ParserException("Error");
                if (tablesource.alias != null) throw new ParserException("Error");
                tablesource.setAlias("'" + this._tokenList.lookup((int)0).value + "'");
                this._tokenList.match();
                tablesource = this.tableSourceRest(tablesource);
            }
        } else if (this._tokenList.lookup((int)0).type == 1) {
            if (tablesource.alias != null && tablesource.alias.length() != 0) throw new ParserException("Error", 0, 0);
            tablesource.alias = this._tokenList.lookup((int)0).value;
            tablesource.setOrgAlias(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            tablesource = this.tableSourceRest(tablesource);
        } else if (this._tokenList.lookup((int)0).type == 6) {
            if (tablesource.alias != null && tablesource.alias.length() != 0) throw new ParserException("Error", 0, 0);
            tablesource.setAlias("'" + this._tokenList.lookup((int)0).value + "'");
            this._tokenList.match();
            tablesource = this.tableSourceRest(tablesource);
        } else if (this._tokenList.lookup((int)0).type == 7) {
            if (tablesource.alias != null && tablesource.alias.length() != 0) throw new ParserException("Error", 0, 0);
            tablesource.alias = "N'" + this._tokenList.lookup((int)0).value + "'";
            tablesource.setOrgAlias(this._tokenList.lookup(0).getOrgValue());
            this._tokenList.match();
            tablesource = this.tableSourceRest(tablesource);
        } else if (this._tokenList.lookup(0).equals(Token.JoinToken)) {
            joinWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            right = this.tableSource();
            String onWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.OnToken);
            SqlExpr condition = this.exprParser.expr();
            tablesource = new SqlJoinedTableSource(tablesource, right, 0, condition, joinWord, onWord);
        } else if (this._tokenList.lookup(0).equals(Token.InnerToken)) {
            joinWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            joinWord = joinWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.JoinToken);
            right = this.tableSource();
            String onWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.OnToken);
            SqlExpr condition = this.exprParser.expr();
            tablesource = new SqlJoinedTableSource(tablesource, right, 0, condition, joinWord, onWord);
        } else if (this._tokenList.lookup(0).equals(Token.LeftToken)) {
            joinWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.OuterToken)) {
                joinWord = joinWord + " " + this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match(Token.OuterToken);
            }
            joinWord = joinWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.JoinToken);
            right = this.tableSource();
            String onWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.OnToken);
            SqlExpr condition = this.exprParser.expr();
            SelectParser.checkOuterJoinCondition(condition);
            tablesource = new SqlJoinedTableSource(tablesource, right, 1, condition, joinWord, onWord);
        } else if (this._tokenList.lookup(0).equals(Token.RightToken)) {
            joinWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.OuterToken)) {
                joinWord = joinWord + " " + this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match(Token.OuterToken);
            }
            joinWord = joinWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.JoinToken);
            right = this.tableSource();
            String onWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.OnToken);
            SqlExpr condition = this.exprParser.expr();
            tablesource = new SqlJoinedTableSource(tablesource, right, 2, condition, joinWord, onWord);
        } else if (this._tokenList.lookup(0).equals(Token.FullToken)) {
            joinWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.OuterToken)) {
                joinWord = joinWord + " " + this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match(Token.OuterToken);
            }
            joinWord = joinWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.JoinToken);
            right = this.tableSource();
            String onWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.OnToken);
            SqlExpr condition = this.exprParser.expr();
            tablesource = new SqlJoinedTableSource(tablesource, right, 3, condition, joinWord, onWord);
        } else if (this._tokenList.lookup(0).equals(Token.CrossToken)) {
            String crossWord = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            crossWord = crossWord + " " + this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match(Token.JoinToken);
            right = this.tableSource();
            tablesource = new SqlJoinedTableSource(tablesource, right, 4, null, crossWord, "");
        } else if (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            this._tokenList.match();
            SqlTableSourceBase right2 = this.tableSource();
            tablesource = new SqlJoinedTableSource(tablesource, right2, 4, null, ",", "");
        }
        if (this._tokenList.lookup(0).equals(Token.CommaToken) || this._tokenList.lookup(0).equals(Token.InnerToken) || this._tokenList.lookup(0).equals(Token.LeftToken) || this._tokenList.lookup(0).equals(Token.RightToken) || this._tokenList.lookup(0).equals(Token.FullToken) || this._tokenList.lookup(0).equals(Token.JoinToken)) {
            tablesource = this.tableSourceRest(tablesource);
        }
        if (!(tablesource instanceof SqlTableSource)) return tablesource;
        SqlTableSource tabSrc = (SqlTableSource)tablesource;
        if (!this._tokenList.lookup(0).equals(Token.WithToken)) return tablesource;
        tabSrc.setWithWord(this._tokenList.lookup(0).getOrgValue());
        this._tokenList.match();
        this._tokenList.match(Token.OpenBraceToken);
        String lockingHint = this._tokenList.lookup((int)0).value;
        if (!(lockingHint.equalsIgnoreCase("HOLDLOCK") || lockingHint.equalsIgnoreCase("READPAST") || lockingHint.equalsIgnoreCase("NOLOCK") || lockingHint.equalsIgnoreCase("PAGLOCK") || lockingHint.equalsIgnoreCase("READCOMMITTED"))) {
            throw new ParserException("Not support locking hints.");
        }
        tabSrc.setHintWord(lockingHint);
        tabSrc.lockingHint = lockingHint.toUpperCase();
        this._tokenList.match();
        this._tokenList.match(Token.CloseBraceToken);
        return tablesource;
    }

    private static void checkOuterJoinCondition(SqlExpr expr) throws ParserException {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binaryOpExpr = (SqlBinaryOpExpr)expr;
            if (binaryOpExpr.operator != 10) {
                if (binaryOpExpr.operator == 7) {
                    SelectParser.checkOuterJoinCondition(binaryOpExpr.left);
                    SelectParser.checkOuterJoinCondition(binaryOpExpr.right);
                } else if (binaryOpExpr.operator == 15) {
                    SelectParser.checkOuterJoinCondition(binaryOpExpr.left);
                    SelectParser.checkOuterJoinCondition(binaryOpExpr.right);
                } else if (binaryOpExpr.operator == 12) {
                    SelectParser.checkOuterJoinCondition(binaryOpExpr.left);
                    SelectParser.checkOuterJoinCondition(binaryOpExpr.right);
                } else if (binaryOpExpr.operator == 20) {
                    DisCardUtil.discard();
                } else {
                    DisCardUtil.discard();
                }
            }
        } else {
            DisCardUtil.discard();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String as(String[] sb) throws ParserException {
        String rtnValue = null;
        if (this._tokenList.lookup(0).equals(Token.AsToken)) {
            sb[0] = this._tokenList.lookup(0).getOrgValue();
            this._tokenList.match();
            if (this._tokenList.lookup((int)0).type == 6) {
                sb[1] = rtnValue = "'" + this._tokenList.lookup((int)0).value + "'";
                this._tokenList.match();
                return rtnValue;
            } else {
                if (this._tokenList.lookup((int)0).type != 1) throw new ParserException("Error", 0, 0);
                rtnValue = this._tokenList.lookup((int)0).value;
                sb[1] = this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match();
            }
            return rtnValue;
        } else {
            sb[0] = "";
            if (this._tokenList.lookup((int)0).type == 6) {
                sb[1] = rtnValue = "'" + this._tokenList.lookup((int)0).value + "'";
                this._tokenList.match();
                return rtnValue;
            } else {
                if (this._tokenList.lookup((int)0).type != 1) return rtnValue;
                rtnValue = this._tokenList.lookup((int)0).value;
                sb[1] = this._tokenList.lookup(0).getOrgValue();
                this._tokenList.match();
            }
        }
        return rtnValue;
    }
}

