/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.procedures.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import kd.bos.util.StringUtils;

public class CommentProcedure {
    public static String buildAlterCommentSql(Statement statement, String schema, String tableName, String columnName, String comment) throws SQLException {
        String columnTypeValue;
        Object defaultValue;
        String isNullValue;
        block18: {
            tableName = tableName.toUpperCase(Locale.ENGLISH);
            columnName = columnName.toUpperCase(Locale.ENGLISH);
            if (StringUtils.isNotEmpty((String)schema)) {
                schema = schema.toUpperCase(Locale.ENGLISH);
            }
            String queryColumnsSql = CommentProcedure.buildQueryColumnsSql(schema, tableName, columnName);
            isNullValue = null;
            defaultValue = null;
            columnTypeValue = null;
            try (ResultSet resultSet = statement.executeQuery(queryColumnsSql);){
                if (resultSet.next()) {
                    columnTypeValue = resultSet.getString(1);
                    isNullValue = "YES".equalsIgnoreCase(resultSet.getString(2)) ? "NULL" : "NOT NULL";
                    defaultValue = resultSet.getObject(3);
                    break block18;
                }
                throw new SQLException("Unknown column'" + columnName + "' in '" + tableName + "'");
            }
        }
        StringBuilder alterCommentSql = new StringBuilder();
        alterCommentSql.append("ALTER TABLE ");
        if (StringUtils.isNotEmpty((String)schema)) {
            alterCommentSql.append(schema).append(".");
        }
        alterCommentSql.append(tableName).append(" MODIFY COLUMN ");
        alterCommentSql.append(columnName).append(" ");
        alterCommentSql.append(columnTypeValue).append(" ");
        alterCommentSql.append(isNullValue).append(" ");
        if (defaultValue != null) {
            alterCommentSql.append("DEFAULT ");
            if (defaultValue instanceof String) {
                alterCommentSql.append("'").append(defaultValue).append("'");
            } else {
                alterCommentSql.append(defaultValue);
            }
            alterCommentSql.append(" ");
        }
        alterCommentSql.append("COMMENT ").append("'").append(comment).append("'");
        return alterCommentSql.toString();
    }

    private static String buildQueryColumnsSql(String schema, String tableName, String columnName) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COLUMN_TYPE,IS_NULLABLE,COLUMN_DEFAULT FROM INFORMATION_SCHEMA.COLUMNS WHERE ");
        if (StringUtils.isNotEmpty((String)schema)) {
            sql.append("TABLE_SCHEMA='").append(schema).append("' AND ");
        }
        sql.append("TABLE_NAME='").append(tableName).append("' AND ");
        sql.append("COLUMN_NAME='").append(columnName).append("'");
        return sql.toString();
    }
}

