/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.procedures.tidb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class AlterPKProcedure {
    private static final Logger logger = Logger.getLogger(AlterPKProcedure.class);
    private static final String queryPKSQL = "SELECT 1 FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_SCHEMA = SCHEMA () AND CONSTRAINT_TYPE = 'PRIMARY KEY' AND upper(TABLE_NAME) = '%s'";
    private static final String dropPkSQL = "ALTER TABLE %s DROP PRIMARY KEY";
    private static final String addPkSQL = "ALTER TABLE %s ADD PRIMARY KEY (%s)";

    public static void call(Statement statement, String pkName, String tableName, String fieldName, String isClustered) throws SQLException {
        ResultSet resultSet = statement.executeQuery(String.format(queryPKSQL, tableName.toUpperCase(Locale.ENGLISH)));
        if (resultSet.next()) {
            try {
                statement.execute(String.format(dropPkSQL, tableName.toUpperCase(Locale.ENGLISH)));
            }
            catch (SQLException e) {
                String messagePattern = "Unsupported Operation[DO_NOT_DROP_PRIMARY_KEY]: The current version of TiDB does not support deleting primary keys. It is recommended to manually migrate and handle it. Source sql is: EXEC P_ALTERPK '{}', '{}', '{}', {};";
                Object[] params = new Object[]{pkName, tableName, fieldName, isClustered};
                String message = MessageFormatter.arrayFormat((String)messagePattern, (Object[])params).getMessage();
                throw new SQLException(message);
            }
        }
        if (null != fieldName && !"".equals(fieldName) && !"NULL".equals(fieldName)) {
            statement.execute(String.format(addPkSQL, tableName.toUpperCase(Locale.ENGLISH), fieldName));
        }
    }
}

