/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.rebuild;

import kd.bos.ksql.rebuild.SqlReBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlReBuilderManager {
    private static final Logger log = LoggerFactory.getLogger(SqlReBuilderManager.class);
    private static final String RE_BUILDER_CLASS_NAME = System.getProperty("ksql.reBuilder.className");
    private static SqlReBuilder reBuilder;

    public static void init() {
    }

    private SqlReBuilderManager() {
    }

    public static boolean isEnable() {
        return reBuilder != null;
    }

    public static SqlReBuilder getReBuilder() {
        return reBuilder;
    }

    static {
        if (RE_BUILDER_CLASS_NAME != null) {
            try {
                Object sqlReBuilder = Class.forName(RE_BUILDER_CLASS_NAME.trim()).newInstance();
                if (sqlReBuilder instanceof SqlReBuilder) {
                    log.info("SqlReBuilder plugin : {} load success.", (Object)sqlReBuilder.getClass().getName());
                    reBuilder = (SqlReBuilder)sqlReBuilder;
                } else {
                    log.warn("SqlReBuilder fail, plugin need imported kd.bos.ksql.rebuild.SqlReBuilder .");
                }
            }
            catch (Exception ex) {
                log.warn("SqlReBuilder load fail,msg=" + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

