/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;
import kd.bos.thread.SetThreadName;
import kd.bos.util.ThreadLocals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutExecutor {
    private static final Logger log = LoggerFactory.getLogger(TimeoutExecutor.class);
    private static final ThreadFactory tf = new ThreadFactory(){
        private final ThreadGroup g = new ThreadGroup(TimeoutExecutor.class.getSimpleName());

        @Override
        public Thread newThread(Runnable r) {
            return new TimeroutThread(this.g, r);
        }
    };
    private static final ExecutorService es = new ThreadPoolExecutor(1, 3, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), tf);

    public static void submit(Runnable task) {
        es.submit(() -> {
            try {
                SetThreadName.start();
                task.run();
                if (log.isInfoEnabled() && task instanceof CancelTimeroutTask) {
                    log.info(String.format("TimeoutExecutor run,tenantId:%s,accountId:%s,traceId:%s", ((CancelTimeroutTask)task).getTenantId(), ((CancelTimeroutTask)task).getAccountId(), ((CancelTimeroutTask)task).getTraceId()));
                }
            }
            finally {
                SetThreadName.end();
                ThreadLocals.release();
            }
        });
    }

    public static class TimeroutThread
    extends Thread {
        private static AtomicInteger seq = new AtomicInteger();

        public TimeroutThread(ThreadGroup g, Runnable r) {
            super(g, r);
            this.setName("ksql-jdbc-TimeroutThread-" + seq.incrementAndGet());
            this.setDaemon(true);
        }
    }
}

