/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout.context;

import java.lang.reflect.Method;
import kd.bos.bundle.Resources;
import kd.bos.util.ThreadLocals;

public class RequestContextInfo {
    private static Method requestContext_get;
    private static Method requestContext_set;
    private static Method requestContext_setTenantId;
    private static Method requestContext_getTenantId;
    private static Method requestContext_setAccountId;
    private static Method requestContext_getAccountId;
    private static Method requestContext_getTraceId;
    private static Method requestContext_setTraceId;
    private static Method requestContext_createAndSet;
    private static Method requestContext_getSetStack;
    private static final ThreadLocal<RequestContextInfo> th;
    private Object rc;
    private final String tenantId;
    private final String accountId;
    private final String traceId;

    public static RequestContextInfo get() {
        try {
            Object rc = requestContext_get.invoke(null, new Object[0]);
            if (rc == null) {
                IllegalThreadStateException e = new IllegalThreadStateException(Resources.get((String)"bos-ksql", (String)"RequestContextInfo_0", (String)"RequestContext\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7ebf\u7a0b\u73af\u5883\u662f\u5426\u6b63\u786e\u3002", (Object[])new Object[0]));
                throw e;
            }
            RequestContextInfo ret = th.get();
            if (ret == null || ret.rc != rc) {
                ret = new RequestContextInfo((String)requestContext_getTenantId.invoke(rc, new Object[0]), (String)requestContext_getAccountId.invoke(rc, new Object[0]), (String)requestContext_getTraceId.invoke(rc, new Object[0]));
                ret.rc = rc;
                th.set(ret);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getRequestContext() {
        try {
            return requestContext_get.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getRequestContextSetStack() {
        try {
            return (String)requestContext_getSetStack.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RequestContextInfo(String tenantId, String accountId, String traceId) {
        this.tenantId = tenantId;
        this.accountId = accountId;
        this.traceId = traceId;
    }

    public String getTenantAccountKey() {
        if (this.tenantId == null || this.accountId == null) {
            throw new IllegalArgumentException("tenantId or accountId can not be null");
        }
        return this.tenantId + '#' + this.accountId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public AutoCloseable setupThreadRequestContext() {
        try {
            Object oldRequestContext = requestContext_get.invoke(null, new Object[0]);
            Object rc = requestContext_createAndSet.invoke(null, Boolean.TRUE);
            requestContext_setTenantId.invoke(rc, this.tenantId);
            requestContext_setAccountId.invoke(rc, this.accountId);
            requestContext_setTraceId.invoke(rc, this.traceId);
            return () -> requestContext_set.invoke(null, oldRequestContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.tenantId + "#" + this.accountId;
    }

    static {
        th = ThreadLocals.create();
        try {
            Class<?> requestContextCls = Class.forName("kd.bos.context.RequestContext");
            requestContext_getTenantId = requestContextCls.getMethod("getTenantId", new Class[0]);
            requestContext_getAccountId = requestContextCls.getMethod("getAccountId", new Class[0]);
            requestContext_getTraceId = requestContextCls.getMethod("getTraceId", new Class[0]);
            requestContext_setTenantId = requestContextCls.getMethod("setTenantId", String.class);
            requestContext_setAccountId = requestContextCls.getMethod("setAccountId", String.class);
            requestContext_setTraceId = requestContextCls.getMethod("setTraceId", String.class);
            requestContext_get = requestContextCls.getMethod("get", new Class[0]);
            requestContext_set = requestContextCls.getMethod("set", requestContextCls);
            requestContext_createAndSet = requestContextCls.getMethod("create", Boolean.TYPE);
            requestContext_getSetStack = requestContextCls.getMethod("getSetStack", new Class[0]);
            requestContext_getTenantId.setAccessible(true);
            requestContext_getAccountId.setAccessible(true);
            requestContext_getTraceId.setAccessible(true);
            requestContext_setTenantId.setAccessible(true);
            requestContext_setAccountId.setAccessible(true);
            requestContext_setTraceId.setAccessible(true);
            requestContext_get.setAccessible(true);
            requestContext_set.setAccessible(true);
            requestContext_createAndSet.setAccessible(true);
            requestContext_getSetStack.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

