/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout.timer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.instance.Instance;
import kd.bos.ksql.shell.timeout.CancelTaskManager;
import kd.bos.ksql.shell.timeout.context.RequestContextInfo;
import kd.bos.ksql.shell.timeout.timer.KsqlCancelTimer;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;

public class KsqlCancelService {
    private static final Map<String, KsqlCancelTimer> accountKsqlCancelTimerCache = new ConcurrentHashMap<String, KsqlCancelTimer>();

    private static KsqlCancelTimer getKsqlCancelTimer() {
        return accountKsqlCancelTimerCache.computeIfAbsent(RequestContextInfo.get().getTenantAccountKey(), k -> {
            KsqlCancelTimer ksqlCancelTimer = new KsqlCancelTimer(String.format("ksql-jdbc-SelfCancelTimer-%s-%s", k, Instance.getInstanceId()));
            ksqlCancelTimer.setDaemon(true);
            ksqlCancelTimer.start();
            return ksqlCancelTimer;
        });
    }

    public static void addTimerTask(CancelTimeroutTask timerTask, long seconds) {
        KsqlCancelTimer timer = KsqlCancelService.getKsqlCancelTimer();
        timer.schedule(timerTask, seconds);
        CancelTaskManager.get().addCancelTimeout(timerTask);
    }

    public static void purgeTimerTasks(CancelTimeroutTask timerTask) {
        timerTask.cancel();
        CancelTaskManager.get().removeCancelTimeout(timerTask);
        KsqlCancelTimer timer = KsqlCancelService.getKsqlCancelTimer();
        if (timer != null) {
            timer.cancelTask(timerTask);
        }
    }
}

