/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout.timer;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.instance.Instance;
import kd.bos.ksql.shell.timeout.CancelTaskManager;
import kd.bos.ksql.shell.timeout.context.RequestContextInfo;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;

public class SharedTimer {
    private static final AtomicInteger timerCount = new AtomicInteger(0);
    private static final Map<String, Timer> accountSharedTimerCache = new ConcurrentHashMap<String, Timer>();

    private static Timer getTimer() {
        return accountSharedTimerCache.computeIfAbsent(RequestContextInfo.get().getTenantAccountKey(), k -> {
            int index = timerCount.incrementAndGet();
            return new Timer(String.format("ksql-jdbc-SharedTimer-%s-%s-%s", k, Instance.getInstanceId(), index), true);
        });
    }

    public static void addTimerTask(CancelTimeroutTask timerTask, long seconds) {
        Timer timer = SharedTimer.getTimer();
        timer.schedule((TimerTask)timerTask, seconds * 1000L);
        CancelTaskManager.get().addCancelTimeout(timerTask);
    }

    public static void purgeTimerTasks(CancelTimeroutTask timerTask) {
        timerTask.cancel();
        CancelTaskManager.get().removeCancelTimeout(timerTask);
        Timer timer = SharedTimer.getTimer();
        if (timer != null) {
            timer.purge();
        }
    }
}

