/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout.timer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.instance.Instance;
import kd.bos.ksql.shell.timeout.CancelTaskManager;
import kd.bos.ksql.shell.timeout.context.RequestContextInfo;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerExecutorService {
    private static final Logger log = LoggerFactory.getLogger(TimerExecutorService.class);
    private static final Map<String, ScheduledExecutorService> accountScheduledExecutorCache = new ConcurrentHashMap<String, ScheduledExecutorService>();

    private static ScheduledExecutorService getTimerExecutorService() {
        return accountScheduledExecutorCache.computeIfAbsent(RequestContextInfo.get().getTenantAccountKey(), k -> {
            DefaultThreadFactory threadFactory = new DefaultThreadFactory(String.format("ksql-jdbc-TimerExecutor-%s-%s", k, Instance.getInstanceId()));
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory, new ThreadPoolExecutor.DiscardPolicy());
            executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            executor.setRemoveOnCancelPolicy(true);
            return executor;
        });
    }

    public static ScheduledFuture addTimerTask(CancelTimeroutTask timerTask, long seconds) {
        ScheduledExecutorService timer = TimerExecutorService.getTimerExecutorService();
        ScheduledFuture<?> endOfLife = timer.schedule(timerTask, seconds, TimeUnit.SECONDS);
        CancelTaskManager.get().addCancelTimeout(timerTask);
        return endOfLife;
    }

    public static void purgeTimerTasks(CancelTimeroutTask timerTask, ScheduledFuture<?> endOfLife) {
        timerTask.cancel();
        if (endOfLife != null && !endOfLife.isDone() && !endOfLife.cancel(false)) {
            log.warn(String.format("Cancel task execute warn, cancelId=%s, traceId=%s.", timerTask.getCancelId(), timerTask.getTraceId()));
        }
        CancelTaskManager.get().removeCancelTimeout(timerTask);
    }

    public static final class DefaultThreadFactory
    implements ThreadFactory {
        private final String threadName;
        private final boolean daemon;

        public DefaultThreadFactory(String threadName) {
            this.threadName = threadName;
            this.daemon = true;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.threadName);
            thread.setDaemon(this.daemon);
            return thread;
        }
    }
}

