/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout.timetask;

import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.TimerTask;
import kd.bos.ksql.shell.KDConnection;
import kd.bos.ksql.shell.timeout.context.RequestContextInfo;
import kd.bos.ksql.shell.timeout.context.RequestContextWrap;
import kd.bos.ksql.shell.timeout.context.ThreadRouteKeyContext;
import kd.bos.ksql.shell.timeout.timetask.ExecuteType;
import kd.bos.ksql.shell.trace.TraceInfo;
import kd.bos.ksql.util.StringUtil;
import kd.bos.thread.ThreadTruck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CancelTimeroutTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(CancelTimeroutTask.class);
    protected long cancelId;
    protected final String routeKey;
    protected final String tenantId;
    protected final String accountId;
    protected final String traceId;
    protected final long threadId;
    protected final ExecuteType executeType;
    protected long nextExecutionTime;
    protected volatile boolean executed = false;
    private volatile boolean canceled = false;
    private volatile boolean started = false;
    protected Throwable caughtWhileCancelling = null;

    protected CancelTimeroutTask(KDConnection kdConnection, ExecuteType executeType) {
        ThreadRouteKeyContext routeKeyContext = ThreadRouteKeyContext.get();
        this.executeType = executeType;
        TraceInfo traceInfo = kdConnection.getTraceInfo();
        String connRouteKey = traceInfo != null ? traceInfo.getRouteKey() : null;
        this.routeKey = connRouteKey != null ? connRouteKey : routeKeyContext.getRouteKey();
        RequestContextInfo requestContextInfo = RequestContextInfo.get();
        this.traceId = StringUtil.isEmpty((String)ThreadTruck.get((Object)"apm.traceid.string")) ? kdConnection.getTraceInfo().getRouteKey() : (String)ThreadTruck.get((Object)"apm.traceid.string");
        this.tenantId = requestContextInfo.getTenantId();
        this.accountId = requestContextInfo.getAccountId();
        this.threadId = Thread.currentThread().getId();
    }

    @Override
    public void run() {
        new Thread(new RequestContextWrap(this, () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        })).start();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean cancel() {
        this.canceled = true;
        return super.cancel();
    }

    public abstract void cancelExecute(Statement var1) throws SQLException;

    public void checkCancelTimeout() throws SQLTimeoutException {
    }

    public void rethrowCancelReason() throws SQLException {
        if (this.caughtWhileCancelling != null) {
            Throwable t = this.caughtWhileCancelling;
            throw new SQLException(t.getMessage(), t);
        }
    }

    public abstract String getKillSql();

    public long getCancelId() {
        return this.cancelId;
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public ExecuteType getExecuteType() {
        return this.executeType;
    }

    public long getNextExecutionTime() {
        return this.nextExecutionTime;
    }

    public void setNextExecutionTime(long nextExecutionTime) {
        this.nextExecutionTime = nextExecutionTime;
    }
}

