/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout.timetask;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import kd.bos.ksql.shell.KDConnection;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;
import kd.bos.ksql.shell.timeout.timetask.ExecuteType;
import org.postgresql.jdbc.PgConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgressCancelTimeroutTaskImpl
extends CancelTimeroutTask {
    private static final Logger log = LoggerFactory.getLogger(PostgressCancelTimeroutTaskImpl.class);
    private static final String KILL_QUERY = "/*dialect*/SELECT PG_CANCEL_BACKEND(%s)";

    public PostgressCancelTimeroutTaskImpl(KDConnection kdConnection, ExecuteType executeType) {
        super(kdConnection, executeType);
        try {
            this.cancelId = kdConnection.getNativeConnection().unwrap(PgConnection.class).getBackendPID();
        }
        catch (SQLException e) {
            log.error("PostgressCancelTimeroutTaskImpl init error.", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void cancelExecute(Statement statement) throws SQLException {
        try (ResultSet rs = statement.executeQuery(this.getKillSql());){
            if (rs.next()) {
                this.executed = rs.getBoolean(1);
            }
        }
    }

    @Override
    public String getKillSql() {
        return String.format(KILL_QUERY, this.cancelId);
    }
}

