/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.shell.timeout.timetask;

import kd.bos.ksql.shell.KDConnection;
import kd.bos.ksql.shell.timeout.TimeoutConfig;
import kd.bos.ksql.shell.timeout.context.CancelTimeoutTaskInternalContext;
import kd.bos.ksql.shell.timeout.context.RequestContextInfo;
import kd.bos.ksql.shell.timeout.context.ThreadRouteKeyContext;
import kd.bos.ksql.shell.timeout.timetask.CancelTimeroutTask;
import kd.bos.ksql.shell.timeout.timetask.ExecuteType;
import kd.bos.ksql.shell.timeout.timetask.MysqlCancelTimeroutTaskImpl;
import kd.bos.ksql.shell.timeout.timetask.PostgressCancelTimeroutTaskImpl;
import kd.bos.ksql.shell.trace.TraceInfo;
import kd.bos.ksql.util.StringUtil;
import kd.bos.thread.ThreadTruck;

public class TimeoutTaskFactory {
    public static CancelTimeroutTask getCancelTimeTask(KDConnection kdConnection, ExecuteType executeType) {
        if (!TimeoutConfig.isEnable()) {
            return null;
        }
        ThreadRouteKeyContext routeKeyContext = ThreadRouteKeyContext.get();
        CancelTimeoutTaskInternalContext internalContext = CancelTimeoutTaskInternalContext.get();
        if (routeKeyContext == null || internalContext != null) {
            return null;
        }
        RequestContextInfo requestContextInfo = RequestContextInfo.get();
        if (requestContextInfo == null) {
            return null;
        }
        TraceInfo traceInfo = kdConnection.getTraceInfo();
        String connRouteKey = traceInfo != null ? traceInfo.getRouteKey() : null;
        String routeKey = connRouteKey != null ? connRouteKey : routeKeyContext.getRouteKey();
        String traceId = (String)ThreadTruck.get((Object)"apm.traceid.string");
        if (StringUtil.isEmpty(routeKey) || StringUtil.isEmpty(traceId)) {
            return null;
        }
        int dbType = kdConnection.getDbType();
        switch (dbType) {
            case 6: {
                return new MysqlCancelTimeroutTaskImpl(kdConnection, executeType);
            }
            case 5: {
                return new PostgressCancelTimeroutTaskImpl(kdConnection, executeType);
            }
        }
        return null;
    }
}

