/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import kd.bos.ksql.util.Base64;
import kd.bos.ksql.util.Rijndael_Algorithm;
import org.apache.log4j.Logger;

public class Rijndael_Util {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int DEFAULT_BLOCK_SIZE = 16;
    private static final Logger logger = Logger.getLogger(Rijndael_Util.class);

    public static final int getInt(byte[] bytes, int offSet) {
        return (bytes[offSet + 0] & 0xFF) << 24 | bytes[offSet + 1] << 16 | (bytes[offSet + 2] & 0xFF) << 8 | (bytes[offSet + 3] & 0xFF) << 0;
    }

    public static final void putInt(int val, byte[] bytes, int offSet) {
        bytes[offSet] = (byte)(val >> 24);
        bytes[offSet + 1] = (byte)(val >> 16);
        bytes[offSet + 2] = (byte)(val >> 8);
        bytes[offSet + 3] = (byte)val;
    }

    public static String byte2String(byte[] bytes) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (i != 0) {
                buff.append(", ");
            }
            buff.append(bytes[i]);
        }
        return buff.toString();
    }

    public static byte[] make_kb_16(String strKey) {
        return Rijndael_Util.make_kb(strKey, 16);
    }

    public static byte[] make_kb_24(String strKey) {
        return Rijndael_Util.make_kb(strKey, 24);
    }

    public static byte[] make_kb_32(String strKey) {
        return Rijndael_Util.make_kb(strKey, 32);
    }

    private static byte[] make_kb(String strKey, int size) {
        byte[] bytes;
        byte[] kb = new byte[size];
        try {
            bytes = strKey.getBytes(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)e.getMessage());
            return null;
        }
        System.arraycopy(bytes, 0, kb, 0, bytes.length > size ? size : bytes.length);
        return kb;
    }

    public static String encode(String key, String strData) throws InvalidKeyException {
        byte[] pt;
        byte[] kb = Rijndael_Util.make_kb_32(key);
        try {
            pt = strData.getBytes(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)e.getMessage());
            return null;
        }
        byte[] ct = Rijndael_Util.encode(kb, pt, 16);
        return Base64.encodeBytes(ct);
    }

    public static String encode(String key, String strData, int blockSize) throws InvalidKeyException {
        byte[] pt;
        byte[] kb = Rijndael_Util.make_kb_32(key);
        try {
            pt = strData.getBytes(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)e.getMessage());
            return null;
        }
        byte[] ct = Rijndael_Util.encode(kb, pt, blockSize);
        return Base64.encodeBytes(ct);
    }

    public static String encode(byte[] kb, String data) throws InvalidKeyException {
        byte[] pt;
        try {
            pt = data.getBytes(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)e.getMessage());
            return null;
        }
        byte[] ct = Rijndael_Util.encode(kb, pt, 16);
        return Base64.encodeBytes(ct, false);
    }

    public static String decode(String key, String strData) throws InvalidKeyException {
        String text = null;
        try {
            byte[] kb = Rijndael_Util.make_kb_32(key);
            byte[] ct = Base64.decode(strData);
            byte[] cpt = Rijndael_Util.decode(kb, ct, 16);
            text = new String(cpt);
        }
        catch (Exception e) {
            throw new InvalidKeyException("decode error.");
        }
        return text;
    }

    public static String decode(byte[] kb, String strData) throws InvalidKeyException {
        String pt;
        byte[] ct = Base64.decode(strData);
        byte[] cpt = Rijndael_Util.decode(kb, ct, 16);
        try {
            pt = new String(cpt, DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)e.getMessage());
            return null;
        }
        return pt;
    }

    public static String decode(String key, String strData, int blockSize) throws InvalidKeyException {
        byte[] kb = Rijndael_Util.make_kb_32(key);
        byte[] ct = Base64.decode(strData);
        byte[] cpt = Rijndael_Util.decode(kb, ct, blockSize);
        return new String(cpt);
    }

    public static byte[] encode(byte[] kb, byte[] pt) throws InvalidKeyException {
        return Rijndael_Util.encode(kb, pt, 16);
    }

    public static byte[] encode(byte[] kb, byte[] pt, int blockSize) throws InvalidKeyException {
        Object key = Rijndael_Algorithm.makeKey(kb, blockSize);
        int dataLength = pt.length;
        int mode = dataLength % blockSize;
        byte[] ct = new byte[mode == 0 ? pt.length : 8 + dataLength + blockSize - mode];
        for (int i = 0; i < dataLength; i += blockSize) {
            int restDataLength = dataLength - i;
            if (restDataLength >= blockSize) {
                byte[] block_ct = Rijndael_Algorithm.blockEncrypt(pt, i, key, blockSize);
                System.arraycopy(block_ct, 0, ct, i, blockSize);
                continue;
            }
            if (blockSize == 16 || blockSize == 24) {
                Object last_block_key = Rijndael_Algorithm.makeKey(kb, blockSize + 8);
                byte[] block_pt = new byte[blockSize + 8];
                System.arraycopy(pt, i, block_pt, 0, restDataLength);
                Rijndael_Util.putInt(dataLength, block_pt, blockSize);
                byte[] block_ct = Rijndael_Algorithm.blockEncrypt(block_pt, 0, last_block_key, blockSize + 8);
                System.arraycopy(block_ct, 0, ct, i, blockSize + 8);
                continue;
            }
            Object key_16 = Rijndael_Algorithm.makeKey(kb, 16);
            byte[] block_24_pt = new byte[24];
            if (restDataLength > 16) {
                byte[] block_16_ct = Rijndael_Algorithm.blockEncrypt(pt, i, key_16, 16);
                System.arraycopy(block_16_ct, 0, ct, i, 16);
                System.arraycopy(pt, i + 16, block_24_pt, 0, restDataLength -= 16);
            } else {
                byte[] block_pt = new byte[16];
                System.arraycopy(pt, i, block_pt, 0, restDataLength);
                byte[] block_16_ct = Rijndael_Algorithm.blockEncrypt(block_pt, 0, key_16, 16);
                System.arraycopy(block_16_ct, 0, ct, i, 16);
            }
            Object key_24 = Rijndael_Algorithm.makeKey(kb, 24);
            Rijndael_Util.putInt(dataLength, block_24_pt, 16);
            byte[] block_24_ct = Rijndael_Algorithm.blockEncrypt(block_24_pt, 0, key_24, 24);
            System.arraycopy(block_24_ct, 0, ct, i + 16, 24);
        }
        return ct;
    }

    public static byte[] decode(byte[] kb, byte[] ct) throws InvalidKeyException {
        return Rijndael_Util.decode(kb, ct, 16);
    }

    public static byte[] decode(byte[] kb, byte[] ct, int blockSize) throws InvalidKeyException {
        byte[] pt;
        int mode = ct.length % blockSize;
        Object key = Rijndael_Algorithm.makeKey(kb, blockSize);
        if (mode == 0) {
            pt = new byte[ct.length];
            for (int i = 0; i < ct.length; i += blockSize) {
                byte[] block_pt = Rijndael_Algorithm.blockDecrypt(ct, i, key, blockSize);
                System.arraycopy(block_pt, 0, pt, i, blockSize);
            }
        } else {
            int dataLength;
            if (blockSize == 16 || blockSize == 24) {
                Object first_key = Rijndael_Algorithm.makeKey(kb, blockSize + 8);
                byte[] last_block_pt = Rijndael_Algorithm.blockDecrypt(ct, ct.length - blockSize - 8, first_key, blockSize + 8);
                dataLength = Rijndael_Util.getInt(last_block_pt, blockSize);
                try {
                    pt = new byte[dataLength];
                }
                catch (OutOfMemoryError oom) {
                    throw new InvalidKeyException("decode error.");
                }
                System.arraycopy(last_block_pt, 0, pt, ct.length - blockSize - 8, dataLength % blockSize);
            } else {
                Object key_24 = Rijndael_Algorithm.makeKey(kb, 24);
                byte[] last_block_24_pt = Rijndael_Algorithm.blockDecrypt(ct, ct.length - 24, key_24, 24);
                dataLength = Rijndael_Util.getInt(last_block_24_pt, 16);
                try {
                    pt = new byte[dataLength];
                }
                catch (OutOfMemoryError oom) {
                    throw new InvalidKeyException("decode error.");
                }
                if (dataLength > ct.length - 24) {
                    System.arraycopy(last_block_24_pt, 0, pt, ct.length - 24, dataLength - (ct.length - 24));
                }
                Object key_16 = Rijndael_Algorithm.makeKey(kb, 16);
                byte[] last_block_16_pt = Rijndael_Algorithm.blockDecrypt(ct, ct.length - 24 - 16, key_16, 16);
                if (pt.length > ct.length - 24) {
                    System.arraycopy(last_block_16_pt, 0, pt, ct.length - 24 - 16, 16);
                } else {
                    System.arraycopy(last_block_16_pt, 0, pt, ct.length - 24 - 16, pt.length - (ct.length - 24 - 16));
                }
            }
            for (int i = 0; i < ct.length - blockSize - 8; i += blockSize) {
                byte[] block_pt = Rijndael_Algorithm.blockDecrypt(ct, i, key, blockSize);
                System.arraycopy(block_pt, 0, pt, i, blockSize);
            }
        }
        return pt;
    }
}

