/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ksql.util;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Properties;
import kd.bos.ksql.util.UUTNException;
import kd.bos.util.ConfigurationUtil;
import org.apache.log4j.Logger;

public class UUTNSource {
    public static final String ORMRPC_CONFIG = "ormrpc.config";
    public static final String ORMRPC_PROPERTIES = "ormrpc.properties";
    public static final String TCP_CONNECTION_PORT = "tcpConnectionPort";
    public static final String DEFAULT_PORT = "-11034";
    private static final Logger logger = Logger.getLogger(UUTNSource.class);

    static String getUniqueSource() throws UUTNException {
        try {
            InetAddress addr = UUTNSource.getLocleAddress();
            logger.debug((Object)("[TempTableManager] Create UUTN Source: " + addr));
            return addr + ":" + UUTNSource.getPortString();
        }
        catch (SocketException e) {
            throw new UUTNException(e);
        }
    }

    public static InetAddress getLocleAddress() throws SocketException {
        InetAddress loopbackAddress = null;
        InetAddress locleAddress = null;
        Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
        while (e1.hasMoreElements()) {
            NetworkInterface netif = e1.nextElement();
            Enumeration<InetAddress> e2 = netif.getInetAddresses();
            while (e2.hasMoreElements()) {
                InetAddress addr = e2.nextElement();
                if (addr.isLoopbackAddress()) {
                    loopbackAddress = addr;
                }
                if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isMulticastAddress()) continue;
                locleAddress = addr;
            }
        }
        return locleAddress == null ? loopbackAddress : locleAddress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPortString() {
        String config = ConfigurationUtil.getString((String)ORMRPC_CONFIG);
        if (config == null) return DEFAULT_PORT;
        if (config.trim().length() == 0) {
            return DEFAULT_PORT;
        }
        try (FileInputStream fs = new FileInputStream(config);){
            Properties props = new Properties();
            props.load(fs);
            String string = props.getProperty(TCP_CONNECTION_PORT, DEFAULT_PORT);
            return string;
        }
        catch (Exception ignore) {
            logger.info((Object)("ORMRPC cannot load config file from [" + config + "]"));
            return DEFAULT_PORT;
        }
    }
}

