/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zk;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.encrypt.Encrypters;
import kd.bos.env.Env;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ha.component.KeepAliveListener;
import kd.bos.ha.component.KeepAliveService;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;
import kd.bos.zk.CuratorFrameworkWrapper;
import kd.bos.zk.ZkKeepAliveListener;
import kd.sdk.annotation.SdkInternal;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.retry.RetryNTimes;
import org.apache.log4j.Logger;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

@SdkInternal
public class ZKFactory {
    private static final String ZKADDR_STR = "zkaddreass";
    private static final String ZKROOTPATH_STR = "zkrootpath";
    private static final String ZKSCHEME_STR = "scheme";
    private static final String ZKUSER_STR = "user";
    private static final String ZKPASS_STR = "password";
    public static final ConcurrentHashMap<String, CuratorFramework> poolMap = new ConcurrentHashMap();
    private static Logger logger = Logger.getLogger(ZKFactory.class);
    private static Map<String, Map<String, String>> parsedUrlMap = new ConcurrentHashMap<String, Map<String, String>>();
    private static final String ZK_TRACE_NAME = "ZKFactory";

    static Map<String, CuratorFramework> getPool() {
        return poolMap;
    }

    static void put(String url, CuratorFramework curatorFramework) {
        poolMap.put(url, curatorFramework);
    }

    private static Map<String, String> parseUrl(String url) {
        Map<String, String> m = parsedUrlMap.get(url);
        if (m != null) {
            return m;
        }
        m = new ConcurrentHashMap<String, String>();
        int propIndex = url.indexOf(63);
        String _url = url;
        if (propIndex > 0) {
            String[] sl = url.split("\\?");
            _url = sl[0];
            String strUrlParams = sl[1];
            Properties prop = new Properties();
            try {
                String[] params = null;
                params = strUrlParams.contains("&") ? strUrlParams.split("&") : new String[]{strUrlParams};
                for (String p : params) {
                    if (p.startsWith(ZKPASS_STR)) {
                        String password = p.substring(ZKPASS_STR.length() + 1);
                        prop.put(ZKPASS_STR, password);
                        continue;
                    }
                    if (!p.contains("=")) continue;
                    String[] param = p.split("=");
                    if (param.length == 1) {
                        prop.put(param[0], "");
                        continue;
                    }
                    String key = param[0];
                    String value = param[1];
                    prop.put(key, value);
                }
                m.put(ZKSCHEME_STR, prop.getProperty(ZKSCHEME_STR, "digest"));
                m.put(ZKUSER_STR, prop.getProperty(ZKUSER_STR));
                String pass = prop.getProperty(ZKPASS_STR);
                if (pass != null) {
                    pass = Encrypters.decode((String)pass);
                    m.put(ZKPASS_STR, pass);
                }
            }
            catch (Exception e) {
                logger.error((Object)"parse zookeeper url exception", (Throwable)e);
            }
        }
        m.put(ZKADDR_STR, ZKFactory._getZkAddress(_url));
        m.put(ZKROOTPATH_STR, ZKFactory._getZkRootPath(_url));
        parsedUrlMap.put(url, m);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @SdkInternal
    public static CuratorFramework getZKClient(String url) {
        Map<String, String> urlInfo;
        TraceSpan span;
        block21: {
            block20: {
                boolean mcIsStarted = Boolean.getBoolean("mc.isstarted");
                span = null;
                if (mcIsStarted) {
                    span = Tracer.create((String)ZK_TRACE_NAME, (String)"getZKClient", (boolean)true);
                    TopologyTagInject.setCompentTag((InnerSpan)span.getInnerSpan(), (String)url, (String)"Zookeeper", (String)"zk");
                }
                if (!poolMap.containsKey(url = (urlInfo = ZKFactory.parseUrl(url)).get(ZKADDR_STR))) break block20;
                CuratorFramework curatorFramework = poolMap.get(url);
                if (span == null) return curatorFramework;
                try {
                    span.close();
                    return curatorFramework;
                }
                catch (Throwable e) {
                    logger.error((Object)e.getMessage(), e);
                }
                return curatorFramework;
            }
            Class<ZKFactory> clazz = ZKFactory.class;
            // MONITORENTER : kd.bos.zk.ZKFactory.class
            if (!poolMap.containsKey(url)) break block21;
            CuratorFramework e = poolMap.get(url);
            // MONITOREXIT : clazz
            if (span == null) return e;
            try {
                span.close();
                return e;
            }
            catch (Throwable e2) {
                logger.error((Object)e2.getMessage(), e2);
            }
            return e;
        }
        Object retryPolicy = Boolean.getBoolean("ha.component.enable") && !StringUtils.isEmpty((String)SystemProperties.getWithEnv((String)"ha.zookeeper.backup")) ? new RetryNTimes(Integer.getInteger("zookeeper.client.retry.times", 3).intValue(), Integer.getInteger("zookeeper.client.retry.sleep.time", 1000).intValue()) : new RetryForever(Integer.getInteger("zookeeper.client.retry.intervalMs", 10000).intValue());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(url).sessionTimeoutMs(Integer.getInteger("curator-default-session-timeout", 60000).intValue()).connectionTimeoutMs(Integer.getInteger("curator-default-connection-timeout", 15000).intValue()).retryPolicy((RetryPolicy)retryPolicy);
        String user = urlInfo.get(ZKUSER_STR);
        String pass = urlInfo.get(ZKPASS_STR);
        if (user != null && pass != null) {
            final String auth = user + ":" + pass;
            ACLProvider aclProvider = new ACLProvider(){
                private List<ACL> acl;

                public List<ACL> getDefaultAcl() {
                    if (this.acl == null) {
                        ArrayList acl = ZooDefs.Ids.CREATOR_ALL_ACL;
                        acl.clear();
                        acl.add(new ACL(31, new Id("auth", auth)));
                        this.acl = acl;
                    }
                    return this.acl;
                }

                public List<ACL> getAclForPath(String path) {
                    return this.acl;
                }
            };
            builder.authorization(urlInfo.get(ZKSCHEME_STR), auth.getBytes());
            builder.aclProvider(aclProvider);
        }
        CuratorFrameworkWrapper client = new CuratorFrameworkWrapper(builder.build());
        client.start();
        poolMap.put(url, client);
        if (!Env.isMicroKernel()) {
            KeepAliveService.registerKeepAliveListener((KeepAliveListener)new ZkKeepAliveListener(url, client));
        }
        CuratorFrameworkWrapper curatorFrameworkWrapper = client;
        // MONITOREXIT : clazz
        if (span == null) return curatorFrameworkWrapper;
        {
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.configZookeepConfig, new Object[]{e.getMessage()});
            }
        }
        try {
            span.close();
            return curatorFrameworkWrapper;
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
        }
        return curatorFrameworkWrapper;
        catch (Throwable throwable) {
            if (span == null) throw throwable;
            try {
                span.close();
                throw throwable;
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
            throw throwable;
        }
    }

    @SdkInternal
    public static String getAuthority(String url) {
        Map<String, String> urlInfo = ZKFactory.parseUrl(url);
        String user = urlInfo.get(ZKUSER_STR);
        String pass = urlInfo.get(ZKPASS_STR);
        if (user != null && pass != null) {
            return user + ":" + pass;
        }
        return null;
    }

    @SdkInternal
    public static String getZkAddress(String url) {
        Map<String, String> urlInfo = ZKFactory.parseUrl(url);
        return urlInfo.get(ZKADDR_STR);
    }

    private static String _getZkAddress(String url) {
        int index = url.indexOf(47);
        if (index > 0) {
            return url.substring(0, index);
        }
        return url;
    }

    @SdkInternal
    public static String getZkRootPath(String url) {
        Map<String, String> urlInfo = ZKFactory.parseUrl(url);
        return urlInfo.get(ZKROOTPATH_STR);
    }

    private static String _getZkRootPath(String url) {
        int index = url.indexOf(47);
        if (index > 0) {
            String r = url.substring(index);
            if (!r.endsWith("/")) {
                r = r + "/";
            }
            return r;
        }
        return "/";
    }

    static {
        System.setProperty("zookeeper.sasl.client", System.getProperty("zookeeper.sasl.client", "false"));
        System.setProperty("jdk.tls.rejectClientInitiatedRenegotiation", System.getProperty("jdk.tls.rejectClientInitiatedRenegotiation", "true"));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> poolMap.forEach((k, v) -> {
            try {
                v.getZookeeperClient().getZooKeeper().close();
                logger.info((Object)"close zookeeperConnection on shutdown");
            }
            catch (Exception e) {
                logger.error((Object)("error on ShutdownHook of " + k), (Throwable)e);
            }
        })));
    }
}

