/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zk;

import java.util.Map;
import kd.bos.ha.component.KeepAliveListener;
import kd.bos.instance.Instance;
import kd.bos.util.SystemProperties;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

class ZkKeepAliveListener
implements KeepAliveListener {
    private static Logger logger = Logger.getLogger(ZkKeepAliveListener.class);
    private String originUrl;
    private CuratorFramework client;

    public ZkKeepAliveListener(String url, CuratorFramework client) {
        this.client = client;
        this.originUrl = url;
    }

    public boolean isAvailable() {
        try {
            ZooKeeper.States state = this.client.getZookeeperClient().getZooKeeper().getState();
            boolean connected = state.isConnected();
            return connected;
        }
        catch (Exception e) {
            logger.error((Object)("zookeeper keepAlive error, url: " + this.originUrl), (Throwable)e);
            return false;
        }
    }

    public void notifyOffline() {
        if (Boolean.getBoolean("ha.component.redis.debug.enable")) {
            return;
        }
        String zkUrl = SystemProperties.getWithEnv((String)"ha.zookeeper.backup");
        if (!zkUrl.equalsIgnoreCase(this.originUrl)) {
            Map<String, CuratorFramework> poolMap = ZKFactory.getPool();
            if (poolMap.containsKey(zkUrl)) {
                CuratorFramework curatorFramework = poolMap.get(zkUrl);
                if (curatorFramework.getZookeeperClient().isConnected()) {
                    ZKFactory.put(this.originUrl, curatorFramework);
                } else {
                    logger.error((Object)"no zookeeper connection is available");
                }
            } else {
                ZKFactory.put(this.originUrl, ZKFactory.getZKClient(zkUrl));
            }
            logger.warn((Object)("zookeeper remote to backup url, origin url: " + this.originUrl));
        } else {
            logger.error((Object)("backup zookeeper equals master, url: " + zkUrl));
        }
    }

    public void notifyOnline() {
        try {
            String rootPath = ZKFactory.getZkRootPath(this.originUrl);
            String p = rootPath + Instance.getInstanceId() + "-zkspeedtest";
            Stat exists = (Stat)this.client.checkExists().forPath(p);
            if (exists == null) {
                ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT)).forPath(p);
            }
            this.client.delete().forPath(p);
            ZKFactory.put(this.originUrl, this.client);
        }
        catch (Exception e) {
            throw new RuntimeException("zookeeper master online error", e);
        }
    }

    public String getUrl() {
        return this.originUrl;
    }
}

