/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.mservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.pigeon.dispatch.mservice.DispatchService;
import kd.bos.pigeon.dispatch.mservice.DispatchTaskDTOWrapper;
import kd.bos.pigeon.dispatch.mservice.HashQueue;
import kd.bos.pigeon.dispatch.mservice.TaskHandlerThread;

public class DispatchServiceFactory {
    private static final int QUEUE_MAX = 10000;
    private static final Map<String, DispatchService> BIZTYPE_DISPATCHSERVICE_MAP = new HashMap<String, DispatchService>();
    private static final Map<String, HashQueue<String, DispatchTaskDTOWrapper>> BIZTYPE_TASKQUEUE_MAP = new HashMap<String, HashQueue<String, DispatchTaskDTOWrapper>>();
    private static final Map<String, TaskHandlerThread> BIZTYPE_THREAD_MAP = new HashMap<String, TaskHandlerThread>();

    public static DispatchService getDispatchService(String bizType) {
        return BIZTYPE_DISPATCHSERVICE_MAP.computeIfAbsent(bizType, k -> {
            HashQueue taskQueue = BIZTYPE_TASKQUEUE_MAP.computeIfAbsent(bizType, key -> new HashQueue(10000));
            BIZTYPE_THREAD_MAP.computeIfAbsent(bizType, key -> {
                TaskHandlerThread tempThread = new TaskHandlerThread(bizType, taskQueue);
                tempThread.start();
                return tempThread;
            });
            return new DispatchService(bizType, taskQueue);
        });
    }

    public static int getTaskQueueSize(String bizType) {
        if (BIZTYPE_TASKQUEUE_MAP.containsKey(bizType)) {
            return BIZTYPE_TASKQUEUE_MAP.get(bizType).size();
        }
        return 0;
    }

    public static int getActiveThreadCount(String bizType) {
        if (BIZTYPE_THREAD_MAP.containsKey(bizType)) {
            return BIZTYPE_THREAD_MAP.get(bizType).getActiveThreadCount();
        }
        return 0;
    }
}

