/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.pigeon.PigeonQueueManager;
import kd.bos.pigeon.core.data.PigeonSequentialDTO;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;
import kd.bos.pigeon.dispatch.mservice.DispatchMServiceResponse;
import kd.bos.pigeon.dispatch.support.DispatchExecutionEnvironment;
import kd.bos.pigeon.dispatch.support.DispatchJobResult;
import kd.bos.pigeon.dispatch.support.DispatchJobResultType;
import kd.bos.pigeon.dispatch.support.DispatchTaskResultVO;
import kd.bos.pigeon.dispatch.tranformation.dto.DispatchTaskDTO;
import kd.bos.pigeon.dispatch.tranformation.filter.DispatchFilterChain;
import kd.bos.pigeon.dispatch.tranformation.lb.DispatchLoadbalance;
import kd.bos.pigeon.dispatch.tranformation.lb.DispatchLoadbalanceFactory;
import kd.bos.pigeon.dispatch.tranformation.route.DispatchRoute;
import kd.bos.pigeon.dispatch.tranformation.route.DispatchRouteFactory;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class DispatchDataStream<T> {
    private static final Log LOGGER = LogFactory.getLog(DispatchDataStream.class);
    private final DispatchExecutionEnvironment<T> env;
    private final String bizType;

    public DispatchDataStream(DispatchExecutionEnvironment<T> env) {
        this.env = env;
        this.bizType = env.getBizType();
    }

    public DispatchJobResult<T> collection(List<DispatchTaskDTO<T>> dataList) {
        try {
            return this.doCollection(dataList);
        }
        catch (Exception e) {
            LOGGER.error("doCollectionError", (Throwable)e);
            DispatchJobResult<T> dispatchJobResult = new DispatchJobResult<T>(dataList);
            dispatchJobResult.setJobResultType(DispatchJobResultType.NONE);
            return dispatchJobResult;
        }
    }

    private DispatchJobResult<T> doCollection(List<DispatchTaskDTO<T>> dataList) {
        DispatchJobResult<T> dispatchJobResult = new DispatchJobResult<T>(dataList);
        if (dataList.size() == 0) {
            dispatchJobResult.setJobResultType(DispatchJobResultType.NONE);
            return dispatchJobResult;
        }
        ArrayList<DispatchTaskDTO<T>> copyDataList = new ArrayList<DispatchTaskDTO<T>>(dataList.size());
        copyDataList.addAll(dataList);
        List<DispatchTaskResultVO<T>> taskResultList = dispatchJobResult.getResultList();
        int filterFailSum = 0;
        int routeFailSum = 0;
        HashMap<ServiceInfo, List> mservice2IndexMap = new HashMap<ServiceInfo, List>();
        for (int i = 0; i < copyDataList.size(); ++i) {
            DispatchTaskDTO tempTaskDTO = (DispatchTaskDTO)copyDataList.get(i);
            DispatchTaskResultVO tempResultVO = new DispatchTaskResultVO(tempTaskDTO);
            taskResultList.add(tempResultVO);
            DispatchFilterChain dispatchFilterChain = new DispatchFilterChain.Builder().build(this.bizType);
            dispatchFilterChain.doFilter(tempTaskDTO, tempResultVO);
            boolean isFilterSuccess = tempResultVO.getFilterResultVO().isSuccess();
            if (!isFilterSuccess) {
                ++filterFailSum;
                tempResultVO.setSuccess(false);
                tempResultVO.setFailTranformation(DispatchTaskResultVO.DispatchTaskFailTranformation.FILTER);
                tempResultVO.setMsg(tempResultVO.getFilterResultVO().getMsg());
                dispatchJobResult.getFailList().add(tempTaskDTO);
                dispatchJobResult.getFailIdSet().add(tempTaskDTO.getId());
                continue;
            }
            DispatchRoute dispatchRoute = DispatchRouteFactory.getDispatchRoute(this.bizType);
            List<ServiceInfo> mserviceInfoList = dispatchRoute.route(tempTaskDTO, tempResultVO);
            Boolean isSequential = null;
            boolean isRouteSuccess = tempResultVO.getRouteResultVO().isSuccess();
            if (!isRouteSuccess) {
                ++routeFailSum;
                tempResultVO.setSuccess(false);
                dispatchJobResult.getFailList().add(tempTaskDTO);
                dispatchJobResult.getFailIdSet().add(tempTaskDTO.getId());
                continue;
            }
            tempResultVO.setSuccess(true);
            isSequential = this.getQueueSequential(tempTaskDTO.getQueueName(), mserviceInfoList.get(0));
            DispatchLoadbalance dispatchLoadbalance = DispatchLoadbalanceFactory.getDispatchLoadbalance(this.bizType, isSequential);
            ServiceInfo targetServiceInfo = dispatchLoadbalance.select(mserviceInfoList, tempTaskDTO, tempResultVO);
            List indexList = mservice2IndexMap.computeIfAbsent(targetServiceInfo, key -> new ArrayList());
            indexList.add(i);
        }
        LOGGER.debug("doCollection,dataSum={},filterFailSum={},routeFailSum={}", new Object[]{copyDataList.size(), filterFailSum, routeFailSum});
        if (mservice2IndexMap.size() == 0) {
            dispatchJobResult.setJobResultType(DispatchJobResultType.NONE);
            return dispatchJobResult;
        }
        for (Map.Entry tempEntry : mservice2IndexMap.entrySet()) {
            ServiceInfo mserviceInfo = (ServiceInfo)tempEntry.getKey();
            List indexList = (List)tempEntry.getValue();
            this.doFirstDispatch(dispatchJobResult, copyDataList, taskResultList, mserviceInfo, indexList);
        }
        int failSize = dispatchJobResult.getFailList().size();
        if (failSize > 0) {
            dispatchJobResult.getFailList().removeIf(Objects::isNull);
            boolean failoverEnable = Boolean.parseBoolean(System.getProperty("mq.pigeon.dispatch.failover.enable", "true"));
            if (failoverEnable) {
                this.clusterFailoverDispatch(dispatchJobResult, copyDataList);
            }
            if ((failSize = dispatchJobResult.getFailList().size()) == 0) {
                dispatchJobResult.setJobResultType(DispatchJobResultType.ALL);
                return dispatchJobResult;
            }
            if (failSize == copyDataList.size()) {
                dispatchJobResult.setJobResultType(DispatchJobResultType.NONE);
            } else {
                dispatchJobResult.setJobResultType(DispatchJobResultType.MORETHANONE);
            }
            this.logFailResult(dispatchJobResult);
        } else {
            dispatchJobResult.setJobResultType(DispatchJobResultType.ALL);
        }
        return dispatchJobResult;
    }

    public DispatchJobResult<T> broadcastCollection(List<DispatchTaskDTO<T>> dataList, int maxBroadcastSize) {
        try {
            return this.doBroadcastCollection(dataList, maxBroadcastSize);
        }
        catch (Exception e) {
            LOGGER.error("doBroadcastCollection", (Throwable)e);
            DispatchJobResult<T> dispatchJobResult = new DispatchJobResult<T>(dataList);
            dispatchJobResult.setJobResultType(DispatchJobResultType.NONE);
            return dispatchJobResult;
        }
    }

    private DispatchJobResult<T> doBroadcastCollection(List<DispatchTaskDTO<T>> dataList, int maxBroadcastSize) {
        DispatchJobResult<T> dispatchJobResult = new DispatchJobResult<T>(dataList);
        if (dataList.size() == 0) {
            dispatchJobResult.setJobResultType(DispatchJobResultType.NONE);
            return dispatchJobResult;
        }
        ArrayList<DispatchTaskDTO<T>> copyDataList = new ArrayList<DispatchTaskDTO<T>>(dataList.size());
        copyDataList.addAll(dataList);
        List<DispatchTaskResultVO<T>> taskResultList = dispatchJobResult.getResultList();
        int filterFailSum = 0;
        int routeFailSum = 0;
        HashMap<ServiceInfo, List> mservice2IndexMap = new HashMap<ServiceInfo, List>();
        for (int i = 0; i < copyDataList.size(); ++i) {
            DispatchTaskDTO tempTaskDTO = (DispatchTaskDTO)copyDataList.get(i);
            DispatchTaskResultVO tempResultVO = new DispatchTaskResultVO(tempTaskDTO);
            taskResultList.add(tempResultVO);
            DispatchFilterChain dispatchFilterChain = new DispatchFilterChain.Builder().build(this.bizType);
            dispatchFilterChain.doFilter(tempTaskDTO, tempResultVO);
            boolean isFilterSuccess = tempResultVO.getFilterResultVO().isSuccess();
            if (!isFilterSuccess) {
                ++filterFailSum;
                tempResultVO.setSuccess(false);
                tempResultVO.setFailTranformation(DispatchTaskResultVO.DispatchTaskFailTranformation.FILTER);
                tempResultVO.setMsg(tempResultVO.getFilterResultVO().getMsg());
                dispatchJobResult.getFailList().add(tempTaskDTO);
                dispatchJobResult.getFailIdSet().add(tempTaskDTO.getId());
                continue;
            }
            DispatchRoute dispatchRoute = DispatchRouteFactory.getDispatchRoute(this.bizType);
            List<ServiceInfo> mserviceInfoList = dispatchRoute.route(tempTaskDTO, tempResultVO);
            Boolean isSequential = null;
            boolean isRouteSuccess = tempResultVO.getRouteResultVO().isSuccess();
            if (!isRouteSuccess) {
                ++routeFailSum;
                tempResultVO.setSuccess(false);
                dispatchJobResult.getFailList().add(tempTaskDTO);
                dispatchJobResult.getFailIdSet().add(tempTaskDTO.getId());
                continue;
            }
            Collections.shuffle(mserviceInfoList);
            isSequential = this.getQueueSequential(tempTaskDTO.getQueueName(), mserviceInfoList.get(0));
            if (isSequential.booleanValue()) {
                DispatchLoadbalance dispatchLoadbalance = DispatchLoadbalanceFactory.getDispatchLoadbalance(this.bizType, isSequential);
                ServiceInfo targetServiceInfo = dispatchLoadbalance.select(mserviceInfoList, tempTaskDTO, tempResultVO);
                List indexList = mservice2IndexMap.computeIfAbsent(targetServiceInfo, key -> new ArrayList());
                indexList.add(i);
                continue;
            }
            int tempMinBroadcastSize = Math.min(mserviceInfoList.size(), maxBroadcastSize);
            for (int j = 0; j < tempMinBroadcastSize; ++j) {
                ServiceInfo tempServiceInfo = mserviceInfoList.get(j);
                List indexList = mservice2IndexMap.computeIfAbsent(tempServiceInfo, key -> new ArrayList());
                indexList.add(i);
            }
        }
        LOGGER.debug("doBroadcastCollection,dataSum={},filterFailSum={},routeFailSum={}", new Object[]{copyDataList.size(), filterFailSum, routeFailSum});
        if (mservice2IndexMap.size() == 0) {
            dispatchJobResult.setJobResultType(DispatchJobResultType.NONE);
            return dispatchJobResult;
        }
        for (Map.Entry tempEntry : mservice2IndexMap.entrySet()) {
            ServiceInfo mserviceInfo = (ServiceInfo)tempEntry.getKey();
            List indexList = (List)tempEntry.getValue();
            this.doBroadcastDispatch(dispatchJobResult, copyDataList, taskResultList, mserviceInfo, indexList);
        }
        int failSize = dispatchJobResult.getFailList().size();
        if (failSize > 0) {
            dispatchJobResult.getFailList().removeIf(Objects::isNull);
            failSize = dispatchJobResult.getFailList().size();
            if (failSize == 0) {
                dispatchJobResult.setJobResultType(DispatchJobResultType.ALL);
                return dispatchJobResult;
            }
            if (failSize == copyDataList.size()) {
                dispatchJobResult.setJobResultType(DispatchJobResultType.NONE);
            } else {
                dispatchJobResult.setJobResultType(DispatchJobResultType.MORETHANONE);
            }
            this.logFailResult(dispatchJobResult);
        } else {
            dispatchJobResult.setJobResultType(DispatchJobResultType.ALL);
        }
        return dispatchJobResult;
    }

    private void logFailResult(DispatchJobResult<T> dispatchJobResult) {
        if (!LOGGER.isDebugEnabled() || dispatchJobResult.getJobResultType() == DispatchJobResultType.ALL) {
            return;
        }
        StringBuilder logStringBuilder = new StringBuilder();
        logStringBuilder.append("bizType:").append(this.bizType).append(",dispatchFailList:\n");
        List<DispatchTaskResultVO<T>> resultList = dispatchJobResult.getResultList();
        for (int i = 0; i < resultList.size(); ++i) {
            DispatchTaskResultVO<T> taskResultVO = resultList.get(i);
            if (taskResultVO.isSuccess()) continue;
            DispatchTaskDTO<T> tempTaskDTO = taskResultVO.getDispatchTaskDTO();
            long tempId = tempTaskDTO.getId();
            logStringBuilder.append("id=").append(tempId).append(",queue=").append(tempTaskDTO.getQueueName()).append(",failTranformation=").append(taskResultVO.getFailTranformation().getDesc());
            if (StringUtils.isNotEmpty((String)taskResultVO.getMsg())) {
                logStringBuilder.append(",msg=").append(taskResultVO.getMsg());
            }
            if (taskResultVO.getSortedMserviceInfoList() != null) {
                logStringBuilder.append(",sortedMserviceInfoList=").append(taskResultVO.getSortedMserviceInfoList());
            }
            logStringBuilder.append("\n");
        }
        LOGGER.debug(logStringBuilder.toString());
    }

    private void doFirstDispatch(DispatchJobResult<T> dispatchJobResult, List<DispatchTaskDTO<T>> copyDataList, List<DispatchTaskResultVO<T>> taskResultList, ServiceInfo serviceInfo, List<Integer> indexList) {
        ArrayList taskDTOList = new ArrayList(indexList.size());
        indexList.forEach(e -> taskDTOList.add(copyDataList.get((int)e)));
        String ipPort = serviceInfo.getIp() + ":" + serviceInfo.getRpcPort();
        Object responseObject = null;
        try {
            responseObject = EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)"kd.bos.pigeon.dispatch.mservice.DispatchServiceFacade", (String)"dispatch", (Object[])new Object[]{this.env.getBizType(), taskDTOList, indexList, PigeonQueueManager.getQueueSize((String)serviceInfo.getInstanceId())});
        }
        catch (Exception e2) {
            LOGGER.error("doFirstDispatchError,targetInstanceId:{},ipPort:{}", new Object[]{serviceInfo.getInstanceId(), ipPort, e2});
            indexList.forEach(index -> {
                DispatchTaskResultVO dispatchTaskResultVO = (DispatchTaskResultVO)taskResultList.get((int)index);
                dispatchTaskResultVO.setSuccess(false);
                dispatchTaskResultVO.setFailTranformation(DispatchTaskResultVO.DispatchTaskFailTranformation.RPC);
            });
            dispatchJobResult.getFailList().addAll(taskDTOList);
            taskDTOList.forEach(tempTaskDTO -> dispatchJobResult.getFailIdSet().add(tempTaskDTO.getId()));
        }
        if (responseObject != null) {
            DispatchMServiceResponse response = (DispatchMServiceResponse)responseObject;
            if (!response.isAllReceive()) {
                List<Integer> rejectIndexList = response.getRejectIndexList();
                List<DispatchTaskResultVO.DispatchTaskFailTranformation> rejectReasonList = response.getRejectReasonList();
                for (int i = 0; i < rejectIndexList.size(); ++i) {
                    Integer tempRejectIndex = rejectIndexList.get(i);
                    DispatchTaskResultVO.DispatchTaskFailTranformation failTranformation = rejectReasonList.get(i);
                    DispatchTaskResultVO<T> dispatchTaskResultVO = taskResultList.get(tempRejectIndex);
                    dispatchTaskResultVO.setSuccess(false);
                    dispatchTaskResultVO.setFailTranformation(failTranformation);
                    dispatchTaskResultVO.setMsg(failTranformation.getDesc());
                    dispatchJobResult.getFailList().add(copyDataList.get(tempRejectIndex));
                    dispatchJobResult.getFailIdSet().add(copyDataList.get(tempRejectIndex).getId());
                }
            }
            serviceInfo.setLastTaskQueueSize(response.getTaskQueueSize());
            if (!response.isCacheQueueSizeMatch()) {
                this.refreshQueueCache(serviceInfo);
            }
        }
    }

    private void refreshQueueCache(ServiceInfo serviceInfo) {
        if (Instance.isAppSplit()) {
            String appName = serviceInfo.getAppName();
            Set copyAllServiceInfoSet = ServiceInfoManager.getCopyAllServiceInfoSet();
            for (ServiceInfo tempServiceInfo : copyAllServiceInfoSet) {
                String tempAppName = Instance.getAppNameFromInstanceId((String)tempServiceInfo.getInstanceId());
                if (!appName.equals(tempAppName)) continue;
                Object responseObject = EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)"kd.bos.mq.pigeon.PigeonQueueManager", (String)"mserviceGetQueueNameSet", (Object[])new Object[0]);
                if (responseObject instanceof Set) {
                    Set queueNameSet = (Set)responseObject;
                    LOGGER.info("addQueueCacheBySet,instanceId={},queue={}", (Object)serviceInfo.getInstanceId(), (Object)queueNameSet);
                    PigeonQueueManager.cacheQueueNameSet((ServiceInfo)serviceInfo, (Set)queueNameSet);
                    continue;
                }
                if (!(responseObject instanceof List)) continue;
                List queueNameList = (List)responseObject;
                LOGGER.info("addQueueCacheByList,instanceId={},queue={}", (Object)serviceInfo.getInstanceId(), (Object)queueNameList);
                PigeonQueueManager.cacheQueueNameSet((ServiceInfo)serviceInfo, new HashSet(queueNameList));
            }
        } else {
            Object responseObject = EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)"kd.bos.mq.pigeon.PigeonQueueManager", (String)"mserviceGetQueueNameSet", (Object[])new Object[0]);
            if (responseObject instanceof Set) {
                Set queueNameSet = (Set)responseObject;
                LOGGER.info("addQueueCacheBySet,instanceId={},queue={}", (Object)serviceInfo.getInstanceId(), (Object)queueNameSet);
                PigeonQueueManager.cacheQueueNameSet((ServiceInfo)serviceInfo, (Set)queueNameSet);
            } else if (responseObject instanceof List) {
                List queueNameList = (List)responseObject;
                LOGGER.info("addQueueCacheByList,instanceId={},queue={}", (Object)serviceInfo.getInstanceId(), (Object)queueNameList);
                PigeonQueueManager.cacheQueueNameSet((ServiceInfo)serviceInfo, new HashSet(queueNameList));
            }
        }
    }

    private Boolean getQueueSequential(String queueRealName, ServiceInfo serviceInfo) {
        PigeonSequentialDTO pigeonSequentialDTO;
        Object responseObject;
        Boolean isSequentialBoolean = PigeonQueueManager.getQueueSequential((String)queueRealName);
        if (isSequentialBoolean == null && (responseObject = EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)"kd.bos.mq.pigeon.PigeonQueueManager", (String)"mserviceGetQueueSequential", (Object[])new Object[]{queueRealName})) != null && (pigeonSequentialDTO = (PigeonSequentialDTO)responseObject).isFind()) {
            isSequentialBoolean = pigeonSequentialDTO.getSequential();
            PigeonQueueManager.cacheQueueSequential((String)queueRealName, (Boolean)isSequentialBoolean);
        }
        return isSequentialBoolean;
    }

    private int clusterFailoverDispatch(DispatchJobResult<T> dispatchJobResult, List<DispatchTaskDTO<T>> copyDataList) {
        int totalRetryDispatchSize = 0;
        HashMap<ServiceInfo, List> mservice2IndexMap = new HashMap<ServiceInfo, List>();
        List<DispatchTaskResultVO<T>> resultList = dispatchJobResult.getResultList();
        for (int i = 0; i < resultList.size(); ++i) {
            List<ServiceInfo> sortedMserviceInfoList;
            DispatchTaskResultVO<T> taskResultVO = resultList.get(i);
            if (taskResultVO.isSuccess() || taskResultVO.getFailTranformation() == DispatchTaskResultVO.DispatchTaskFailTranformation.FILTER || taskResultVO.getFailTranformation() == DispatchTaskResultVO.DispatchTaskFailTranformation.ROUTE_NOSERVICE || taskResultVO.getFailTranformation() == DispatchTaskResultVO.DispatchTaskFailTranformation.ROUTE_NOCONSUMER || (sortedMserviceInfoList = taskResultVO.getSortedMserviceInfoList()).size() == 1) continue;
            ServiceInfo targetServiceInfo = sortedMserviceInfoList.get(1);
            List indexList = mservice2IndexMap.computeIfAbsent(targetServiceInfo, key -> new ArrayList());
            indexList.add(i);
        }
        for (Map.Entry tempEntry : mservice2IndexMap.entrySet()) {
            ServiceInfo mserviceInfo = (ServiceInfo)tempEntry.getKey();
            List indexList = (List)tempEntry.getValue();
            int retryDispatchSize = this.doFailoverDispatch(dispatchJobResult, copyDataList, dispatchJobResult.getResultList(), mserviceInfo, indexList);
            totalRetryDispatchSize += retryDispatchSize;
        }
        return totalRetryDispatchSize;
    }

    private int doFailoverDispatch(DispatchJobResult<T> dispatchJobResult, List<DispatchTaskDTO<T>> copyDataList, List<DispatchTaskResultVO<T>> taskResultList, ServiceInfo serviceInfo, List<Integer> indexList) {
        int retryDispatchSize = 0;
        ArrayList taskDTOList = new ArrayList(indexList.size());
        indexList.forEach(e -> taskDTOList.add(copyDataList.get((int)e)));
        String ipPort = serviceInfo.getIp() + ":" + serviceInfo.getRpcPort();
        Object responseObject = null;
        try {
            responseObject = EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)"kd.bos.pigeon.dispatch.mservice.DispatchServiceFacade", (String)"dispatch", (Object[])new Object[]{this.env.getBizType(), taskDTOList, indexList, PigeonQueueManager.getQueueSize((String)serviceInfo.getInstanceId())});
        }
        catch (Exception e2) {
            LOGGER.error("doFailoverDispatchError,targetInstanceId:{},ipPort:{}", new Object[]{serviceInfo.getInstanceId(), ipPort, e2});
            indexList.forEach(index -> {
                DispatchTaskResultVO dispatchTaskResultVO = (DispatchTaskResultVO)taskResultList.get((int)index);
                dispatchTaskResultVO.setSuccess(false);
                dispatchTaskResultVO.setFailTranformation(DispatchTaskResultVO.DispatchTaskFailTranformation.RPC);
            });
        }
        if (responseObject != null) {
            DispatchMServiceResponse response = (DispatchMServiceResponse)responseObject;
            List<Integer> receivedIndexList = response.getReceivedIndexList();
            if (CollectionUtils.isNotEmpty(receivedIndexList)) {
                retryDispatchSize = receivedIndexList.size();
                for (int i = 0; i < receivedIndexList.size(); ++i) {
                    Integer tempReceivedIndex = receivedIndexList.get(i);
                    DispatchTaskResultVO<T> taskResultVO = taskResultList.get(tempReceivedIndex);
                    taskResultVO.setSuccess(true);
                    taskResultVO.setFailTranformation(null);
                    taskResultVO.setMsg(null);
                    dispatchJobResult.getFailList().remove(copyDataList.get(tempReceivedIndex));
                    dispatchJobResult.getFailIdSet().remove(copyDataList.get(tempReceivedIndex).getId());
                }
            }
            List<Integer> rejectIndexList = response.getRejectIndexList();
            List<DispatchTaskResultVO.DispatchTaskFailTranformation> rejectReasonList = response.getRejectReasonList();
            if (CollectionUtils.isNotEmpty(rejectIndexList)) {
                for (int i = 0; i < rejectIndexList.size(); ++i) {
                    Integer tempRejectIndex = rejectIndexList.get(i);
                    DispatchTaskResultVO.DispatchTaskFailTranformation failTranformation = rejectReasonList.get(i);
                    DispatchTaskResultVO<T> dispatchTaskResultVO = taskResultList.get(tempRejectIndex);
                    dispatchTaskResultVO.setSuccess(false);
                    dispatchTaskResultVO.setFailTranformation(failTranformation);
                    dispatchTaskResultVO.setMsg(failTranformation.getDesc());
                }
            }
            serviceInfo.setLastTaskQueueSize(response.getTaskQueueSize());
            if (!response.isCacheQueueSizeMatch()) {
                this.refreshQueueCache(serviceInfo);
            }
        }
        return retryDispatchSize;
    }

    private void doBroadcastDispatch(DispatchJobResult<T> dispatchJobResult, List<DispatchTaskDTO<T>> copyDataList, List<DispatchTaskResultVO<T>> taskResultList, ServiceInfo serviceInfo, List<Integer> indexList) {
        indexList.removeIf(tempIndex -> ((DispatchTaskResultVO)taskResultList.get((int)tempIndex)).isSuccess());
        ArrayList taskDTOList = new ArrayList(indexList.size());
        indexList.forEach(e -> taskDTOList.add(copyDataList.get((int)e)));
        String ipPort = serviceInfo.getIp() + ":" + serviceInfo.getRpcPort();
        Object responseObject = null;
        try {
            responseObject = EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)"kd.bos.pigeon.dispatch.mservice.DispatchServiceFacade", (String)"dispatch", (Object[])new Object[]{this.env.getBizType(), taskDTOList, indexList, PigeonQueueManager.getQueueSize((String)serviceInfo.getInstanceId())});
        }
        catch (Exception e2) {
            LOGGER.error("doBroadcastDispatch,targetInstanceId:{},ipPort:{}", new Object[]{serviceInfo.getInstanceId(), ipPort, e2});
            indexList.forEach(index -> {
                DispatchTaskResultVO dispatchTaskResultVO = (DispatchTaskResultVO)taskResultList.get((int)index);
                dispatchTaskResultVO.setSuccess(false);
                dispatchTaskResultVO.setFailTranformation(DispatchTaskResultVO.DispatchTaskFailTranformation.RPC);
            });
            dispatchJobResult.getFailList().addAll(taskDTOList);
            taskDTOList.forEach(tempTaskDTO -> dispatchJobResult.getFailIdSet().add(tempTaskDTO.getId()));
        }
        if (responseObject != null) {
            DispatchMServiceResponse response = (DispatchMServiceResponse)responseObject;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("doBroadcastDispatchResponse,targetServiceInfo:{},isAllReceive:{},indexList:{},receivedIndexList:{},rejectIndexList:{}", new Object[]{serviceInfo.getIp() + ":" + serviceInfo.getRpcPort(), response.isAllReceive(), indexList, response.getReceivedIndexList(), response.getRejectIndexList()});
            }
            List<Integer> receivedIndexList = response.getReceivedIndexList();
            for (int i = 0; i < receivedIndexList.size(); ++i) {
                Integer tempReceivedIndex = receivedIndexList.get(i);
                DispatchTaskResultVO<T> dispatchTaskResultVO = taskResultList.get(tempReceivedIndex);
                dispatchTaskResultVO.setTargetServiceInfo(serviceInfo);
                dispatchTaskResultVO.setSuccess(true);
                dispatchTaskResultVO.setFailTranformation(null);
                dispatchTaskResultVO.setMsg(null);
                dispatchJobResult.getFailList().remove(copyDataList.get(tempReceivedIndex));
                dispatchJobResult.getFailIdSet().remove(copyDataList.get(tempReceivedIndex).getId());
            }
            if (!response.isAllReceive()) {
                List<Integer> rejectIndexList = response.getRejectIndexList();
                List<DispatchTaskResultVO.DispatchTaskFailTranformation> rejectReasonList = response.getRejectReasonList();
                for (int i = 0; i < rejectIndexList.size(); ++i) {
                    Integer tempRejectIndex = rejectIndexList.get(i);
                    DispatchTaskResultVO.DispatchTaskFailTranformation failTranformation = rejectReasonList.get(i);
                    DispatchTaskResultVO<T> dispatchTaskResultVO = taskResultList.get(tempRejectIndex);
                    dispatchTaskResultVO.setSuccess(false);
                    dispatchTaskResultVO.setFailTranformation(failTranformation);
                    dispatchTaskResultVO.setMsg(failTranformation.getDesc());
                    DispatchTaskDTO<T> tempTaskDTO2 = copyDataList.get(tempRejectIndex);
                    if (dispatchJobResult.getFailIdSet().contains(tempTaskDTO2.getId())) continue;
                    dispatchJobResult.getFailIdSet().add(tempTaskDTO2.getId());
                    dispatchJobResult.getFailList().add(tempTaskDTO2);
                }
            }
            serviceInfo.setLastTaskQueueSize(response.getTaskQueueSize());
            if (!response.isCacheQueueSizeMatch()) {
                this.refreshQueueCache(serviceInfo);
            }
        }
    }
}

