/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.support;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.pigeon.dispatch.source.DispatchDataStream;
import kd.bos.pigeon.dispatch.source.DispatchSourceFunction;
import kd.bos.pigeon.dispatch.support.DispatchExecutionEnvironmentManager;
import kd.bos.threads.ThreadPools;

public class DispatchExecutionEnvironment<T> {
    private static final Log LOGGER = LogFactory.getLog(DispatchExecutionEnvironment.class);
    private String bizType;
    private boolean localExecuteEnable = true;
    private Class<? extends DispatchSourceFunction<T>> sourceFunctionClass;
    private Map<String, DispatchSourceFunction<T>> accountId2sourceMap = new HashMap<String, DispatchSourceFunction<T>>();

    public DispatchExecutionEnvironment(String bizType) {
        this.bizType = bizType;
    }

    public String getBizType() {
        return this.bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public boolean isLocalExecuteEnable() {
        return this.localExecuteEnable;
    }

    public void setLocalExecuteEnable(boolean localExecuteEnable) {
        this.localExecuteEnable = localExecuteEnable;
    }

    public void setSourceFunctionClass(Class<? extends DispatchSourceFunction<T>> sourceFunctionClass) {
        this.sourceFunctionClass = sourceFunctionClass;
    }

    public void regist() {
        DispatchExecutionEnvironmentManager.registEnv(this.bizType, this);
    }

    public synchronized void execute(List<Account> accountList) {
        Set toAddAccountIdSet;
        Set currAccountIdSet = accountList.stream().map(Account::getAccountId).collect(Collectors.toCollection(HashSet::new));
        Set<String> lastAccountIdSet = this.accountId2sourceMap.keySet();
        Set toRemoveAccountIdSet = lastAccountIdSet.stream().filter(e -> !currAccountIdSet.contains(e)).collect(Collectors.toCollection(HashSet::new));
        if (toRemoveAccountIdSet.size() > 0) {
            for (String tempRemoveAccountId : toRemoveAccountIdSet) {
                DispatchSourceFunction<T> toRemoveSource = this.accountId2sourceMap.remove(tempRemoveAccountId);
                try {
                    LOGGER.info("stop dispatch source,accountId:{}", (Object)tempRemoveAccountId);
                    toRemoveSource.cancel();
                }
                catch (Throwable t) {
                    LOGGER.error("stop dispatch source error,accountId:{}", (Object)tempRemoveAccountId);
                }
            }
        }
        if ((toAddAccountIdSet = (Set)currAccountIdSet.stream().filter(e -> !lastAccountIdSet.contains(e)).collect(Collectors.toCollection(HashSet::new))).size() > 0) {
            for (String tempAddAccountId : toAddAccountIdSet) {
                try {
                    DispatchSourceFunction<T> tempSourceFunction = this.sourceFunctionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.accountId2sourceMap.put(tempAddAccountId, tempSourceFunction);
                    ThreadPools.executeOnce((String)("dispatchSourceTask_" + this.bizType + "_" + tempAddAccountId), () -> {
                        tempSourceFunction.init(this.bizType, AccountUtils.getAccountById((String)tempAddAccountId));
                        DispatchDataStream dispatchDataStream = new DispatchDataStream(this);
                        tempSourceFunction.run(dispatchDataStream);
                    });
                }
                catch (Exception e2) {
                    LOGGER.error("DispatchSourceFunctionInitError", (Throwable)e2);
                }
            }
        }
    }

    public void stop() {
        for (Map.Entry<String, DispatchSourceFunction<T>> tempEntry : this.accountId2sourceMap.entrySet()) {
            try {
                String tempAddAccountId = tempEntry.getKey();
                Account tempAccount = AccountUtils.getAccountById((String)tempAddAccountId);
                LOGGER.info("stop dispatch job,tenantId:{},accountId:{}", (Object)tempAccount.getTenantId(), (Object)tempAccount.getAccountId());
                tempEntry.getValue().cancel();
            }
            catch (Throwable t) {
                LOGGER.error("DispatchSourceFunctionStopError", t);
            }
        }
        this.accountId2sourceMap.clear();
    }
}

