/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.tranformation.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.pigeon.dispatch.support.DispatchOrderActivate;
import kd.bos.pigeon.dispatch.support.DispatchTaskResultVO;
import kd.bos.pigeon.dispatch.tranformation.dto.DispatchTaskDTO;
import kd.bos.pigeon.dispatch.tranformation.filter.DispatchFilter;

public class DispatchFilterChain {
    private List<DispatchFilter> filterList = new ArrayList<DispatchFilter>();
    private int size;
    private int pos;

    public void addFilter(DispatchFilter filter) {
        this.filterList.add(filter);
        this.size = this.filterList.size();
    }

    public void doFilter(DispatchTaskDTO<?> dispatchTaskDTO, DispatchTaskResultVO<?> dispatchTaskResultVO) {
        if (this.pos < this.size) {
            DispatchFilter filter = this.filterList.get(this.pos++);
            filter.doFilter(this, dispatchTaskDTO, dispatchTaskResultVO);
        }
    }

    public static class Builder {
        private static final Map<String, List<DispatchFilter>> bizType2filterListMap = new HashMap<String, List<DispatchFilter>>();

        public DispatchFilterChain build(String bizType) {
            DispatchFilterChain dispatchFilterChain = new DispatchFilterChain();
            List<DispatchFilter> filterList = bizType2filterListMap.get(bizType);
            if (filterList == null) {
                filterList = bizType2filterListMap.get("pigeon");
            }
            for (DispatchFilter tempFilter : filterList) {
                dispatchFilterChain.addFilter(tempFilter);
            }
            return dispatchFilterChain;
        }

        static {
            ArrayList<DispatchFilter> filterList = new ArrayList<DispatchFilter>();
            for (DispatchFilter tempDispatchFilter : ServiceLoader.load(DispatchFilter.class)) {
                DispatchOrderActivate tempDispatchOrderActivate = tempDispatchFilter.getClass().getDeclaredAnnotation(DispatchOrderActivate.class);
                if (tempDispatchOrderActivate == null) continue;
                filterList.add(tempDispatchFilter);
            }
            HashSet<String> bizTypeSet = new HashSet<String>();
            bizTypeSet.add("pigeon");
            filterList.sort(Comparator.comparingInt(c -> {
                DispatchOrderActivate tempDispatchOrderActivate = c.getClass().getDeclaredAnnotation(DispatchOrderActivate.class);
                if (!tempDispatchOrderActivate.bizType().equals("common")) {
                    bizTypeSet.add(tempDispatchOrderActivate.bizType());
                }
                return tempDispatchOrderActivate.order();
            }));
            for (String tempBizType : bizTypeSet) {
                bizType2filterListMap.computeIfAbsent(tempBizType, key -> new ArrayList());
            }
            for (DispatchFilter tempOrderDispatchFilter : filterList) {
                DispatchOrderActivate tempDispatchOrderActivate = tempOrderDispatchFilter.getClass().getDeclaredAnnotation(DispatchOrderActivate.class);
                String bizType = tempDispatchOrderActivate.bizType();
                if (bizType.equals("common")) {
                    for (String tempBizType : bizTypeSet) {
                        bizType2filterListMap.get(tempBizType).add(tempOrderDispatchFilter);
                    }
                    continue;
                }
                bizType2filterListMap.get(bizType).add(tempOrderDispatchFilter);
            }
        }
    }
}

