/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.tranformation.lb;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.extension.ExtensionFactory;
import kd.bos.pigeon.dispatch.support.DispatchActivate;
import kd.bos.pigeon.dispatch.tranformation.lb.DispatchLoadbalance;

public class DispatchLoadbalanceFactory {
    private static final String defaultLoadbalance = "minMessageSize";
    private static final Map<String, DispatchLoadbalance> bizType2loadbalanceMap = new HashMap<String, DispatchLoadbalance>();
    private static final ExtensionFactory<DispatchLoadbalance> loadbalanceExtensionFactory = ExtensionFactory.getExtensionFacotry(DispatchLoadbalance.class);

    public static DispatchLoadbalance getDispatchLoadbalance(String bizType, Boolean isSequential) {
        DispatchLoadbalance dispatchLoadbalance;
        if (isSequential.booleanValue()) {
            dispatchLoadbalance = (DispatchLoadbalance)loadbalanceExtensionFactory.getExtension("sequential");
        } else {
            dispatchLoadbalance = bizType2loadbalanceMap.get(bizType);
            if (dispatchLoadbalance == null) {
                dispatchLoadbalance = bizType2loadbalanceMap.get("pigeon");
            }
        }
        return dispatchLoadbalance;
    }

    static {
        for (DispatchLoadbalance tempDispatchLoadbalance : ServiceLoader.load(DispatchLoadbalance.class)) {
            DispatchActivate tempDispatchActivate = tempDispatchLoadbalance.getClass().getDeclaredAnnotation(DispatchActivate.class);
            if (tempDispatchActivate == null) continue;
            String tempBizType = tempDispatchActivate.bizType();
            if (tempBizType.equals("pigeon")) {
                if (!tempDispatchLoadbalance.name().equals(defaultLoadbalance)) continue;
                bizType2loadbalanceMap.putIfAbsent(tempBizType, tempDispatchLoadbalance);
                continue;
            }
            bizType2loadbalanceMap.putIfAbsent(tempBizType, tempDispatchLoadbalance);
        }
    }
}

