/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.tranformation.lb;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.dispatch.support.DispatchActivate;
import kd.bos.pigeon.dispatch.support.DispatchTaskResultVO;
import kd.bos.pigeon.dispatch.tranformation.dto.DispatchTaskDTO;
import kd.bos.pigeon.dispatch.tranformation.lb.AbstractDispatchLoadBalance;

@DispatchActivate
public class DispatchMinMessageSizeLoadBalance
extends AbstractDispatchLoadBalance {
    public static final String NAME = "minMessageSize";

    @Override
    protected ServiceInfo doSelect(List<ServiceInfo> mserviceInfoList, DispatchTaskDTO<?> dispatchTaskDTO, DispatchTaskResultVO<?> dispatchTaskResultVO) {
        boolean allQueueSizeZero = true;
        for (ServiceInfo tempServiceInfo : mserviceInfoList) {
            if (tempServiceInfo.getLastTaskQueueSize() <= 0) continue;
            allQueueSizeZero = false;
        }
        if (allQueueSizeZero) {
            Collections.shuffle(mserviceInfoList);
        } else {
            mserviceInfoList.sort(Comparator.comparingInt(ServiceInfo::getLastTaskQueueSize));
        }
        return mserviceInfoList.get(0);
    }

    @Override
    public String name() {
        return NAME;
    }
}

