/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.tranformation.route;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;
import kd.bos.pigeon.dispatch.support.DispatchTaskResultVO;
import kd.bos.pigeon.dispatch.tranformation.dto.DispatchTaskDTO;
import kd.bos.pigeon.dispatch.tranformation.route.DispatchRoute;

public abstract class AbstractDispatchRoute
implements DispatchRoute {
    private static final Log LOGGER = LogFactory.getLog(AbstractDispatchRoute.class);

    @Override
    public List<ServiceInfo> route(DispatchTaskDTO<?> dispatchTaskDTO, DispatchTaskResultVO<?> dispatchTaskResultVO) {
        if (PigeonConstant.LOCAL_SERVER_STANDALONE) {
            return Collections.singletonList(ServiceInfoManager.getCurrServiceInfo());
        }
        List<ServiceInfo> mserviceInfoList = this.doRoute(dispatchTaskDTO, dispatchTaskResultVO);
        if (mserviceInfoList == null) {
            dispatchTaskResultVO.getRouteResultVO().setSuccess(false);
        } else {
            boolean isContainsNull = mserviceInfoList.removeIf(Objects::isNull);
            if (isContainsNull && LOGGER.isDebugEnabled()) {
                String tempQueueName = dispatchTaskDTO.getQueueName();
                LOGGER.debug("queueServiceInfoSet contains null,please check,queueName:{}", (Object)tempQueueName);
            }
        }
        return mserviceInfoList;
    }

    public abstract List<ServiceInfo> doRoute(DispatchTaskDTO<?> var1, DispatchTaskResultVO<?> var2);
}

