/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.dispatch.tranformation.route;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.pigeon.PigeonQueueManager;
import kd.bos.pigeon.core.support.instance.ServiceEventListener;
import kd.bos.pigeon.core.support.instance.ServiceEventManager;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.pigeon.core.support.instance.ServiceInfoManager;
import kd.bos.pigeon.dispatch.support.DispatchActivate;
import kd.bos.pigeon.dispatch.support.DispatchTaskResultVO;
import kd.bos.pigeon.dispatch.tranformation.dto.DispatchTaskDTO;
import kd.bos.pigeon.dispatch.tranformation.route.AbstractDispatchRoute;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

@DispatchActivate
public class DefaultAppIdDispatchRoute
extends AbstractDispatchRoute {
    private static final Log LOGGER = LogFactory.getLog(DefaultAppIdDispatchRoute.class);
    public static final String NAME = "appId";
    private final AtomicBoolean isServiceInfoListener = new AtomicBoolean(false);

    @Override
    public List<ServiceInfo> doRoute(DispatchTaskDTO<?> dispatchTaskDTO, DispatchTaskResultVO<?> dispatchTaskResultVO) {
        if (this.isServiceInfoListener.compareAndSet(false, true)) {
            ServiceEventManager.registerListener((String)NAME, (ServiceEventListener)new ServiceEventListener(){

                public void serviceUp(ServiceInfo serviceInfo) {
                    LOGGER.info(serviceInfo.getInstanceId() + " up,addQueueCache");
                    DefaultAppIdDispatchRoute.this.addQueueCache(serviceInfo);
                }

                public void serviceDown(ServiceInfo serviceInfo) {
                    LOGGER.info(serviceInfo.getInstanceId() + " down,removeQueueCache");
                    DefaultAppIdDispatchRoute.this.removeQueueCache(serviceInfo);
                }
            });
        }
        String queueName = dispatchTaskDTO.getQueueName();
        boolean isAppSpilt = Instance.isAppSplit();
        String appId = dispatchTaskDTO.getAppId();
        if (!isAppSpilt || StringUtils.isEmpty((String)appId)) {
            Set<ServiceInfo> serviceInfoSet = this.getQueueServiceInfoSet(queueName, ServiceInfoManager.getCopyAllServiceInfoSet());
            if (CollectionUtils.isEmpty(serviceInfoSet)) {
                dispatchTaskResultVO.setFailTranformation(DispatchTaskResultVO.DispatchTaskFailTranformation.ROUTE_NOCONSUMER);
                return null;
            }
            return new ArrayList<ServiceInfo>(serviceInfoSet);
        }
        Set routeServiceInfoSet = ServiceInfoManager.getServiceInfoSetByAppId((String)appId);
        if (routeServiceInfoSet == null || routeServiceInfoSet.size() == 0) {
            dispatchTaskResultVO.setFailTranformation(DispatchTaskResultVO.DispatchTaskFailTranformation.ROUTE_NOSERVICE);
            return null;
        }
        Set<ServiceInfo> serviceInfoSet = this.getQueueServiceInfoSet(queueName, routeServiceInfoSet);
        if (CollectionUtils.isEmpty(serviceInfoSet)) {
            dispatchTaskResultVO.setFailTranformation(DispatchTaskResultVO.DispatchTaskFailTranformation.ROUTE_NOCONSUMER);
            return null;
        }
        return new ArrayList<ServiceInfo>(serviceInfoSet);
    }

    private void addQueueCache(ServiceInfo serviceInfo) {
        Object responseObject = EndPointInvokeServiceHelper.invoke((String)serviceInfo.getIp(), (String)serviceInfo.getRpcPort(), (String)"kd.bos.mq.pigeon.PigeonQueueManager", (String)"mserviceGetQueueNameSet", (Object[])new Object[0]);
        if (responseObject instanceof Set) {
            Set queueNameSet = (Set)responseObject;
            LOGGER.info("addQueueCacheBySet,instanceId={},queue={}", (Object)serviceInfo.getInstanceId(), (Object)queueNameSet);
            PigeonQueueManager.cacheQueueNameSet((ServiceInfo)serviceInfo, (Set)queueNameSet);
        } else if (responseObject instanceof List) {
            List queueNameList = (List)responseObject;
            LOGGER.info("addQueueCacheByList,instanceId={},queue={}", (Object)serviceInfo.getInstanceId(), (Object)queueNameList);
            PigeonQueueManager.cacheQueueNameSet((ServiceInfo)serviceInfo, new HashSet(queueNameList));
        }
    }

    private void removeQueueCache(ServiceInfo serviceInfo) {
        PigeonQueueManager.removeQueueNameSet((ServiceInfo)serviceInfo);
    }

    private Set<ServiceInfo> getQueueServiceInfoSet(String queueName, Set<ServiceInfo> routeServiceInfoSet) {
        Set cacheQueueServiceInfoSet = PigeonQueueManager.getQueueServiceInfoSet((String)queueName);
        if (CollectionUtils.isEmpty((Collection)cacheQueueServiceInfoSet)) {
            for (ServiceInfo tempRouteServiceInfo : routeServiceInfoSet) {
                this.addQueueCache(tempRouteServiceInfo);
            }
            cacheQueueServiceInfoSet = PigeonQueueManager.getQueueServiceInfoSet((String)queueName);
        }
        return cacheQueueServiceInfoSet;
    }

    @Override
    public String name() {
        return NAME;
    }
}

